/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.utils.helper.swing;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.tree.TreePath;
import org.netbeans.installer.utils.helper.swing.NbiTreeTableColumnCellRenderer;
import org.netbeans.installer.utils.helper.swing.NbiTreeTableColumnRenderer;
import org.netbeans.installer.utils.helper.swing.NbiTreeTableModel;

public class NbiTreeTable
extends JTable {
    private NbiTreeTableModel model;
    private NbiTreeTableColumnRenderer treeRenderer;
    private boolean mousePressedEventConsumed = false;

    public NbiTreeTable(NbiTreeTableModel model) {
        this.model = model;
        this.setTreeColumnRenderer(new NbiTreeTableColumnRenderer(this));
        model.setTree(this.treeRenderer);
        super.setModel(model);
        this.getColumnModel().getColumn(model.getTreeColumnIndex()).setCellRenderer(this.treeRenderer);
        this.setSelectionMode(0);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.treeRenderer != null) {
            this.treeRenderer.updateUI();
        }
    }

    @Override
    public void setRowHeight(int height) {
        super.setRowHeight(height);
        if (this.treeRenderer != null) {
            this.treeRenderer.setRowHeight(height);
        }
    }

    @Override
    public NbiTreeTableModel getModel() {
        return this.model;
    }

    public NbiTreeTableColumnRenderer getTreeColumnRenderer() {
        return this.treeRenderer;
    }

    public void setTreeColumnRenderer(NbiTreeTableColumnRenderer renderer) {
        this.treeRenderer = renderer;
        this.model.setTree(renderer);
        this.model.setTreeModel(renderer.getModel());
        this.treeRenderer.setRowHeight(this.getRowHeight());
    }

    public NbiTreeTableColumnCellRenderer getTreeColumnCellRenderer() {
        return this.treeRenderer.getTreeColumnCellRenderer();
    }

    public void setTreeColumnCellRenderer(NbiTreeTableColumnCellRenderer renderer) {
        this.treeRenderer.setTreeColumnCellRenderer(renderer);
    }

    @Override
    protected void processMouseEvent(MouseEvent event) {
        int column = this.columnAtPoint(event.getPoint());
        int row = this.rowAtPoint(event.getPoint());
        if (event.getID() == 502 && this.mousePressedEventConsumed) {
            this.mousePressedEventConsumed = false;
            event.consume();
            return;
        }
        if (this.mouseEventHitTreeHandle(event)) {
            this.mousePressedEventConsumed = true;
            event.consume();
            this.sendTreeHandleEvents(event);
            return;
        }
        this.mousePressedEventConsumed = false;
        super.processMouseEvent(event);
    }

    @Override
    protected void processKeyEvent(KeyEvent event) {
        int row;
        if (event.getID() == 402 && (row = this.getSelectedRow()) != -1) {
            if (event.getKeyCode() == 37) {
                if (this.treeRenderer.isExpanded(row)) {
                    this.treeRenderer.collapseRow(row);
                } else {
                    int parentRow = this.treeRenderer.getRowForPath(this.treeRenderer.getPathForRow(row).getParentPath());
                    this.treeRenderer.collapseRow(parentRow);
                    this.getSelectionModel().setSelectionInterval(parentRow, parentRow);
                }
                event.consume();
                return;
            }
            if (event.getKeyCode() == 39) {
                if (this.treeRenderer.isCollapsed(row)) {
                    this.treeRenderer.expandRow(row);
                }
                event.consume();
                return;
            }
        }
        super.processKeyEvent(event);
    }

    private boolean mouseEventHitTreeHandle(MouseEvent event) {
        if (event.getID() != 501) {
            return false;
        }
        int column = this.columnAtPoint(event.getPoint());
        int row = this.rowAtPoint(event.getPoint());
        if (column == this.model.getTreeColumnIndex()) {
            MouseEvent mousePressed = new MouseEvent(this.treeRenderer, 501, event.getWhen(), event.getModifiers(), event.getX() - this.getCellRect((int)row, (int)column, (boolean)true).x, event.getY(), event.getClickCount(), event.isPopupTrigger());
            MouseEvent mouseReleased = new MouseEvent(this.treeRenderer, 502, event.getWhen(), event.getModifiers(), event.getX() - this.getCellRect((int)row, (int)column, (boolean)true).x, event.getY(), event.getClickCount(), event.isPopupTrigger());
            TreePath targetPath = this.treeRenderer.getPathForRow(row);
            boolean currentState = this.treeRenderer.isExpanded(targetPath);
            this.model.consumeNextExpansionEvent();
            this.treeRenderer.dispatchEvent(mousePressed);
            this.treeRenderer.dispatchEvent(mouseReleased);
            if (this.treeRenderer.isExpanded(targetPath) == currentState) {
                this.model.cancelConsume();
                return false;
            }
            this.model.consumeNextExpansionEvent();
            this.treeRenderer.dispatchEvent(mousePressed);
            this.treeRenderer.dispatchEvent(mouseReleased);
            return true;
        }
        return false;
    }

    private void sendTreeHandleEvents(MouseEvent event) {
        int column = this.model.getTreeColumnIndex();
        int row = this.rowAtPoint(event.getPoint());
        MouseEvent mousePressed = new MouseEvent(this.treeRenderer, 501, event.getWhen(), event.getModifiers(), event.getX() - this.getCellRect((int)row, (int)column, (boolean)true).x, event.getY(), event.getClickCount(), event.isPopupTrigger());
        MouseEvent mouseReleased = new MouseEvent(this.treeRenderer, 502, event.getWhen(), event.getModifiers(), event.getX() - this.getCellRect((int)row, (int)column, (boolean)true).x, event.getY(), event.getClickCount(), event.isPopupTrigger());
        this.treeRenderer.dispatchEvent(mousePressed);
        this.treeRenderer.dispatchEvent(mouseReleased);
    }
}

