/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.utils.helper.swing;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.table.TableCellRenderer;
import org.netbeans.installer.utils.helper.swing.NbiTreeTable;
import org.netbeans.installer.utils.helper.swing.NbiTreeTableColumnCellRenderer;

public class NbiTreeTableColumnRenderer
extends JTree
implements TableCellRenderer {
    private NbiTreeTable treeTable;
    private int visibleRow = 0;
    private NbiTreeTableColumnCellRenderer cellRenderer;

    public NbiTreeTableColumnRenderer(NbiTreeTable treeTable) {
        this.treeTable = treeTable;
        this.setModel(treeTable.getModel().getTreeModel());
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setTreeColumnCellRenderer(new NbiTreeTableColumnCellRenderer(treeTable));
        this.setRowHeight(treeTable.getRowHeight());
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
        this.visibleRow = row;
        if (selected) {
            this.setOpaque(true);
            this.setBackground(this.treeTable.getSelectionBackground());
            this.setForeground(this.treeTable.getSelectionForeground());
        } else {
            this.setOpaque(false);
            this.setBackground(this.treeTable.getBackground());
            this.setForeground(this.treeTable.getForeground());
        }
        return this;
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        if (this.treeTable != null) {
            super.setBounds(x, 0, w, this.treeTable.getHeight());
        } else {
            super.setBounds(x, y, w, h);
        }
    }

    @Override
    public void paint(Graphics g) {
        g.translate(0, -this.visibleRow * this.getRowHeight());
        super.paint(g);
    }

    public NbiTreeTableColumnCellRenderer getTreeColumnCellRenderer() {
        return this.cellRenderer;
    }

    public void setTreeColumnCellRenderer(NbiTreeTableColumnCellRenderer renderer) {
        this.cellRenderer = renderer;
        this.setCellRenderer(renderer);
    }
}

