/**************************************************************************
**
** This file is part of Qt Creator
**
** Copyright (c) 2011 Nokia Corporation and/or its subsidiary(-ies).
**
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** No Commercial Usage
**
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
**
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights.  These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** Nokia at qt-info@nokia.com.
**
**************************************************************************/

#include "singleselectionmanipulator.h"
#include "qdeclarativeviewobserver.h"
#include "../qdeclarativeviewobserver_p.h"
#include <QtDebug>

namespace QmlJSDebugger {

SingleSelectionManipulator::SingleSelectionManipulator(QDeclarativeViewObserver *editorView)
    : m_editorView(editorView),
    m_isActive(false)
{
}


void SingleSelectionManipulator::begin(const QPointF &beginPoint)
{
    m_beginPoint = beginPoint;
    m_isActive = true;
    m_oldSelectionList = QDeclarativeViewObserverPrivate::get(m_editorView)->selectedItems();
}

void SingleSelectionManipulator::update(const QPointF &/*updatePoint*/)
{
    m_oldSelectionList.clear();
}

void SingleSelectionManipulator::clear()
{
    m_beginPoint = QPointF();
    m_oldSelectionList.clear();
}


void SingleSelectionManipulator::end(const QPointF &/*updatePoint*/)
{
    m_oldSelectionList.clear();
    m_isActive = false;
}

void SingleSelectionManipulator::select(SelectionType selectionType, const QList<QGraphicsItem*> &items, bool /*selectOnlyContentItems*/)
{
    QGraphicsItem *selectedItem = 0;

    foreach(QGraphicsItem* item, items)
    {
        //FormEditorItem *formEditorItem = FormEditorItem::fromQGraphicsItem(item);
        if (item
           /*&& !formEditorItem->qmlItemNode().isRootNode()
           && (formEditorItem->qmlItemNode().hasShowContent() || !selectOnlyContentItems)*/)
        {
            selectedItem = item;
            break;
        }
    }

    QList<QGraphicsItem*> resultList;

    switch(selectionType) {
        case AddToSelection: {
            resultList.append(m_oldSelectionList);
            if (selectedItem && !m_oldSelectionList.contains(selectedItem))
                resultList.append(selectedItem);
        }
        break;
        case ReplaceSelection: {
            if (selectedItem)
                resultList.append(selectedItem);
        }
        break;
        case RemoveFromSelection: {
            resultList.append(m_oldSelectionList);
            if (selectedItem)
                resultList.removeAll(selectedItem);
        }
        break;
        case InvertSelection: {
            if (selectedItem
                && !m_oldSelectionList.contains(selectedItem))
            {
                resultList.append(selectedItem);
            }
        }
    }

    m_editorView->setSelectedItems(resultList);
}

void SingleSelectionManipulator::select(SelectionType selectionType, bool selectOnlyContentItems)
{
    QList<QGraphicsItem*> itemList = QDeclarativeViewObserverPrivate::get(m_editorView)->selectableItems(m_beginPoint);
    select(selectionType, itemList, selectOnlyContentItems);
}


bool SingleSelectionManipulator::isActive() const
{
    return m_isActive;
}

QPointF SingleSelectionManipulator::beginPoint() const
{
    return m_beginPoint;
}

}
