/****************************************************************************
**
** Copyright (C) 2015 The Qt Company Ltd.
** Contact: http://www.qt.io/licensing
**
** This file is part of Qt Creator.
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company.  For licensing terms and
** conditions see http://www.qt.io/terms-conditions.  For further information
** use the contact form at http://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3.0 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPLv3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU General Public License version 3.0 requirements will be
** met: http://www.gnu.org/copyleft/gpl.html.
**
****************************************************************************/

#ifndef DESIGNMODECONTEXT_H
#define DESIGNMODECONTEXT_H

#include <coreplugin/icontext.h>

namespace QmlDesigner {
namespace Internal {

/**
  * Bauhaus Design mode context object
  */
class DesignModeContext : public Core::IContext
{
public:
    DesignModeContext(QWidget *widget);
    QString contextHelpId() const;
};

class FormEditorContext : public Core::IContext
{
public:
    FormEditorContext(QWidget *widget);
    QString contextHelpId() const;
};

class NavigatorContext : public Core::IContext
{
public:
    NavigatorContext(QWidget *widget);
    QString contextHelpId() const;
};

}
}

#endif // DESIGNMODECONTEXT_H
