/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.deps.DependencyInfo;
import com.google.javascript.jscomp.deps.Es6SortedDependencies;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class JSModule
extends DependencyInfo.Base
implements Serializable {
    public static final String STRONG_MODULE_NAME = "$strong$";
    public static final String WEAK_MODULE_NAME = "$weak$";
    private static final long serialVersionUID = 1L;
    private String name;
    private final List<CompilerInput> inputs = new ArrayList<CompilerInput>();
    private final List<JSModule> deps = new ArrayList<JSModule>();
    private int depth;
    private int index;

    public JSModule(String name) {
        this.name = name;
        this.depth = -1;
        this.index = -1;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public ImmutableList<String> getProvides() {
        return ImmutableList.of(this.name);
    }

    @Override
    public boolean getHasExternsAnnotation() {
        return false;
    }

    @Override
    public boolean getHasNoCompileAnnotation() {
        return false;
    }

    @Override
    public ImmutableList<DependencyInfo.Require> getRequires() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (JSModule m : this.deps) {
            builder.add(DependencyInfo.Require.compilerModule(m.getName()));
        }
        return builder.build();
    }

    @Override
    public ImmutableList<String> getTypeRequires() {
        return ImmutableList.of();
    }

    @Override
    public String getPathRelativeToClosureBase() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ImmutableMap<String, String> getLoadFlags() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isModule() {
        throw new UnsupportedOperationException();
    }

    public void add(SourceFile file) {
        this.add(new CompilerInput(file));
    }

    public void add(CompilerInput input) {
        this.inputs.add(input);
        input.setModule(this);
    }

    void addAndOverrideModule(CompilerInput input) {
        this.inputs.add(input);
        input.overrideModule(this);
    }

    public void addAfter(CompilerInput input, CompilerInput other) {
        Preconditions.checkState(this.inputs.contains(other));
        this.inputs.add(this.inputs.indexOf(other), input);
        input.setModule(this);
    }

    public void addDependency(JSModule dep) {
        Preconditions.checkNotNull(dep);
        Preconditions.checkState(dep != this, "Cannot add dependency on self", (Object)this);
        this.deps.add(dep);
    }

    public void remove(CompilerInput input) {
        input.setModule(null);
        this.inputs.remove(input);
    }

    public void removeAll() {
        for (CompilerInput input : this.inputs) {
            input.setModule(null);
        }
        this.inputs.clear();
    }

    public ImmutableList<JSModule> getDependencies() {
        return ImmutableList.copyOf(this.deps);
    }

    List<String> getSortedDependencyNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (JSModule module : this.getDependencies()) {
            names.add(module.getName());
        }
        Collections.sort(names);
        return names;
    }

    public Set<JSModule> getAllDependencies() {
        Set<JSModule> allDeps = Sets.newIdentityHashSet();
        allDeps.addAll(this.deps);
        ArrayDeque<JSModule> stack = new ArrayDeque<JSModule>(this.deps);
        while (!stack.isEmpty()) {
            JSModule module = stack.pop();
            List<JSModule> moduleDeps = module.deps;
            for (JSModule dep : moduleDeps) {
                if (!allDeps.add(dep)) continue;
                stack.push(dep);
            }
        }
        return allDeps;
    }

    public Set<JSModule> getThisAndAllDependencies() {
        Set<JSModule> deps = this.getAllDependencies();
        deps.add(this);
        return deps;
    }

    public int getInputCount() {
        return this.inputs.size();
    }

    public CompilerInput getInput(int i) {
        return this.inputs.get(i);
    }

    public List<CompilerInput> getInputs() {
        return this.inputs;
    }

    public CompilerInput getByName(String name) {
        for (CompilerInput input : this.inputs) {
            if (!name.equals(input.getName())) continue;
            return input;
        }
        return null;
    }

    public boolean removeByName(String name) {
        boolean found = false;
        Iterator<CompilerInput> iter = this.inputs.iterator();
        while (iter.hasNext()) {
            CompilerInput file = iter.next();
            if (!name.equals(file.getName())) continue;
            iter.remove();
            file.setModule(null);
            found = true;
        }
        return found;
    }

    public boolean isSynthetic() {
        return this.name.equals(STRONG_MODULE_NAME) || this.name.equals(WEAK_MODULE_NAME);
    }

    public String toString() {
        return this.name;
    }

    public void sortInputsByDeps(AbstractCompiler compiler) {
        for (CompilerInput input : this.inputs) {
            input.setCompiler(compiler);
        }
        List<CompilerInput> sortedList = new Es6SortedDependencies<CompilerInput>(this.inputs).getSortedList();
        this.inputs.clear();
        this.inputs.addAll(sortedList);
    }

    public void setDepth(int dep) {
        Preconditions.checkArgument(dep >= 0, "invalid depth: %s", dep);
        this.depth = dep;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setIndex(int index) {
        Preconditions.checkArgument(index >= 0, "Invalid module index: %s", index);
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }
}

