/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckSideEffects;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.ModuleImportResolver;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.PolymerBehaviorExtractor;
import com.google.javascript.jscomp.PolymerClassDefinition;
import com.google.javascript.jscomp.PolymerExportPolicy;
import com.google.javascript.jscomp.PolymerPass;
import com.google.javascript.jscomp.PolymerPassErrors;
import com.google.javascript.jscomp.PolymerPassStaticUtils;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

final class PolymerClassRewriter {
    private static final String VIRTUAL_FILE = "<PolymerClassRewriter.java>";
    private final AbstractCompiler compiler;
    private final int polymerVersion;
    private final PolymerExportPolicy polymerExportPolicy;
    private final boolean propertyRenamingEnabled;
    @VisibleForTesting
    static final String POLYMER_ELEMENT_PROP_CONFIG = "PolymerElementProperties";
    private final Node polymerElementExterns;
    boolean propertySinkExternInjected = false;

    PolymerClassRewriter(AbstractCompiler compiler, Node polymerElementExterns, int polymerVersion, PolymerExportPolicy polymerExportPolicy, boolean propertyRenamingEnabled) {
        this.compiler = compiler;
        this.polymerElementExterns = polymerElementExterns;
        this.polymerVersion = polymerVersion;
        this.polymerExportPolicy = polymerExportPolicy;
        this.propertyRenamingEnabled = propertyRenamingEnabled;
    }

    void rewritePolymerCall(Node exprRoot, PolymerClassDefinition cls, boolean isInGlobalOrModuleScope) {
        Node props;
        Node scriptNode;
        FeatureSet oldFeatures;
        FeatureSet newFeatures;
        Node objLit = Preconditions.checkNotNull(cls.descriptor);
        JSDocInfoBuilder objLitDoc = new JSDocInfoBuilder(true);
        JSTypeExpression jsTypeExpression = new JSTypeExpression(IR.string(cls.target.getQualifiedName() + ".prototype"), exprRoot.getSourceFileName());
        objLitDoc.recordLends(jsTypeExpression);
        objLit.setJSDocInfo(objLitDoc.build());
        this.addTypesToFunctions(objLit, cls.target.getQualifiedName(), cls.defType);
        PolymerPassStaticUtils.switchDollarSignPropsToBrackets(objLit, this.compiler);
        PolymerPassStaticUtils.quoteListenerAndHostAttributeKeys(objLit, this.compiler);
        for (PolymerPass.MemberDefinition prop : cls.props) {
            if (!prop.value.isObjectLit()) continue;
            PolymerPassStaticUtils.switchDollarSignPropsToBrackets(prop.value, this.compiler);
        }
        Node block = IR.block();
        JSDocInfoBuilder constructorDoc = this.getConstructorDoc(cls);
        Node ctorKey = cls.constructor.value.getParent();
        if (ctorKey != null) {
            ctorKey.removeProp(Node.JSDOC_INFO_PROP);
        }
        if (cls.target.isGetProp()) {
            Node assign = IR.assign(cls.target.cloneTree(), cls.constructor.value.cloneTree());
            NodeUtil.markNewScopesChanged(assign, this.compiler);
            assign.setJSDocInfo(constructorDoc.build());
            Node exprResult = IR.exprResult(assign);
            exprResult.useSourceInfoIfMissingFromForTree(cls.target);
            block.addChildToBack(exprResult);
        } else {
            Node var = IR.var(cls.target.cloneTree(), cls.constructor.value.cloneTree());
            NodeUtil.markNewScopesChanged(var, this.compiler);
            var.useSourceInfoIfMissingFromForTree(exprRoot);
            var.setJSDocInfo(constructorDoc.build());
            block.addChildToBack(var);
        }
        this.appendPropertiesToBlock(cls.props, block, cls.target.getQualifiedName() + ".prototype.");
        this.appendBehaviorMembersToBlock(cls, block);
        ImmutableList<PolymerPass.MemberDefinition> readOnlyProps = this.parseReadOnlyProperties(cls, block);
        ImmutableList<PolymerPass.MemberDefinition> attributeReflectedProps = this.parseAttributeReflectedProperties(cls);
        this.createExportsAndExterns(cls, readOnlyProps, attributeReflectedProps);
        this.removePropertyDocs(objLit, PolymerClassDefinition.DefinitionType.ObjectLiteral);
        Node statements = block.removeChildren();
        Node parent = exprRoot.getParent();
        if (!isInGlobalOrModuleScope && !cls.target.isGetProp()) {
            Node scriptOrModuleNode = NodeUtil.getEnclosingNode(parent, node -> node.isScript() || node.isModuleBody());
            if (scriptOrModuleNode.isModuleBody() && scriptOrModuleNode.getParent().getBooleanProp(Node.GOOG_MODULE)) {
                Node insertionPoint = PolymerClassRewriter.getInsertionPointForGoogModule(scriptOrModuleNode);
                scriptOrModuleNode.addChildrenAfter(statements, insertionPoint);
            } else {
                scriptOrModuleNode.addChildrenToFront(statements);
                this.compiler.reportChangeToChangeScope(NodeUtil.getEnclosingScript(scriptOrModuleNode));
            }
        } else {
            Node beforeRoot = exprRoot.getPrevious();
            if (beforeRoot == null) {
                parent.addChildrenToFront(statements);
            } else {
                parent.addChildrenAfter(statements, beforeRoot);
            }
            this.compiler.reportChangeToEnclosingScope(parent);
        }
        this.compiler.reportChangeToEnclosingScope(statements);
        if (cls.features != null && !(newFeatures = (oldFeatures = (FeatureSet)(scriptNode = NodeUtil.getEnclosingScript(parent)).getProp(Node.FEATURE_SET)).union(cls.features)).equals(oldFeatures)) {
            scriptNode.putProp(Node.FEATURE_SET, newFeatures);
            this.compiler.reportChangeToChangeScope(scriptNode);
        }
        if (NodeUtil.isNameDeclaration(exprRoot)) {
            Node assignExpr = PolymerClassRewriter.varToAssign(exprRoot);
            parent.replaceChild(exprRoot, assignExpr);
            this.compiler.reportChangeToEnclosingScope(assignExpr);
        }
        if (this.polymerVersion > 1 && this.propertyRenamingEnabled && cls.descriptor != null && (props = NodeUtil.getFirstPropMatchingKey(cls.descriptor, "properties")) != null && props.isObjectLit()) {
            this.addPropertiesConfigObjectReflection(cls, props);
        }
    }

    void rewritePolymerClassDeclaration(Node clazz, NodeTraversal traversal, PolymerClassDefinition cls) {
        if (cls.descriptor != null) {
            this.addTypesToFunctions(cls.descriptor, cls.target.getQualifiedName(), cls.defType);
        }
        PolymerPassStaticUtils.switchDollarSignPropsToBrackets(NodeUtil.getClassMembers(clazz), this.compiler);
        for (PolymerPass.MemberDefinition prop : cls.props) {
            if (!prop.value.isObjectLit()) continue;
            PolymerPassStaticUtils.switchDollarSignPropsToBrackets(prop.value, this.compiler);
        }
        Node block = IR.block();
        this.appendPropertiesToBlock(cls.props, block, cls.target.getQualifiedName() + ".prototype.");
        ImmutableList<PolymerPass.MemberDefinition> readOnlyProps = this.parseReadOnlyProperties(cls, block);
        ImmutableList<PolymerPass.MemberDefinition> attributeReflectedProps = this.parseAttributeReflectedProperties(cls);
        this.createExportsAndExterns(cls, readOnlyProps, attributeReflectedProps);
        if (this.polymerExportPolicy == PolymerExportPolicy.EXPORT_ALL || !readOnlyProps.isEmpty() || !attributeReflectedProps.isEmpty()) {
            Node jsDocInfoNode = NodeUtil.getBestJSDocInfoNode(clazz);
            JSDocInfoBuilder classInfo = JSDocInfoBuilder.maybeCopyFrom(jsDocInfoNode.getJSDocInfo());
            String interfaceName = PolymerClassRewriter.getInterfaceName(cls);
            JSTypeExpression interfaceType = new JSTypeExpression(new Node(Token.BANG, IR.string(interfaceName)), VIRTUAL_FILE);
            classInfo.recordImplementedInterface(interfaceType);
            jsDocInfoNode.setJSDocInfo(classInfo.build());
        }
        Node insertAfterReference = NodeUtil.getEnclosingStatement(clazz);
        if (block.hasChildren()) {
            this.removePropertyDocs(cls.descriptor, cls.defType);
            Node newInsertAfterReference = block.getLastChild();
            insertAfterReference.getParent().addChildrenAfter(block.removeChildren(), insertAfterReference);
            this.compiler.reportChangeToEnclosingScope(insertAfterReference);
            insertAfterReference = newInsertAfterReference;
        }
        this.addReturnTypeIfMissing(cls, "is", new JSTypeExpression(IR.string("string"), VIRTUAL_FILE));
        Node type = new Node(Token.BANG);
        Node array = IR.string("Array");
        type.addChildToBack(array);
        Node arrayTemplateType = new Node(Token.BLOCK, IR.string("string"));
        array.addChildToBack(arrayTemplateType);
        this.addReturnTypeIfMissing(cls, "observers", new JSTypeExpression(type, VIRTUAL_FILE));
        this.addReturnTypeIfMissing(cls, "properties", new JSTypeExpression(IR.string(POLYMER_ELEMENT_PROP_CONFIG), VIRTUAL_FILE));
        if (this.propertyRenamingEnabled && cls.descriptor != null) {
            this.convertSimpleObserverStringsToReferences(cls);
            ArrayList<Node> propertySinks = new ArrayList<Node>();
            if (this.polymerExportPolicy != PolymerExportPolicy.EXPORT_ALL) {
                propertySinks.addAll(this.addComputedPropertiesReflectionCalls(cls));
                propertySinks.addAll(this.addComplexObserverReflectionCalls(cls));
            }
            if (propertySinks.size() > 0) {
                if (!this.propertySinkExternInjected && traversal.getScope().getVar("JSCOMPILER_PRESERVE") == null) {
                    CheckSideEffects.addExtern(this.compiler);
                    this.propertySinkExternInjected = true;
                }
                for (Node propertyRef : propertySinks) {
                    Node name = IR.name("JSCOMPILER_PRESERVE").srcref(propertyRef);
                    name.putBooleanProp(Node.IS_CONSTANT_NAME, true);
                    Node protectorCall = IR.call(name, propertyRef).srcref(propertyRef);
                    protectorCall.putBooleanProp(Node.FREE_CALL, true);
                    protectorCall = IR.exprResult(protectorCall).useSourceInfoFrom(propertyRef);
                    insertAfterReference.getParent().addChildAfter(protectorCall, insertAfterReference);
                    insertAfterReference = protectorCall;
                }
                this.compiler.reportChangeToEnclosingScope(insertAfterReference);
            }
            this.addPropertiesConfigObjectReflection(cls, cls.descriptor);
        }
    }

    private void addReturnTypeIfMissing(PolymerClassDefinition cls, String getterPropName, JSTypeExpression jsType) {
        JSDocInfo info;
        Node classMembers = NodeUtil.getClassMembers(cls.definition);
        Node getter = NodeUtil.getFirstGetterMatchingKey(classMembers, getterPropName);
        if (!(getter == null || (info = NodeUtil.getBestJSDocInfo(getter)) != null && info.hasReturnType())) {
            JSDocInfoBuilder builder = JSDocInfoBuilder.maybeCopyFrom(info);
            builder.recordReturnType(jsType);
            getter.setJSDocInfo(builder.build());
        }
    }

    private void addPropertiesConfigObjectReflection(PolymerClassDefinition cls, Node propertiesLiteral) {
        Preconditions.checkNotNull(propertiesLiteral);
        Preconditions.checkState(propertiesLiteral.isObjectLit());
        Node parent = propertiesLiteral.getParent();
        Node objReflectCall = IR.call(NodeUtil.newQName(this.compiler, "$jscomp.reflectObject"), cls.target.cloneTree(), propertiesLiteral.detach()).useSourceInfoIfMissingFromForTree(propertiesLiteral);
        parent.addChildToFront(objReflectCall);
        this.compiler.reportChangeToEnclosingScope(parent);
    }

    private void addTypesToFunctions(Node objLit, String thisType, PolymerClassDefinition.DefinitionType defType) {
        Preconditions.checkState(objLit.isObjectLit());
        for (Node keyNode : objLit.children()) {
            Node value = keyNode.getLastChild();
            if (value == null || !value.isFunction()) continue;
            JSDocInfoBuilder fnDoc = JSDocInfoBuilder.maybeCopyFrom(keyNode.getJSDocInfo());
            fnDoc.recordThisType(new JSTypeExpression(new Node(Token.BANG, IR.string(thisType)), VIRTUAL_FILE));
            keyNode.setJSDocInfo(fnDoc.build());
        }
        for (PolymerPass.MemberDefinition property : PolymerPassStaticUtils.extractProperties(objLit, defType, this.compiler, null)) {
            Node defaultValue;
            if (!property.value.isObjectLit() || (defaultValue = NodeUtil.getFirstPropMatchingKey(property.value, "value")) == null || !defaultValue.isFunction()) continue;
            Node defaultValueKey = defaultValue.getParent();
            JSDocInfoBuilder fnDoc = JSDocInfoBuilder.maybeCopyFrom(defaultValueKey.getJSDocInfo());
            fnDoc.recordThisType(new JSTypeExpression(new Node(Token.BANG, IR.string(thisType)), VIRTUAL_FILE));
            fnDoc.recordReturnType(PolymerPassStaticUtils.getTypeFromProperty(property, this.compiler));
            defaultValueKey.setJSDocInfo(fnDoc.build());
        }
    }

    private ImmutableList<PolymerPass.MemberDefinition> parseReadOnlyProperties(PolymerClassDefinition cls, Node block) {
        String qualifiedPath = cls.target.getQualifiedName() + ".prototype.";
        ImmutableList.Builder readOnlyProps = ImmutableList.builder();
        for (PolymerPass.MemberDefinition prop : cls.props) {
            Node readOnlyValue;
            if (!prop.value.isObjectLit() || (readOnlyValue = NodeUtil.getFirstPropMatchingKey(prop.value, "readOnly")) == null || !readOnlyValue.isTrue()) continue;
            Node setter = this.makeReadOnlySetter(prop.name.getString(), qualifiedPath);
            setter.useSourceInfoIfMissingFromForTree(prop.name);
            block.addChildToBack(setter);
            readOnlyProps.add(prop);
        }
        return readOnlyProps.build();
    }

    private ImmutableList<PolymerPass.MemberDefinition> parseAttributeReflectedProperties(PolymerClassDefinition cls) {
        ImmutableList.Builder attrReflectedProps = ImmutableList.builder();
        for (PolymerPass.MemberDefinition prop : cls.props) {
            Node reflectedValue;
            if (!prop.value.isObjectLit() || (reflectedValue = NodeUtil.getFirstPropMatchingKey(prop.value, "reflectToAttribute")) == null || !reflectedValue.isTrue()) continue;
            attrReflectedProps.add(prop);
        }
        return attrReflectedProps.build();
    }

    private JSDocInfoBuilder getConstructorDoc(PolymerClassDefinition cls) {
        JSDocInfoBuilder constructorDoc = JSDocInfoBuilder.maybeCopyFrom(cls.constructor.info);
        constructorDoc.recordConstructor();
        JSTypeExpression baseType = new JSTypeExpression(new Node(Token.BANG, IR.string(PolymerPassStaticUtils.getPolymerElementType(cls))), VIRTUAL_FILE);
        constructorDoc.recordBaseType(baseType);
        String interfaceName = PolymerClassRewriter.getInterfaceName(cls);
        JSTypeExpression interfaceType = new JSTypeExpression(new Node(Token.BANG, IR.string(interfaceName)), VIRTUAL_FILE);
        constructorDoc.recordImplementedInterface(interfaceType);
        return constructorDoc;
    }

    private void appendPropertiesToBlock(List<PolymerPass.MemberDefinition> props, Node block, String basePath) {
        for (PolymerPass.MemberDefinition prop : props) {
            Node propertyNode = IR.exprResult(NodeUtil.newQName(this.compiler, basePath + prop.name.getString()));
            if (prop.name.isQuotedString()) continue;
            propertyNode.useSourceInfoIfMissingFromForTree(prop.name);
            JSDocInfoBuilder info = JSDocInfoBuilder.maybeCopyFrom(prop.info);
            JSTypeExpression propType = PolymerPassStaticUtils.getTypeFromProperty(prop, this.compiler);
            if (propType == null) {
                return;
            }
            info.recordType(propType);
            propertyNode.getFirstChild().setJSDocInfo(info.build());
            block.addChildToBack(propertyNode);
        }
    }

    private void removePropertyDocs(Node objLit, PolymerClassDefinition.DefinitionType defType) {
        for (PolymerPass.MemberDefinition prop : PolymerPassStaticUtils.extractProperties(objLit, defType, this.compiler, null)) {
            prop.name.removeProp(Node.JSDOC_INFO_PROP);
        }
    }

    private void appendBehaviorMembersToBlock(PolymerClassDefinition cls, Node block) {
        String qualifiedPath = cls.target.getQualifiedName() + ".prototype.";
        HashMap<String, Node> nameToExprResult = new HashMap<String, Node>();
        for (PolymerBehaviorExtractor.BehaviorDefinition behavior : cls.behaviors) {
            for (PolymerPass.MemberDefinition behaviorFunction : behavior.functionsToCopy) {
                String fnName = behaviorFunction.name.getString();
                if (NodeUtil.getFirstPropMatchingKey(cls.descriptor, fnName) != null) continue;
                if (nameToExprResult.containsKey(fnName)) {
                    block.removeChild((Node)nameToExprResult.get(fnName));
                }
                Node fnValue = behaviorFunction.value.cloneTree();
                NodeUtil.markNewScopesChanged(fnValue, this.compiler);
                Node exprResult = IR.exprResult(IR.assign(NodeUtil.newQName(this.compiler, qualifiedPath + fnName), fnValue));
                exprResult.useSourceInfoIfMissingFromForTree(behaviorFunction.name);
                JSDocInfoBuilder info = JSDocInfoBuilder.maybeCopyFrom(behaviorFunction.info);
                info.addSuppression("unusedPrivateMembers");
                if (behaviorFunction.info != null && behaviorFunction.info.getVisibility() == JSDocInfo.Visibility.PROTECTED) {
                    info.overwriteVisibility(JSDocInfo.Visibility.PUBLIC);
                }
                if (!behavior.isGlobalDeclaration) {
                    NodeUtil.getFunctionBody(fnValue).removeChildren();
                }
                exprResult.getFirstChild().setJSDocInfo(info.build());
                block.addChildToBack(exprResult);
                nameToExprResult.put(fnName, exprResult);
            }
            for (PolymerPass.MemberDefinition behaviorProp : behavior.nonPropertyMembersToCopy) {
                String propName = behaviorProp.name.getString();
                if (nameToExprResult.containsKey(propName)) {
                    block.removeChild((Node)nameToExprResult.get(propName));
                }
                Node exprResult = IR.exprResult(NodeUtil.newQName(this.compiler, qualifiedPath + propName));
                exprResult.useSourceInfoFromForTree(behaviorProp.name);
                JSDocInfoBuilder info = JSDocInfoBuilder.maybeCopyFrom(behaviorProp.info);
                if (behaviorProp.name.isGetterDef()) {
                    info = new JSDocInfoBuilder(true);
                    if (behaviorProp.info != null && behaviorProp.info.getReturnType() != null) {
                        info.recordType(behaviorProp.info.getReturnType());
                    }
                }
                exprResult.getFirstChild().setJSDocInfo(info.build());
                block.addChildToBack(exprResult);
                nameToExprResult.put(propName, exprResult);
            }
        }
    }

    private Node makeReadOnlySetter(String propName, String qualifiedPath) {
        String setterName = "_set" + propName.substring(0, 1).toUpperCase() + propName.substring(1);
        Node fnNode = IR.function(IR.name(""), IR.paramList(IR.name(propName)), IR.block());
        this.compiler.reportChangeToChangeScope(fnNode);
        Node exprResNode = IR.exprResult(IR.assign(NodeUtil.newQName(this.compiler, qualifiedPath + setterName), fnNode));
        JSDocInfoBuilder info = new JSDocInfoBuilder(true);
        info.recordOverride();
        exprResNode.getFirstChild().setJSDocInfo(info.build());
        return exprResNode;
    }

    private void createExportsAndExterns(PolymerClassDefinition cls, List<PolymerPass.MemberDefinition> readOnlyProps, List<PolymerPass.MemberDefinition> attributeReflectedProps) {
        Node block = IR.block();
        String interfaceName = PolymerClassRewriter.getInterfaceName(cls);
        Node fnNode = NodeUtil.emptyFunction();
        this.compiler.reportChangeToChangeScope(fnNode);
        Node varNode = IR.var(NodeUtil.newQName(this.compiler, interfaceName), fnNode);
        JSDocInfoBuilder info = new JSDocInfoBuilder(true);
        info.recordInterface();
        varNode.setJSDocInfo(info.build());
        block.addChildToBack(varNode);
        String interfaceBasePath = interfaceName + ".prototype.";
        if (this.polymerExportPolicy == PolymerExportPolicy.EXPORT_ALL) {
            this.appendPropertiesToBlock(cls.props, block, interfaceBasePath);
            LinkedHashMap<String, PolymerPass.MemberDefinition> uniqueMethods = new LinkedHashMap<String, PolymerPass.MemberDefinition>();
            if (cls.behaviors != null) {
                for (PolymerBehaviorExtractor.BehaviorDefinition behavior : cls.behaviors) {
                    for (PolymerPass.MemberDefinition method : behavior.functionsToCopy) {
                        uniqueMethods.put(method.name.getString(), method);
                    }
                }
            }
            for (PolymerPass.MemberDefinition method : cls.methods) {
                uniqueMethods.put(method.name.getString(), method);
            }
            for (PolymerPass.MemberDefinition method : uniqueMethods.values()) {
                this.addMethodToObjectExternsUsingExportAnnotation(cls, method);
            }
        } else if (this.polymerVersion == 1) {
            this.appendPropertiesToBlock(cls.props, block, interfaceBasePath);
        } else {
            ArrayList<PolymerPass.MemberDefinition> interfaceProperties = new ArrayList<PolymerPass.MemberDefinition>();
            interfaceProperties.addAll(readOnlyProps);
            if (attributeReflectedProps != null) {
                interfaceProperties.addAll(attributeReflectedProps);
            }
            this.appendPropertiesToBlock((List<PolymerPass.MemberDefinition>)interfaceProperties, block, interfaceBasePath);
        }
        for (PolymerPass.MemberDefinition prop : readOnlyProps) {
            String propName = prop.name.getString();
            String setterName = "_set" + propName.substring(0, 1).toUpperCase() + propName.substring(1);
            Node setterExprNode = IR.exprResult(NodeUtil.newQName(this.compiler, interfaceBasePath + setterName));
            JSDocInfoBuilder setterInfo = new JSDocInfoBuilder(true);
            JSTypeExpression propType = PolymerPassStaticUtils.getTypeFromProperty(prop, this.compiler);
            setterInfo.recordParameter(propName, propType);
            setterExprNode.getFirstChild().setJSDocInfo(setterInfo.build());
            block.addChildToBack(setterExprNode);
        }
        block.useSourceInfoIfMissingFromForTree(this.polymerElementExterns);
        Node scopeRoot = this.polymerElementExterns;
        if (!scopeRoot.isScript()) {
            scopeRoot = scopeRoot.getParent();
        }
        Node stmts = block.removeChildren();
        scopeRoot.addChildrenToBack(stmts);
        this.compiler.reportChangeToEnclosingScope(stmts);
    }

    private void addMethodToObjectExternsUsingExportAnnotation(PolymerClassDefinition cls, PolymerPass.MemberDefinition method) {
        Node getprop = NodeUtil.newQName(this.compiler, cls.target.getQualifiedName() + ".prototype." + method.name.getString());
        JSDocInfoBuilder info = new JSDocInfoBuilder(true);
        if (method.info != null) {
            info.recordVisibility(method.info.getVisibility());
        }
        info.recordExport();
        getprop.setJSDocInfo(info.build());
        Node expression = IR.exprResult(getprop).useSourceInfoIfMissingFromForTree(method.name);
        Node insertAfter = cls.definition;
        while (!NodeUtil.isStatementBlock(insertAfter.getParent())) {
            insertAfter = insertAfter.getParent();
        }
        insertAfter.getParent().addChildAfter(expression, insertAfter);
        this.compiler.reportChangeToEnclosingScope(expression);
    }

    private static String getInterfaceName(PolymerClassDefinition cls) {
        return "Polymer" + cls.target.getQualifiedName().replace('.', '_') + "Interface";
    }

    private static Node varToAssign(Node var) {
        Node assign = IR.assign(var.getFirstChild().cloneNode(), var.getFirstChild().removeFirstChild());
        return IR.exprResult(assign).useSourceInfoIfMissingFromForTree(var);
    }

    private void convertSimpleObserverStringsToReferences(PolymerClassDefinition cls) {
        for (PolymerPass.MemberDefinition prop : cls.props) {
            Node observer;
            if (!prop.value.isObjectLit() || (observer = NodeUtil.getFirstPropMatchingKey(prop.value, "observer")) == null || !observer.isString()) continue;
            Node observerDirectReference = IR.getprop(cls.target.cloneTree(), "prototype", observer.getString()).useSourceInfoFrom(observer);
            observer.replaceWith(observerDirectReference);
            this.compiler.reportChangeToEnclosingScope(observerDirectReference);
        }
    }

    private List<Node> addComputedPropertiesReflectionCalls(PolymerClassDefinition cls) {
        ArrayList<Node> propertySinkStatements = new ArrayList<Node>();
        for (PolymerPass.MemberDefinition prop : cls.props) {
            Node computed;
            if (!prop.value.isObjectLit() || (computed = NodeUtil.getFirstPropMatchingKey(prop.value, "computed")) == null || !computed.isString()) continue;
            propertySinkStatements.addAll(this.replaceMethodStringWithReflectedCalls(cls.target, computed));
        }
        return propertySinkStatements;
    }

    private List<Node> addComplexObserverReflectionCalls(PolymerClassDefinition cls) {
        ArrayList<Node> propertySinkStatements = new ArrayList<Node>();
        Node classMembers = NodeUtil.getClassMembers(cls.definition);
        Node getter = NodeUtil.getFirstGetterMatchingKey(classMembers, "observers");
        if (getter != null) {
            Node complexObservers = null;
            for (Node child : NodeUtil.getFunctionBody(getter.getFirstChild()).children()) {
                if (!child.isReturn() || !child.hasChildren() || !child.getFirstChild().isArrayLit()) continue;
                complexObservers = child.getFirstChild();
                break;
            }
            if (complexObservers != null) {
                for (Node complexObserver : complexObservers.children()) {
                    if (!complexObserver.isString()) continue;
                    propertySinkStatements.addAll(this.replaceMethodStringWithReflectedCalls(cls.target, complexObserver));
                }
            }
        }
        return propertySinkStatements;
    }

    private List<Node> replaceMethodStringWithReflectedCalls(Node className, Node methodSignature) {
        Node reflectedMethodName;
        Preconditions.checkArgument(methodSignature.isString());
        ArrayList<Node> propertySinkStatements = new ArrayList<Node>();
        String methodSignatureString = methodSignature.getString().trim();
        int openParenIndex = methodSignatureString.indexOf(40);
        if (methodSignatureString.charAt(methodSignatureString.length() - 1) != ')' || openParenIndex < 1) {
            this.compiler.report(JSError.make(methodSignature, PolymerPassErrors.POLYMER_UNPARSABLE_STRING, new String[0]));
            return propertySinkStatements;
        }
        JSDocInfoBuilder classTypeDoc = new JSDocInfoBuilder(false);
        JSTypeExpression classType = new JSTypeExpression(new Node(Token.BANG, IR.string(className.getQualifiedName())), className.getSourceFileName());
        classTypeDoc.recordType(classType);
        Node classTypeExpression = IR.cast(IR.objectlit(new Node[0]), classTypeDoc.build());
        String methodName = methodSignatureString.substring(0, openParenIndex).trim();
        propertySinkStatements.add(IR.getprop(className.cloneTree(), "prototype", methodName).useSourceInfoFromForTree(methodSignature));
        Node reflectedSignature = reflectedMethodName = IR.call(IR.getprop(IR.name("$jscomp"), IR.string("reflectProperty")), IR.string(methodName), classTypeExpression.cloneTree());
        String nextParamDelimeter = "(";
        if (openParenIndex < methodSignatureString.length() - 2) {
            String methodParamsString = methodSignatureString.substring(openParenIndex + 1, methodSignatureString.length() - 1).trim();
            List<String> methodParams = this.parseMethodParams(methodParamsString, methodSignature);
            for (String methodParam : methodParams) {
                Node reflectedTypeReference = classTypeExpression;
                if (methodParam.length() == 0) continue;
                if (PolymerClassRewriter.isParamLiteral(methodParam)) {
                    Node term = IR.string(methodParam);
                    reflectedSignature = IR.add(IR.add(reflectedSignature, IR.string(nextParamDelimeter)), term);
                } else {
                    List<String> paramParts = Splitter.on('.').splitToList(methodParam);
                    String nextPropertyTermDelimiter = nextParamDelimeter;
                    for (int i = 0; i < paramParts.size(); ++i) {
                        if (i > 0 && i == paramParts.size() - 1 && (paramParts.get(i).equals("*") || paramParts.get(i).equals("splices"))) {
                            reflectedSignature = IR.add(reflectedSignature, IR.string(nextPropertyTermDelimiter + paramParts.get(i)));
                        } else {
                            if (i == 0) {
                                propertySinkStatements.add(IR.getprop(className.cloneTree(), IR.string("prototype"), IR.string(paramParts.get(i))).useSourceInfoFromForTree(methodSignature));
                            }
                            Node reflectedParamPart = IR.call(IR.getprop(IR.name("$jscomp"), IR.string("reflectProperty")), IR.string(paramParts.get(i)), reflectedTypeReference.cloneTree());
                            reflectedSignature = IR.add(IR.add(reflectedSignature, IR.string(nextPropertyTermDelimiter)), reflectedParamPart);
                            reflectedTypeReference = IR.getprop(reflectedTypeReference.cloneTree(), paramParts.get(i), new String[0]);
                        }
                        nextPropertyTermDelimiter = ".";
                    }
                }
                nextParamDelimeter = ",";
            }
            reflectedSignature = methodParams.size() == 0 ? IR.add(reflectedSignature, IR.string("()")) : IR.add(reflectedSignature, IR.string(")"));
        } else {
            reflectedSignature = IR.add(reflectedSignature, IR.string("()"));
        }
        methodSignature.replaceWith(reflectedSignature.useSourceInfoFromForTree(methodSignature));
        this.compiler.reportChangeToEnclosingScope(reflectedSignature);
        return propertySinkStatements;
    }

    private List<String> parseMethodParams(String methodParameters, Node methodSignature) {
        ArrayList<String> parsedParameters = new ArrayList<String>();
        int nextDelimeter = 44;
        String currentTerm = "";
        for (int i = 0; i < methodParameters.length(); ++i) {
            if (methodParameters.charAt(i) == nextDelimeter) {
                if (nextDelimeter == 44) {
                    parsedParameters.add(currentTerm.trim());
                    currentTerm = "";
                    continue;
                }
                currentTerm = currentTerm + (char)nextDelimeter;
                nextDelimeter = 44;
                continue;
            }
            currentTerm = currentTerm + methodParameters.charAt(i);
            if (methodParameters.charAt(i) != '\"' && methodParameters.charAt(i) != '\'') continue;
            nextDelimeter = methodParameters.charAt(i);
        }
        if (nextDelimeter != 44) {
            this.compiler.report(JSError.make(methodSignature, PolymerPassErrors.POLYMER_UNPARSABLE_STRING, new String[0]));
            return parsedParameters;
        }
        if (currentTerm.length() > 0) {
            parsedParameters.add(currentTerm.trim());
        }
        return parsedParameters;
    }

    private static boolean isParamLiteral(String param) {
        try {
            Double.parseDouble(param);
            return true;
        }
        catch (NumberFormatException e) {
            return param.length() > 1 && (param.charAt(0) == '\"' || param.charAt(0) == '\'') && param.charAt(0) == param.charAt(param.length() - 1);
        }
    }

    private static Node getInsertionPointForGoogModule(Node moduleBody) {
        Preconditions.checkArgument(moduleBody.isModuleBody(), moduleBody);
        Node insertionPoint = moduleBody.getFirstChild();
        Node next = insertionPoint.getNext();
        while (NodeUtil.isNameDeclaration(next) && next.hasOneChild() && ModuleImportResolver.isGoogModuleDependencyCall(next.getFirstFirstChild()) || NodeUtil.isExprCall(next) && ModuleImportResolver.isGoogModuleDependencyCall(next.getOnlyChild())) {
            insertionPoint = next;
            next = next.getNext();
        }
        return insertionPoint;
    }
}

