/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.ClosurePrimitiveErrors;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.JSModuleGraph;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.PreprocessorSymbolTable;
import com.google.javascript.jscomp.ProcessClosurePrimitives;
import com.google.javascript.jscomp.parsing.JsDocInfoParser;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

class ProcessClosureProvidesAndRequires
implements HotSwapCompilerPass {
    private static final String GOOG = "goog";
    private final AbstractCompiler compiler;
    private final JSModuleGraph moduleGraph;
    private final Map<String, ProvidedName> providedNames = new LinkedHashMap<String, ProvidedName>();
    private final List<UnrecognizedRequire> unrecognizedRequires = new ArrayList<UnrecognizedRequire>();
    private final CheckLevel requiresLevel;
    private final PreprocessorSymbolTable preprocessorSymbolTable;
    private final boolean preserveGoogProvidesAndRequires;
    private final List<Node> requiresToBeRemoved = new ArrayList<Node>();
    private boolean hasRewritingOccurred = false;
    private final Set<Node> forwardDeclaresToRemove = new HashSet<Node>();
    private final Set<Node> previouslyProvidedDefinitions = new HashSet<Node>();

    ProcessClosureProvidesAndRequires(AbstractCompiler compiler, @Nullable PreprocessorSymbolTable preprocessorSymbolTable, CheckLevel requiresLevel, boolean preserveGoogProvidesAndRequires) {
        this.compiler = compiler;
        this.preprocessorSymbolTable = preprocessorSymbolTable;
        this.moduleGraph = compiler.getModuleGraph();
        this.requiresLevel = requiresLevel;
        this.preserveGoogProvidesAndRequires = preserveGoogProvidesAndRequires;
    }

    @Override
    public void process(Node externs, Node root) {
        this.rewriteProvidesAndRequires(externs, root);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        this.compiler.process(this);
    }

    Map<String, ProvidedName> collectProvidedNames(Node externs, Node root) {
        if (this.providedNames.isEmpty()) {
            this.providedNames.put(GOOG, new ProvidedName(GOOG, null, null, false, false));
            NodeTraversal.traverseRoots(this.compiler, new CollectDefinitions(), externs, root);
        }
        return this.providedNames;
    }

    void rewriteProvidesAndRequires(Node externs, Node root) {
        Preconditions.checkState(!this.hasRewritingOccurred, "Cannot call rewriteProvidesAndRequires twice per instance");
        this.hasRewritingOccurred = true;
        this.collectProvidedNames(externs, root);
        for (ProvidedName pn : this.providedNames.values()) {
            pn.replace();
        }
        this.deleteNamespaceInitializationsFromPreviousProvides();
        if (this.requiresLevel.isOn()) {
            for (UnrecognizedRequire r : this.unrecognizedRequires) {
                this.checkForLateOrMissingProvide(r);
            }
        }
        for (Node closureRequire : this.requiresToBeRemoved) {
            this.compiler.reportChangeToEnclosingScope(closureRequire);
            closureRequire.detach();
        }
        for (Node forwardDeclare : this.forwardDeclaresToRemove) {
            NodeUtil.deleteNode(forwardDeclare, this.compiler);
        }
    }

    private void checkForLateOrMissingProvide(UnrecognizedRequire r) {
        DiagnosticType error;
        ProvidedName expectedName = this.providedNames.get(r.namespace);
        if (expectedName != null && expectedName.firstNode != null) {
            if (r.isRequireType) {
                return;
            }
            error = ProcessClosurePrimitives.LATE_PROVIDE_ERROR;
        } else {
            error = ProcessClosurePrimitives.MISSING_PROVIDE_ERROR;
        }
        this.compiler.report(JSError.make(r.requireNode, this.requiresLevel, error, r.namespace));
    }

    private boolean validateUnaliasablePrimitiveCall(NodeTraversal t, Node n, String methodName) {
        return this.validatePrimitiveCallWithMessage(t, n, methodName, ProcessClosurePrimitives.CLOSURE_CALL_CANNOT_BE_ALIASED_ERROR);
    }

    private boolean validateAliasiablePrimitiveCall(NodeTraversal t, Node n, String methodName) {
        return this.validatePrimitiveCallWithMessage(t, n, methodName, ProcessClosurePrimitives.CLOSURE_CALL_CANNOT_BE_ALIASED_OUTSIDE_MODULE_ERROR);
    }

    private boolean validatePrimitiveCallWithMessage(NodeTraversal t, Node n, String methodName, DiagnosticType invalidAliasingError) {
        if (this.compiler.getOptions().shouldPreserveGoogModule()) {
            return true;
        }
        if (!t.inGlobalHoistScope()) {
            this.compiler.report(JSError.make(n, ClosurePrimitiveErrors.INVALID_CLOSURE_CALL_SCOPE_ERROR, new String[0]));
            return false;
        }
        if (!n.getParent().isExprResult()) {
            this.compiler.report(JSError.make(n, invalidAliasingError, "goog." + methodName));
            return false;
        }
        return true;
    }

    private void processRequireCall(NodeTraversal t, Node n, Node parent) {
        Node left = n.getFirstChild();
        Node arg = left.getNext();
        String method = left.getFirstChild().getNext().getString();
        if (this.verifyLastArgumentIsString(left, arg)) {
            String ns = arg.getString();
            ProvidedName provided = this.providedNames.get(ns);
            if (provided == null || !provided.isExplicitlyProvided()) {
                this.unrecognizedRequires.add(new UnrecognizedRequire(n, ns, method.equals("requireType")));
            } else {
                JSModule providedModule = provided.explicitModule;
                if (!provided.isFromExterns()) {
                    Preconditions.checkNotNull(providedModule, n);
                    JSModule module = t.getModule();
                    if (module != providedModule && !this.moduleGraph.dependsOn(module, providedModule) && !method.equals("requireType")) {
                        this.compiler.report(JSError.make(n, ProcessClosurePrimitives.XMODULE_REQUIRE_ERROR, ns, providedModule.getName(), module.getName()));
                    }
                }
            }
            this.maybeAddNameToSymbolTable(left);
            this.maybeAddStringToSymbolTable(arg);
            if (!this.preserveGoogProvidesAndRequires && (provided != null || this.requiresLevel.isOn())) {
                this.requiresToBeRemoved.add(parent);
            }
        }
    }

    private void processLegacyModuleCall(String namespace, Node googModuleCall, JSModule module) {
        this.registerAnyProvidedPrefixes(namespace, googModuleCall, module);
        this.providedNames.put(namespace, new ProvidedName(namespace, googModuleCall, module, true, false));
    }

    private void processProvideCall(NodeTraversal t, Node n, Node parent) {
        Preconditions.checkState(n.isCall());
        Node left = n.getFirstChild();
        Node arg = left.getNext();
        if (this.verifyProvide(left, arg)) {
            String ns = arg.getString();
            this.maybeAddNameToSymbolTable(left);
            this.maybeAddStringToSymbolTable(arg);
            if (this.providedNames.containsKey(ns)) {
                ProvidedName previouslyProvided = this.providedNames.get(ns);
                if (!previouslyProvided.isExplicitlyProvided() || previouslyProvided.isPreviouslyProvided) {
                    previouslyProvided.addProvide(parent, t.getModule(), true);
                } else {
                    String explicitSourceName = previouslyProvided.explicitNode.getSourceFileName();
                    this.compiler.report(JSError.make(n, ProcessClosurePrimitives.DUPLICATE_NAMESPACE_ERROR, ns, explicitSourceName));
                }
            } else {
                this.registerAnyProvidedPrefixes(ns, parent, t.getModule());
                this.providedNames.put(ns, new ProvidedName(ns, parent, t.getModule(), true, false));
            }
        }
    }

    private void handleStubDefinition(NodeTraversal t, Node n) {
        boolean hasStubDefinition;
        if (!t.inGlobalHoistScope()) {
            return;
        }
        JSDocInfo info = n.getFirstChild().getJSDocInfo();
        boolean bl = hasStubDefinition = info != null && (n.isFromExterns() || info.hasTypedefType());
        if (hasStubDefinition && n.getFirstChild().isQualifiedName()) {
            String name = n.getFirstChild().getQualifiedName();
            ProvidedName pn = this.providedNames.get(name);
            if (pn != null) {
                n.putBooleanProp(Node.WAS_PREVIOUSLY_PROVIDED, true);
                pn.addDefinition(n, t.getModule());
            } else if (n.getBooleanProp(Node.WAS_PREVIOUSLY_PROVIDED)) {
                ProvidedName provided = new ProvidedName(name, n, t.getModule(), true, true);
                this.providedNames.put(name, provided);
                provided.addDefinition(n, t.getModule());
            }
        }
    }

    private void handleCandidateProvideDefinition(NodeTraversal t, Node n, Node parent) {
        if (t.inGlobalHoistScope()) {
            String name = null;
            if (n.isName() && NodeUtil.isNameDeclaration(parent)) {
                name = n.getString();
            } else if (n.isAssign() && parent.isExprResult()) {
                name = n.getFirstChild().getQualifiedName();
            }
            if (name != null) {
                if (parent.getBooleanProp(Node.IS_NAMESPACE)) {
                    this.processProvideFromPreviousPass(t, name, parent);
                } else {
                    ProvidedName pn = this.providedNames.get(name);
                    if (pn != null) {
                        pn.addDefinition(parent, t.getModule());
                    }
                }
            }
        }
    }

    private void deleteNamespaceInitializationsFromPreviousProvides() {
        for (Node name : this.previouslyProvidedDefinitions) {
            name.detach();
        }
    }

    private void processProvideFromPreviousPass(NodeTraversal t, String name, Node parent) {
        JSModule module = t.getModule();
        if (this.providedNames.containsKey(name)) {
            ProvidedName provided = this.providedNames.get(name);
            provided.addDefinition(parent, module);
            if (ProcessClosureProvidesAndRequires.isNamespacePlaceholder(parent)) {
                this.previouslyProvidedDefinitions.add(parent);
            }
        } else {
            this.registerAnyProvidedPrefixes(name, parent, module);
            ProvidedName provided = new ProvidedName(name, parent, module, true, true);
            this.providedNames.put(name, provided);
            provided.addDefinition(parent, module);
        }
    }

    private boolean verifyProvide(Node methodName, Node arg) {
        if (!this.verifyLastArgumentIsString(methodName, arg)) {
            return false;
        }
        if (!NodeUtil.isValidQualifiedName(this.compiler.getOptions().getLanguageIn().toFeatureSet(), arg.getString())) {
            this.compiler.report(JSError.make(arg, ProcessClosurePrimitives.INVALID_PROVIDE_ERROR, arg.getString(), this.compiler.getOptions().getLanguageIn().toString()));
            return false;
        }
        return true;
    }

    private void processForwardDeclare(Node n, Node parent) {
        CodingConvention convention = this.compiler.getCodingConvention();
        List<String> typeDeclarations = convention.identifyTypeDeclarationCall(n);
        if (typeDeclarations != null && typeDeclarations.size() == 1) {
            Node toRemove = parent.isExprResult() ? parent : parent.getParent();
            this.forwardDeclaresToRemove.add(toRemove);
        }
    }

    private boolean verifyLastArgumentIsString(Node methodName, Node arg) {
        return this.verifyNotNull(methodName, arg) && this.verifyOfType(methodName, arg, Token.STRING) && this.verifyIsLast(methodName, arg);
    }

    private boolean verifyNotNull(Node methodName, Node arg) {
        if (arg == null) {
            this.compiler.report(JSError.make(methodName, ProcessClosurePrimitives.NULL_ARGUMENT_ERROR, methodName.getQualifiedName()));
            return false;
        }
        return true;
    }

    private boolean verifyOfType(Node methodName, Node arg, Token desiredType) {
        if (arg.getToken() != desiredType) {
            this.compiler.report(JSError.make(methodName, ProcessClosurePrimitives.INVALID_ARGUMENT_ERROR, methodName.getQualifiedName()));
            return false;
        }
        return true;
    }

    private boolean verifyIsLast(Node methodName, Node arg) {
        if (arg.getNext() != null) {
            this.compiler.report(JSError.make(methodName, ProcessClosurePrimitives.TOO_MANY_ARGUMENTS_ERROR, methodName.getQualifiedName()));
            return false;
        }
        return true;
    }

    private void registerAnyProvidedPrefixes(String ns, Node node, JSModule module) {
        int pos = ns.indexOf(46);
        while (pos != -1) {
            String prefixNs = ns.substring(0, pos);
            pos = ns.indexOf(46, pos + 1);
            if (this.providedNames.containsKey(prefixNs)) {
                this.providedNames.get(prefixNs).addProvide(node, module, false);
                continue;
            }
            this.providedNames.put(prefixNs, new ProvidedName(prefixNs, node, module, false, false));
        }
    }

    private JSDocInfo createUnknownTypeJsDocInfo() {
        JSDocInfoBuilder castToUnknownBuilder = new JSDocInfoBuilder(true);
        castToUnknownBuilder.recordType(new JSTypeExpression(JsDocInfoParser.parseTypeString("?"), "<ProcessClosurePrimitives.java>"));
        return castToUnknownBuilder.build();
    }

    private static boolean isNamespacePlaceholder(Node n) {
        if (!n.getBooleanProp(Node.IS_NAMESPACE)) {
            return false;
        }
        Node value = null;
        if (n.isExprResult()) {
            Node assign = n.getFirstChild();
            value = assign.getLastChild();
        } else if (n.isVar()) {
            Node name = n.getFirstChild();
            value = name.getFirstChild();
        }
        if (value == null) {
            return false;
        }
        if (value.isCast()) {
            value = value.getOnlyChild();
        }
        return value.isObjectLit() && !value.hasChildren();
    }

    private void maybeAddStringToSymbolTable(Node string) {
        if (this.preprocessorSymbolTable != null) {
            this.preprocessorSymbolTable.addStringNode(string, this.compiler);
        }
    }

    private void maybeAddNameToSymbolTable(Node name) {
        if (this.preprocessorSymbolTable != null) {
            this.preprocessorSymbolTable.addReference(name);
        }
    }

    private static class UnrecognizedRequire {
        final Node requireNode;
        final String namespace;
        final boolean isRequireType;

        UnrecognizedRequire(Node requireNode, String namespace, boolean isRequireType) {
            this.requireNode = requireNode;
            this.namespace = namespace;
            this.isRequireType = isRequireType;
        }
    }

    class ProvidedName {
        private final String namespace;
        private final Node firstNode;
        private final JSModule firstModule;
        private Node explicitNode = null;
        private JSModule explicitModule = null;
        private boolean hasAChildNamespace = false;
        private Node candidateDefinition = null;
        private JSModule minimumModule = null;
        private Node replacementNode = null;
        private final boolean isPreviouslyProvided;

        ProvidedName(String namespace, Node node, JSModule module, boolean explicit, boolean fromPreviousProvide) {
            Preconditions.checkArgument(node == null || NodeUtil.isExprCall(node) || (fromPreviousProvide || !explicit) && (NodeUtil.isExprAssign(node) || NodeUtil.isNameDeclaration(node) || node.isExprResult() && node.getFirstChild().isQualifiedName()), node);
            this.namespace = namespace;
            this.firstNode = node;
            this.firstModule = module;
            this.isPreviouslyProvided = fromPreviousProvide;
            this.addProvide(node, module, explicit);
        }

        void addProvide(Node node, JSModule module, boolean explicit) {
            if (explicit) {
                Preconditions.checkState(this.explicitNode == null || this.isPreviouslyProvided);
                Preconditions.checkArgument(node.isExprResult() || NodeUtil.isNameDeclaration(node) && this.isPreviouslyProvided, node);
                this.explicitNode = node;
                this.explicitModule = module;
            } else {
                this.hasAChildNamespace = true;
            }
            this.updateMinimumModule(module);
        }

        boolean isExplicitlyProvided() {
            return this.explicitNode != null;
        }

        boolean isFromExterns() {
            return this.explicitNode.isFromExterns();
        }

        private boolean hasCandidateDefinitionNotFromPreviousPass() {
            return this.candidateDefinition != null && !ProcessClosureProvidesAndRequires.this.previouslyProvidedDefinitions.contains(this.candidateDefinition);
        }

        Node getFirstProvideCall() {
            return this.firstNode;
        }

        Node getCandidateDefinition() {
            return this.candidateDefinition;
        }

        String getNamespace() {
            return this.namespace;
        }

        private void addDefinition(Node node, JSModule module) {
            Preconditions.checkArgument(node.isExprResult() || node.isFunction() || NodeUtil.isNameDeclaration(node));
            Preconditions.checkArgument(this.explicitNode != node || this.isPreviouslyProvided);
            if (this.candidateDefinition == null || !node.isExprResult()) {
                this.candidateDefinition = node;
                this.updateMinimumModule(module);
            }
        }

        private void updateMinimumModule(JSModule newModule) {
            if (this.minimumModule == null) {
                this.minimumModule = newModule;
            } else if (ProcessClosureProvidesAndRequires.this.moduleGraph.getModuleCount() > 1) {
                this.minimumModule = ProcessClosureProvidesAndRequires.this.moduleGraph.getDeepestCommonDependencyInclusive(this.minimumModule, newModule);
            } else {
                Preconditions.checkState(newModule == this.minimumModule, "Missing module graph");
            }
        }

        private void replace() {
            if (this.firstNode == null) {
                this.replacementNode = this.candidateDefinition;
                return;
            }
            if (this.hasCandidateDefinitionNotFromPreviousPass() && this.explicitNode != null) {
                JSTypeExpression expr;
                JSDocInfo info = this.candidateDefinition.isExprResult() ? this.candidateDefinition.getFirstChild().getJSDocInfo() : this.candidateDefinition.getJSDocInfo();
                if (info != null && (expr = info.getType()) != null) {
                    Node n = expr.getRoot();
                    if (n.getToken() == Token.BANG) {
                        n = n.getFirstChild();
                    }
                    if (n.isString() && !n.hasChildren() && n.getString().equals("Object")) {
                        ProcessClosureProvidesAndRequires.this.compiler.report(JSError.make(this.candidateDefinition, ProcessClosurePrimitives.WEAK_NAMESPACE_TYPE, new String[0]));
                    }
                }
                this.replacementNode = this.candidateDefinition;
                if (this.candidateDefinition.isExprResult()) {
                    Node exprNode = this.candidateDefinition.getOnlyChild();
                    if (exprNode.isAssign()) {
                        Node nameNode = exprNode.getFirstChild();
                        if (nameNode.isName()) {
                            this.convertProvideAssignmentToVarDeclaration(exprNode, nameNode);
                        } else {
                            this.candidateDefinition.putBooleanProp(Node.IS_NAMESPACE, true);
                        }
                    } else {
                        Preconditions.checkState(exprNode.isQualifiedName(), exprNode);
                        if (this.hasAChildNamespace) {
                            this.createNamespaceInitialization(this.createDeclarationNode(IR.cast(IR.objectlit(new Node[0]), ProcessClosureProvidesAndRequires.this.createUnknownTypeJsDocInfo())));
                        }
                    }
                }
            } else {
                this.createNamespaceInitialization(this.createDeclarationNode(IR.objectlit(new Node[0])));
            }
            if (this.explicitNode != null && !this.isPreviouslyProvided) {
                if (ProcessClosureProvidesAndRequires.this.preserveGoogProvidesAndRequires) {
                    return;
                }
                ProcessClosureProvidesAndRequires.this.compiler.reportChangeToEnclosingScope(this.explicitNode);
                this.explicitNode.detach();
            }
        }

        private void convertProvideAssignmentToVarDeclaration(Node assignNode, Node nameNode) {
            Preconditions.checkArgument(assignNode.isAssign(), assignNode);
            Preconditions.checkArgument(nameNode.isName(), nameNode);
            Node valueNode = nameNode.getNext();
            assignNode.removeChild(nameNode);
            assignNode.removeChild(valueNode);
            Node varNode = IR.var(nameNode, valueNode).useSourceInfoFrom(this.candidateDefinition);
            varNode.setJSDocInfo(assignNode.getJSDocInfo());
            varNode.putBooleanProp(Node.IS_NAMESPACE, true);
            this.candidateDefinition.replaceWith(varNode);
            this.replacementNode = varNode;
            ProcessClosureProvidesAndRequires.this.compiler.reportChangeToEnclosingScope(varNode);
        }

        private void createNamespaceInitialization(Node replacement) {
            this.replacementNode = replacement;
            if (this.firstModule == this.minimumModule) {
                this.firstNode.getParent().addChildBefore(this.replacementNode, this.firstNode);
            } else {
                int indexOfDot = this.namespace.lastIndexOf(46);
                if (indexOfDot == -1) {
                    ProcessClosureProvidesAndRequires.this.compiler.getNodeForCodeInsertion(this.minimumModule).addChildToBack(this.replacementNode);
                } else {
                    ProvidedName parentName = (ProvidedName)ProcessClosureProvidesAndRequires.this.providedNames.get(this.namespace.substring(0, indexOfDot));
                    Preconditions.checkNotNull(parentName);
                    Preconditions.checkNotNull(parentName.replacementNode);
                    parentName.replacementNode.getParent().addChildAfter(this.replacementNode, parentName.replacementNode);
                }
            }
            ProcessClosureProvidesAndRequires.this.compiler.reportChangeToEnclosingScope(this.replacementNode);
        }

        private Node createDeclarationNode(Node value) {
            Preconditions.checkArgument(value.isObjectLit() || value.isCast(), value);
            if (this.namespace.indexOf(46) == -1) {
                return this.makeVarDeclNode(value);
            }
            return this.makeAssignmentExprNode(value);
        }

        private Node makeVarDeclNode(Node value) {
            Node name = IR.name(this.namespace);
            name.addChildToFront(value);
            Node decl = IR.var(name);
            decl.putBooleanProp(Node.IS_NAMESPACE, true);
            if (ProcessClosureProvidesAndRequires.this.compiler.getCodingConvention().isConstant(this.namespace)) {
                name.putBooleanProp(Node.IS_CONSTANT_NAME, true);
            }
            if (!this.hasCandidateDefinitionNotFromPreviousPass()) {
                decl.setJSDocInfo(NodeUtil.createConstantJsDoc());
            }
            Preconditions.checkState(ProcessClosureProvidesAndRequires.isNamespacePlaceholder(decl));
            this.setSourceInfo(decl);
            return decl;
        }

        private Node makeAssignmentExprNode(Node value) {
            Node lhs = NodeUtil.newQName(ProcessClosureProvidesAndRequires.this.compiler, this.namespace, this.firstNode, this.namespace);
            Node decl = IR.exprResult(IR.assign(lhs, value));
            decl.putBooleanProp(Node.IS_NAMESPACE, true);
            if (!this.hasCandidateDefinitionNotFromPreviousPass()) {
                decl.getFirstChild().setJSDocInfo(NodeUtil.createConstantJsDoc());
            }
            Preconditions.checkState(ProcessClosureProvidesAndRequires.isNamespacePlaceholder(decl));
            this.setSourceInfo(decl);
            lhs.getFirstChild().makeNonIndexableRecursive();
            return decl;
        }

        private void setSourceInfo(Node newNode) {
            Node provideStringNode = this.getProvideStringNode();
            int offset = provideStringNode == null ? 0 : this.getSourceInfoOffset();
            Node sourceInfoNode = provideStringNode == null ? this.firstNode : provideStringNode;
            newNode.useSourceInfoIfMissingFromForTree(sourceInfoNode);
            if (offset != 0) {
                newNode.setSourceEncodedPositionForTree(sourceInfoNode.getSourcePosition() + offset);
                int lengthOfLastComponent = this.namespace.length() - (this.namespace.lastIndexOf(".") + 1);
                newNode.setLengthForTree(lengthOfLastComponent);
            }
        }

        private int getSourceInfoOffset() {
            int indexOfLastDot = this.namespace.lastIndexOf(46);
            return 2 + indexOfLastDot;
        }

        private Node getProvideStringNode() {
            return this.firstNode.getFirstChild() != null && NodeUtil.isExprCall(this.firstNode) ? this.firstNode.getFirstChild().getLastChild() : null;
        }

        @GwtIncompatible(value="Unnecessary")
        public String toString() {
            String explicitOrImplicit = this.isExplicitlyProvided() ? "explicit" : "implicit";
            return String.format("ProvidedName: %s, %s", this.namespace, explicitOrImplicit);
        }
    }

    private class CollectDefinitions
    implements NodeTraversal.Callback {
        private CollectDefinitions() {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            if (n.isModuleBody() && n.getParent().getBooleanProp(Node.GOOG_MODULE) || NodeUtil.isBundledGoogModuleScopeRoot(n)) {
                Node googModuleCall = n.getFirstChild();
                String closureNamespace = googModuleCall.getFirstChild().getSecondChild().getString();
                Node maybeLegacyNamespaceCall = googModuleCall.getNext();
                if (maybeLegacyNamespaceCall != null && NodeUtil.isGoogModuleDeclareLegacyNamespaceCall(maybeLegacyNamespaceCall)) {
                    ProcessClosureProvidesAndRequires.this.processLegacyModuleCall(closureNamespace, googModuleCall, t.getModule());
                }
                return false;
            }
            return !n.isModuleBody();
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getToken()) {
                case CALL: {
                    Node left = n.getFirstChild();
                    if (!left.isGetProp()) break;
                    Node name = left.getFirstChild();
                    if (name.isName() && ProcessClosureProvidesAndRequires.GOOG.equals(name.getString())) {
                        String methodName;
                        switch (methodName = name.getNext().getString()) {
                            case "require": 
                            case "requireType": {
                                if (!ProcessClosureProvidesAndRequires.this.validateAliasiablePrimitiveCall(t, n, methodName)) break;
                                ProcessClosureProvidesAndRequires.this.processRequireCall(t, n, parent);
                                break;
                            }
                            case "provide": {
                                if (!ProcessClosureProvidesAndRequires.this.validateUnaliasablePrimitiveCall(t, n, methodName)) break;
                                ProcessClosureProvidesAndRequires.this.processProvideCall(t, n, parent);
                                break;
                            }
                            case "forwardDeclare": {
                                if (!ProcessClosureProvidesAndRequires.this.validateAliasiablePrimitiveCall(t, n, methodName)) break;
                                ProcessClosureProvidesAndRequires.this.processForwardDeclare(n, parent);
                            }
                        }
                    }
                    break;
                }
                case ASSIGN: 
                case NAME: {
                    ProcessClosureProvidesAndRequires.this.handleCandidateProvideDefinition(t, n, parent);
                    break;
                }
                case EXPR_RESULT: {
                    ProcessClosureProvidesAndRequires.this.handleStubDefinition(t, n);
                    break;
                }
                case CLASS: {
                    if (!t.inGlobalHoistScope() || NodeUtil.isClassExpression(n)) break;
                    String name = n.getFirstChild().getString();
                    ProvidedName pn = (ProvidedName)ProcessClosureProvidesAndRequires.this.providedNames.get(name);
                    if (pn == null) break;
                    ProcessClosureProvidesAndRequires.this.compiler.report(JSError.make(n, ProcessClosurePrimitives.CLASS_NAMESPACE_ERROR, name));
                    break;
                }
                case FUNCTION: {
                    if (!t.inGlobalHoistScope() || !NodeUtil.isFunctionDeclaration(n)) break;
                    String name = n.getFirstChild().getString();
                    ProvidedName pn = (ProvidedName)ProcessClosureProvidesAndRequires.this.providedNames.get(name);
                    if (pn == null) break;
                    ProcessClosureProvidesAndRequires.this.compiler.report(JSError.make(n, ProcessClosurePrimitives.FUNCTION_NAMESPACE_ERROR, name));
                    break;
                }
            }
        }
    }
}

