/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.lint;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.errorprone.annotations.Immutable;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.lint.AutoValue_CheckRequiresSorted_DestructuringBinding;
import com.google.javascript.jscomp.lint.AutoValue_CheckRequiresSorted_ImportStatement;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public final class CheckRequiresSorted
implements NodeTraversal.Callback {
    public static final DiagnosticType REQUIRES_NOT_SORTED = DiagnosticType.warning("JSC_REQUIRES_NOT_SORTED", "goog.require() and goog.requireType() statements are not sorted. The correct order is:\n\n{0}\n");
    private final Mode mode;
    private final Multimap<String, ImportStatement> importsByNamespace = ArrayListMultimap.create();
    private final List<ImportStatement> originalImports = new ArrayList<ImportStatement>();
    @Nullable
    private List<ImportStatement> canonicalImports = null;
    @Nullable
    private Node firstNode = null;
    @Nullable
    private Node lastNode = null;
    private boolean finished = false;
    private boolean needsFix = false;
    @Nullable
    private String replacement = null;

    public CheckRequiresSorted(Mode mode) {
        this.mode = mode;
    }

    public Node getFirstNode() {
        return this.firstNode;
    }

    public Node getLastNode() {
        return this.lastNode;
    }

    public String getReplacement() {
        return this.replacement;
    }

    public boolean needsFix() {
        return this.needsFix;
    }

    @Override
    public final boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        return !this.finished && (parent == null || parent.isRoot() || parent.isScript() || parent.isModuleBody());
    }

    @Override
    public final void visit(NodeTraversal t, Node n, Node parent) {
        if (n.isScript()) {
            this.checkCanonical(t);
            return;
        }
        Node callNode = null;
        if (n.isExprResult()) {
            callNode = n.getFirstChild();
        } else if (NodeUtil.isNameDeclaration(n)) {
            callNode = n.getFirstChild().getLastChild();
        }
        if (callNode != null && CheckRequiresSorted.isValidImportCall(callNode)) {
            ImportStatement stmt = CheckRequiresSorted.parseImport(callNode);
            this.originalImports.add(stmt);
            this.importsByNamespace.put(stmt.namespace(), stmt);
            if (this.firstNode == null) {
                this.firstNode = this.lastNode = n;
            } else {
                this.lastNode = n;
            }
        } else if (!this.importsByNamespace.isEmpty()) {
            this.finished = true;
        }
    }

    private static boolean isValidImportCall(Node n) {
        return n.isCall() && n.hasTwoChildren() && (n.getFirstChild().matchesQualifiedName("goog.require") || n.getFirstChild().matchesQualifiedName("goog.requireType") || n.getFirstChild().matchesQualifiedName("goog.forwardDeclare")) && n.getSecondChild().isString();
    }

    private static ImportStatement parseImport(Node callNode) {
        ImportPrimitive primitive = ImportPrimitive.fromName(callNode.getFirstChild().getQualifiedName());
        String namespace = callNode.getSecondChild().getString();
        Node parent = callNode.getParent();
        if (parent.isExprResult()) {
            return ImportStatement.of(ImmutableList.of(parent), primitive, namespace, null, null);
        }
        Node grandparent = parent.getParent();
        if (parent.isName()) {
            String alias = parent.getString();
            return ImportStatement.of(ImmutableList.of(grandparent), primitive, namespace, alias, null);
        }
        ImmutableList.Builder destructures = ImmutableList.builder();
        for (Node name : parent.getFirstChild().children()) {
            String exportedName = name.getString();
            String localName = name.getFirstChild().getString();
            destructures.add(DestructuringBinding.of(exportedName, localName));
        }
        return ImportStatement.of(ImmutableList.of(grandparent), primitive, namespace, null, (ImmutableList<DestructuringBinding>)destructures.build());
    }

    private void checkCanonical(NodeTraversal t) {
        this.canonicalImports = CheckRequiresSorted.canonicalizeImports(this.importsByNamespace);
        if (!this.originalImports.equals(this.canonicalImports)) {
            this.needsFix = true;
            this.replacement = String.join((CharSequence)"\n", Iterables.transform(this.canonicalImports, ImportStatement::format));
            if (this.mode == Mode.COLLECT_AND_REPORT) {
                t.report(this.firstNode, REQUIRES_NOT_SORTED, this.replacement);
            }
        }
    }

    private static List<ImportStatement> canonicalizeImports(Multimap<String, ImportStatement> importsByNamespace) {
        ArrayList<ImportStatement> canonicalImports = new ArrayList<ImportStatement>();
        for (String namespace : importsByNamespace.keySet()) {
            Collection<ImportStatement> allImports = importsByNamespace.get(namespace);
            ImportPrimitive strongestPrimitive = allImports.stream().map(ImportStatement::primitive).reduce(ImportPrimitive.WEAKEST, ImportPrimitive::stronger);
            boolean hasAliasing = false;
            for (ImportStatement stmt : Iterables.filter(allImports, ImportStatement::isAliasing)) {
                canonicalImports.add(stmt.upgrade(strongestPrimitive));
                hasAliasing = true;
            }
            boolean hasDestructuring = false;
            ImmutableList<Node> destructuringNodes = allImports.stream().filter(ImportStatement::isDestructuring).flatMap(i -> i.nodes().stream()).collect(ImmutableList.toImmutableList());
            ImmutableList<DestructuringBinding> destructures = allImports.stream().filter(ImportStatement::isDestructuring).flatMap(i -> i.destructures().stream()).distinct().sorted().collect(ImmutableList.toImmutableList());
            if (!destructures.isEmpty()) {
                canonicalImports.add(ImportStatement.of(destructuringNodes, strongestPrimitive, namespace, null, destructures));
                hasDestructuring = true;
            }
            if (hasAliasing || hasDestructuring) continue;
            ImmutableList<Node> standaloneNodes = allImports.stream().filter(ImportStatement::isStandalone).flatMap(i -> i.nodes().stream()).collect(ImmutableList.toImmutableList());
            canonicalImports.add(ImportStatement.of(standaloneNodes, strongestPrimitive, namespace, null, null));
        }
        Collections.sort(canonicalImports);
        return canonicalImports;
    }

    static abstract class ImportStatement
    implements Comparable<ImportStatement> {
        ImportStatement() {
        }

        abstract ImmutableList<Node> nodes();

        abstract ImportPrimitive primitive();

        abstract String namespace();

        @Nullable
        abstract String alias();

        @Nullable
        abstract ImmutableList<DestructuringBinding> destructures();

        static ImportStatement of(ImmutableList<Node> nodes, ImportPrimitive primitive, String namespace, @Nullable String alias, @Nullable ImmutableList<DestructuringBinding> destructures) {
            Preconditions.checkArgument(alias == null || destructures == null, "Import statement cannot be simultaneously aliasing and destructuring");
            return new AutoValue_CheckRequiresSorted_ImportStatement(nodes, primitive, namespace, alias, destructures);
        }

        boolean isStandalone() {
            return !this.isAliasing() && !this.isDestructuring();
        }

        boolean isAliasing() {
            return this.alias() != null;
        }

        boolean isDestructuring() {
            return this.destructures() != null;
        }

        ImportStatement upgrade(ImportPrimitive otherPrimitive) {
            if (ImportPrimitive.stronger(this.primitive(), otherPrimitive) != this.primitive()) {
                return new AutoValue_CheckRequiresSorted_ImportStatement(this.nodes(), otherPrimitive, this.namespace(), this.alias(), this.destructures());
            }
            return this;
        }

        private String formatWithoutDoc() {
            StringBuilder sb = new StringBuilder();
            if (!this.isStandalone()) {
                sb.append("const ");
            }
            if (this.alias() != null) {
                sb.append(this.alias());
            }
            if (this.destructures() != null) {
                sb.append("{");
                boolean first = true;
                for (DestructuringBinding binding : this.destructures()) {
                    String exportedName = binding.exportedName();
                    String localName = binding.localName();
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(exportedName);
                    if (exportedName.equals(localName)) continue;
                    sb.append(": ");
                    sb.append(localName);
                }
                sb.append("}");
            }
            if (!this.isStandalone()) {
                sb.append(" = ");
            }
            sb.append(this.primitive().toString());
            sb.append("('");
            sb.append(this.namespace());
            sb.append("');");
            return sb.toString();
        }

        public String format() {
            StringBuilder sb = new StringBuilder();
            for (Node node : this.nodes()) {
                JSDocInfo jsDoc;
                String comment = node.getNonJSDocCommentString();
                if (!comment.isEmpty()) {
                    sb.append(node.getNonJSDocCommentString()).append("\n");
                }
                if ((jsDoc = NodeUtil.getBestJSDocInfo(node)) == null) continue;
                sb.append(jsDoc.getOriginalCommentString()).append("\n");
            }
            sb.append(this.formatWithoutDoc());
            return sb.toString();
        }

        @Override
        public int compareTo(ImportStatement other) {
            return this.formatWithoutDoc().compareTo(other.formatWithoutDoc());
        }
    }

    @Immutable
    static abstract class DestructuringBinding
    implements Comparable<DestructuringBinding> {
        DestructuringBinding() {
        }

        abstract String exportedName();

        abstract String localName();

        static DestructuringBinding of(String exportedName, String localName) {
            return new AutoValue_CheckRequiresSorted_DestructuringBinding(exportedName, localName);
        }

        @Override
        public int compareTo(DestructuringBinding other) {
            return ComparisonChain.start().compare((Comparable<?>)((Object)this.exportedName()), (Comparable<?>)((Object)other.exportedName())).compare((Comparable<?>)((Object)this.localName()), (Comparable<?>)((Object)other.localName())).result();
        }
    }

    static enum ImportPrimitive {
        REQUIRE("goog.require"),
        REQUIRE_TYPE("goog.requireType"),
        FORWARD_DECLARE("goog.forwardDeclare");

        private final String name;
        static ImportPrimitive WEAKEST;

        private ImportPrimitive(String name) {
            this.name = name;
        }

        static ImportPrimitive fromName(String name) {
            for (ImportPrimitive primitive : ImportPrimitive.values()) {
                if (!primitive.name.equals(name)) continue;
                return primitive;
            }
            throw new IllegalArgumentException("Invalid primitive name " + name);
        }

        @Nullable
        static ImportPrimitive stronger(ImportPrimitive p1, ImportPrimitive p2) {
            return p1.ordinal() < p2.ordinal() ? p1 : p2;
        }

        public String toString() {
            return this.name;
        }

        static {
            WEAKEST = FORWARD_DECLARE;
        }
    }

    public static enum Mode {
        COLLECT_ONLY,
        COLLECT_AND_REPORT;

    }
}

