/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Ascii;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.DoNotCall;
import com.google.javascript.rhino.InputId;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.QualifiedName;
import com.google.javascript.rhino.SimpleSourceFile;
import com.google.javascript.rhino.StaticSourceFile;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.jstype.JSType;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

public class Node
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final Prop JSDOC_INFO_PROP = Prop.JSDOC_INFO;
    public static final Prop INCRDECR_PROP = Prop.INCRDECR;
    public static final Prop QUOTED_PROP = Prop.QUOTED;
    public static final Prop ORIGINALNAME_PROP = Prop.ORIGINALNAME;
    public static final Prop IS_CONSTANT_NAME = Prop.IS_CONSTANT_NAME;
    public static final Prop IS_NAMESPACE = Prop.IS_NAMESPACE;
    public static final Prop DIRECT_EVAL = Prop.DIRECT_EVAL;
    public static final Prop FREE_CALL = Prop.FREE_CALL;
    public static final Prop SLASH_V = Prop.SLASH_V;
    public static final Prop REFLECTED_OBJECT = Prop.REFLECTED_OBJECT;
    public static final Prop STATIC_MEMBER = Prop.STATIC_MEMBER;
    public static final Prop GENERATOR_FN = Prop.GENERATOR_FN;
    public static final Prop YIELD_ALL = Prop.YIELD_ALL;
    public static final Prop EXPORT_DEFAULT = Prop.EXPORT_DEFAULT;
    public static final Prop EXPORT_ALL_FROM = Prop.EXPORT_ALL_FROM;
    public static final Prop COMPUTED_PROP_METHOD = Prop.COMPUTED_PROP_METHOD;
    public static final Prop COMPUTED_PROP_GETTER = Prop.COMPUTED_PROP_GETTER;
    public static final Prop COMPUTED_PROP_SETTER = Prop.COMPUTED_PROP_SETTER;
    public static final Prop COMPUTED_PROP_VARIABLE = Prop.COMPUTED_PROP_VARIABLE;
    public static final Prop OPT_ES6_TYPED = Prop.OPT_ES6_TYPED;
    public static final Prop GENERIC_TYPE_LIST = Prop.GENERIC_TYPE;
    public static final Prop IMPLEMENTS = Prop.IMPLEMENTS;
    public static final Prop CONSTRUCT_SIGNATURE = Prop.CONSTRUCT_SIGNATURE;
    public static final Prop ACCESS_MODIFIER = Prop.ACCESS_MODIFIER;
    public static final Prop PARSE_RESULTS = Prop.PARSE_RESULTS;
    public static final Prop GOOG_MODULE = Prop.GOOG_MODULE;
    public static final Prop FEATURE_SET = Prop.FEATURE_SET;
    public static final Prop IS_MODULE_NAME = Prop.IS_MODULE_NAME;
    public static final Prop WAS_PREVIOUSLY_PROVIDED = Prop.WAS_PREVIOUSLY_PROVIDED;
    public static final Prop IS_ES6_CLASS = Prop.IS_ES6_CLASS;
    public static final Prop TRANSPILED = Prop.TRANSPILED;
    public static final Prop MODULE_ALIAS = Prop.MODULE_ALIAS;
    public static final Prop MODULE_EXPORT = Prop.MODULE_EXPORT;
    public static final Prop IS_SHORTHAND_PROPERTY = Prop.IS_SHORTHAND_PROPERTY;
    public static final Prop ES6_MODULE = Prop.ES6_MODULE;
    transient Token token;
    @Nullable
    transient Node next;
    @Nullable
    transient Node previous;
    @Nullable
    transient Node first;
    @Nullable
    private transient PropListItem propListHead;
    public static final int COLUMN_BITS = 12;
    public static final int MAX_COLUMN_NUMBER = 4095;
    public static final int COLUMN_MASK = 4095;
    private transient int sourcePosition;
    private transient int length;
    @Nullable
    private transient JSType jstype;
    @Nullable
    protected transient Node parent;
    private static final ImmutableList<Function<Node, Object>> PROP_GETTERS_FOR_EQUALITY = ImmutableList.of(Node::isArrowFunction, Node::isAsyncFunction, Node::isAsyncGeneratorFunction, Node::isGeneratorFunction, Node::isStaticMember, Node::isYieldAll, n -> n.getIntProp(Prop.SLASH_V), n -> n.getIntProp(Prop.INCRDECR), n -> n.getIntProp(Prop.QUOTED), n -> n.getBooleanProp(Prop.FREE_CALL), n -> n.getBooleanProp(Prop.COMPUTED_PROP_METHOD), n -> n.getBooleanProp(Prop.COMPUTED_PROP_GETTER), new Function[]{n -> n.getBooleanProp(Prop.COMPUTED_PROP_SETTER)});
    private static List<Node> incompleteNodes = null;

    public final String getNonJSDocCommentString() {
        if (this.getProp(Prop.NON_JSDOC_COMMENT) == null) {
            return "";
        }
        return (String)this.getProp(Prop.NON_JSDOC_COMMENT);
    }

    public final Node setNonJSDocComment(String comment) {
        this.putProp(Prop.NON_JSDOC_COMMENT, comment);
        return this;
    }

    private static final String propToString(Prop propType) {
        return Ascii.toLowerCase(String.valueOf((Object)propType));
    }

    public Node(Token nodeType) {
        this.token = nodeType;
        this.parent = null;
        this.sourcePosition = -1;
    }

    public Node(Token nodeType, Node child) {
        Preconditions.checkArgument(child.parent == null, "new child has existing parent");
        Preconditions.checkArgument(child.next == null, "new child has existing next sibling");
        Preconditions.checkArgument(child.previous == null, "new child has existing previous sibling");
        this.token = nodeType;
        this.parent = null;
        this.first = child;
        child.next = null;
        child.previous = this.first;
        child.parent = this;
        this.sourcePosition = -1;
    }

    public Node(Token nodeType, Node left, Node right) {
        Preconditions.checkArgument(left.parent == null, "first new child has existing parent");
        Preconditions.checkArgument(left.next == null, "first new child has existing next sibling");
        Preconditions.checkArgument(left.previous == null, "first new child has existing previous sibling");
        Preconditions.checkArgument(right.parent == null, "second new child has existing parent");
        Preconditions.checkArgument(right.next == null, "second new child has existing next sibling");
        Preconditions.checkArgument(right.previous == null, "second new child has existing previous sibling");
        this.token = nodeType;
        this.parent = null;
        this.first = left;
        left.next = right;
        left.previous = right;
        left.parent = this;
        right.next = null;
        right.previous = left;
        right.parent = this;
        this.sourcePosition = -1;
    }

    public Node(Token nodeType, Node left, Node mid, Node right) {
        Preconditions.checkArgument(left.parent == null);
        Preconditions.checkArgument(left.next == null);
        Preconditions.checkArgument(left.previous == null);
        Preconditions.checkArgument(mid.parent == null);
        Preconditions.checkArgument(mid.next == null);
        Preconditions.checkArgument(mid.previous == null);
        Preconditions.checkArgument(right.parent == null);
        Preconditions.checkArgument(right.next == null);
        Preconditions.checkArgument(right.previous == null);
        this.token = nodeType;
        this.parent = null;
        this.first = left;
        left.next = mid;
        left.previous = right;
        left.parent = this;
        mid.next = right;
        mid.previous = left;
        mid.parent = this;
        right.next = null;
        right.previous = mid;
        right.parent = this;
        this.sourcePosition = -1;
    }

    Node(Token nodeType, Node left, Node mid, Node mid2, Node right) {
        Preconditions.checkArgument(left.parent == null);
        Preconditions.checkArgument(left.next == null);
        Preconditions.checkArgument(left.previous == null);
        Preconditions.checkArgument(mid.parent == null);
        Preconditions.checkArgument(mid.next == null);
        Preconditions.checkArgument(mid.previous == null);
        Preconditions.checkArgument(mid2.parent == null);
        Preconditions.checkArgument(mid2.next == null);
        Preconditions.checkArgument(mid2.previous == null);
        Preconditions.checkArgument(right.parent == null);
        Preconditions.checkArgument(right.next == null);
        Preconditions.checkArgument(right.previous == null);
        this.token = nodeType;
        this.parent = null;
        this.first = left;
        left.next = mid;
        left.previous = right;
        left.parent = this;
        mid.next = mid2;
        mid.previous = left;
        mid.parent = this;
        mid2.next = right;
        mid2.previous = mid;
        mid2.parent = this;
        right.next = null;
        right.previous = mid2;
        right.parent = this;
        this.sourcePosition = -1;
    }

    public Node(Token nodeType, int lineno, int charno) {
        this.token = nodeType;
        this.parent = null;
        this.sourcePosition = Node.mergeLineCharNo(lineno, charno);
    }

    public Node(Token nodeType, Node child, int lineno, int charno) {
        this(nodeType, child);
        this.sourcePosition = Node.mergeLineCharNo(lineno, charno);
    }

    public static Node newNumber(double number) {
        return new NumberNode(number);
    }

    public static Node newNumber(double number, int lineno, int charno) {
        return new NumberNode(number, lineno, charno);
    }

    public static Node newString(String str) {
        return new StringNode(Token.STRING, str);
    }

    public static Node newString(Token token, String str) {
        return new StringNode(token, str);
    }

    public static Node newString(String str, int lineno, int charno) {
        return new StringNode(Token.STRING, str, lineno, charno);
    }

    public static Node newString(Token token, String str, int lineno, int charno) {
        return new StringNode(token, str, lineno, charno);
    }

    public static Node newTemplateLitString(String cooked, String raw) {
        return new TemplateLiteralSubstringNode(cooked, raw);
    }

    public final Token getToken() {
        return this.token;
    }

    public final void setToken(Token token) {
        this.token = token;
    }

    public final boolean hasChildren() {
        return this.first != null;
    }

    public final Node getOnlyChild() {
        Preconditions.checkState(this.hasOneChild());
        return this.first;
    }

    @Nullable
    public final Node getFirstChild() {
        return this.first;
    }

    @Nullable
    public final Node getFirstFirstChild() {
        return this.first.first;
    }

    @Nullable
    public final Node getSecondChild() {
        return this.first.next;
    }

    @Nullable
    public final Node getLastChild() {
        return this.first != null ? this.first.previous : null;
    }

    @Nullable
    public final Node getNext() {
        return this.next;
    }

    @Nullable
    public final Node getPrevious() {
        return this == this.parent.first ? null : this.previous;
    }

    @Nullable
    private final Node getPrevious(@Nullable Node firstSibling) {
        return this == firstSibling ? null : this.previous;
    }

    @Nullable
    public final Node getChildBefore(Node child) {
        return child.getPrevious(this.first);
    }

    public final Node getChildAtIndex(int i) {
        Node n = this.first;
        while (i > 0) {
            n = n.next;
            --i;
        }
        return n;
    }

    public final int getIndexOfChild(Node child) {
        Node n = this.first;
        int i = 0;
        while (n != null) {
            if (child == n) {
                return i;
            }
            n = n.next;
            ++i;
        }
        return -1;
    }

    public final void addChildToFront(Node child) {
        Preconditions.checkArgument(child.parent == null);
        Preconditions.checkArgument(child.next == null);
        Preconditions.checkArgument(child.previous == null);
        child.parent = this;
        child.next = this.first;
        if (this.first == null) {
            child.previous = child;
        } else {
            Node last;
            child.previous = last = this.first.previous;
            child.next = this.first;
            this.first.previous = child;
        }
        this.first = child;
    }

    public final void addChildToBack(Node child) {
        Preconditions.checkArgument(child.parent == null, "Cannot add already-owned child node.\nChild: %s\nExisting parent: %s\nNew parent: %s", (Object)child, (Object)child.parent, (Object)this);
        Preconditions.checkArgument(child.next == null);
        Preconditions.checkArgument(child.previous == null);
        if (this.first == null) {
            child.previous = child;
            this.first = child;
        } else {
            Node last = this.first.previous;
            last.next = child;
            child.previous = last;
            this.first.previous = child;
        }
        child.parent = this;
    }

    public final void addChildrenToFront(@Nullable Node children) {
        if (children == null) {
            return;
        }
        Preconditions.checkNotNull(children.previous, children);
        Node child = children;
        while (child != null) {
            Preconditions.checkArgument(child.parent == null);
            child.parent = this;
            child = child.next;
        }
        Node lastSib = children.previous;
        if (this.first != null) {
            Node last;
            children.previous = last = this.first.previous;
            lastSib.next = this.first;
            this.first.previous = lastSib;
        }
        this.first = children;
    }

    public final void addChildrenToBack(Node children) {
        this.addChildrenAfter(children, this.getLastChild());
    }

    public final void addChildBefore(Node newChild, Node node) {
        Preconditions.checkArgument(node.parent == this, "The existing child node of the parent should not be null.");
        Preconditions.checkArgument(newChild.next == null, "The new child node has next siblings.");
        Preconditions.checkArgument(newChild.previous == null, "The new child node has previous siblings.");
        Preconditions.checkArgument(newChild.parent == null, "The new child node already has a parent.");
        if (this.first == node) {
            Node last = this.first.previous;
            newChild.parent = this;
            newChild.next = this.first;
            newChild.previous = last;
            this.first.previous = newChild;
            this.first = newChild;
        } else {
            this.addChildAfter(newChild, node.previous);
        }
    }

    public final void addChildAfter(Node newChild, @Nullable Node node) {
        Preconditions.checkArgument(newChild.next == null, "The new child node has next siblings.");
        Preconditions.checkArgument(newChild.previous == null, "The new child node has previous siblings.");
        newChild.previous = newChild;
        this.addChildrenAfter(newChild, node);
    }

    public final void addChildrenAfter(@Nullable Node children, @Nullable Node node) {
        Node nodeAfter;
        if (children == null) {
            return;
        }
        Preconditions.checkArgument(node == null || node.parent == this);
        Preconditions.checkNotNull(children.previous, children);
        if (node == null) {
            this.addChildrenToFront(children);
            return;
        }
        Node child = children;
        while (child != null) {
            Preconditions.checkArgument(child.parent == null);
            child.parent = this;
            child = child.next;
        }
        Node lastSibling = children.previous;
        lastSibling.next = nodeAfter = node.next;
        if (nodeAfter == null) {
            this.first.previous = lastSibling;
        } else {
            nodeAfter.previous = lastSibling;
        }
        node.next = children;
        children.previous = node;
    }

    public final void removeChild(Node child) {
        Preconditions.checkState(child.parent == this, "%s is not the parent of %s", (Object)this, (Object)child);
        Preconditions.checkNotNull(child.previous);
        Node last = this.first.previous;
        Node prevSibling = child.previous;
        Node nextSibling = child.next;
        if (this.first == child) {
            this.first = nextSibling;
            if (nextSibling != null) {
                nextSibling.previous = last;
            }
        } else if (child == last) {
            this.first.previous = prevSibling;
            prevSibling.next = null;
        } else {
            prevSibling.next = nextSibling;
            nextSibling.previous = prevSibling;
        }
        child.next = null;
        child.previous = null;
        child.parent = null;
    }

    public final void replaceWith(Node newNode) {
        this.parent.replaceChild(this, newNode);
    }

    public final void replaceChild(Node child, Node newChild) {
        Preconditions.checkArgument(newChild.next == null, "The new child node has next siblings.");
        Preconditions.checkArgument(newChild.previous == null, "The new child node has previous siblings.");
        Preconditions.checkArgument(newChild.parent == null, "The new child node already has a parent.");
        Preconditions.checkState(child.parent == this, "%s is not the parent of %s", (Object)this, (Object)child);
        newChild.useSourceInfoIfMissingFrom(child);
        newChild.parent = this;
        Node nextSibling = child.next;
        Node prevSibling = child.previous;
        Node last = this.first.previous;
        if (child == prevSibling) {
            this.first = newChild;
            this.first.previous = newChild;
        } else {
            if (child == this.first) {
                this.first = newChild;
            } else {
                prevSibling.next = newChild;
            }
            if (child == last) {
                this.first.previous = newChild;
            } else {
                nextSibling.previous = newChild;
            }
            newChild.previous = prevSibling;
        }
        newChild.next = nextSibling;
        child.next = null;
        child.previous = null;
        child.parent = null;
    }

    public final void replaceChildAfter(Node prevChild, Node newChild) {
        Preconditions.checkNotNull(prevChild.next, "prev doesn't have a sibling to replace.");
        this.replaceChild(prevChild.next, newChild);
    }

    public final void replaceFirstOrChildAfter(@Nullable Node prev, Node newChild) {
        Node target = prev == null ? this.first : prev.next;
        Preconditions.checkNotNull(target, "prev doesn't have a sibling to replace.");
        this.replaceChild(target, newChild);
    }

    @Nullable
    @VisibleForTesting
    final PropListItem lookupProperty(Prop prop) {
        byte propType = (byte)prop.ordinal();
        PropListItem x = this.propListHead;
        while (x != null && propType != x.propType) {
            x = x.next;
        }
        return x;
    }

    public final Node clonePropsFrom(Node other) {
        Preconditions.checkState(this.propListHead == null, "Node has existing properties.");
        this.propListHead = other.propListHead;
        return this;
    }

    public final boolean hasProps() {
        return this.propListHead != null;
    }

    public final void removeProp(Prop propType) {
        PropListItem result = this.removeProp(this.propListHead, (byte)propType.ordinal());
        if (result != this.propListHead) {
            this.propListHead = result;
        }
    }

    @Nullable
    private final PropListItem removeProp(@Nullable PropListItem item, byte propType) {
        if (item == null) {
            return null;
        }
        if (item.propType == propType) {
            return item.next;
        }
        PropListItem result = this.removeProp(item.next, propType);
        if (result != item.next) {
            return item.chain(result);
        }
        return item;
    }

    @Nullable
    public final Object getProp(Prop propType) {
        PropListItem item = this.lookupProperty(propType);
        if (item == null) {
            return null;
        }
        return item.getObjectValue();
    }

    public final boolean getBooleanProp(Prop propType) {
        return this.getIntProp(propType) != 0;
    }

    public final int getIntProp(Prop propType) {
        PropListItem item = this.lookupProperty(propType);
        if (item == null) {
            return 0;
        }
        return item.getIntValue();
    }

    public final int getExistingIntProp(Prop propType) {
        PropListItem item = this.lookupProperty(propType);
        if (item == null) {
            throw new IllegalStateException("missing prop: " + (Object)((Object)propType));
        }
        return item.getIntValue();
    }

    public final void putProp(Prop propType, @Nullable Object value) {
        this.removeProp(propType);
        if (value != null) {
            this.propListHead = this.createProp((byte)propType.ordinal(), value, this.propListHead);
        }
    }

    public final void putBooleanProp(Prop propType, boolean value) {
        this.putIntProp(propType, value ? 1 : 0);
    }

    public final void putIntProp(Prop propType, int value) {
        this.removeProp(propType);
        if (value != 0) {
            this.propListHead = this.createProp((byte)propType.ordinal(), value, this.propListHead);
        }
    }

    public final void setDeclaredTypeExpression(TypeDeclarationNode typeExpression) {
        this.putProp(Prop.DECLARED_TYPE_EXPR, typeExpression);
    }

    @Nullable
    public final TypeDeclarationNode getDeclaredTypeExpression() {
        return (TypeDeclarationNode)this.getProp(Prop.DECLARED_TYPE_EXPR);
    }

    final PropListItem createProp(byte propType, Object value, @Nullable PropListItem next) {
        return new ObjectPropListItem(propType, value, next);
    }

    final PropListItem createProp(byte propType, int value, @Nullable PropListItem next) {
        return new IntPropListItem(propType, value, next);
    }

    public final void setJSTypeBeforeCast(JSType type) {
        this.putProp(Prop.TYPE_BEFORE_CAST, type);
    }

    @Nullable
    public final JSType getJSTypeBeforeCast() {
        return (JSType)this.getProp(Prop.TYPE_BEFORE_CAST);
    }

    private byte[] getSortedPropTypes() {
        int count = 0;
        PropListItem x = this.propListHead;
        while (x != null) {
            ++count;
            x = x.next;
        }
        byte[] keys = new byte[count];
        PropListItem x2 = this.propListHead;
        while (x2 != null) {
            keys[--count] = x2.propType;
            x2 = x2.next;
        }
        Arrays.sort(keys);
        return keys;
    }

    public double getDouble() {
        if (this.token == Token.NUMBER) {
            throw new IllegalStateException("Number node not created with Node.newNumber");
        }
        throw new UnsupportedOperationException(this + " is not a number node");
    }

    public void setDouble(double value) {
        if (this.token == Token.NUMBER) {
            throw new IllegalStateException("Number node not created with Node.newNumber");
        }
        throw new UnsupportedOperationException(this + " is not a string node");
    }

    public String getString() {
        if (this.token == Token.STRING) {
            throw new IllegalStateException("String node not created with Node.newString");
        }
        throw new UnsupportedOperationException(this + " is not a string node");
    }

    public void setString(String value) {
        if (this.token == Token.STRING || this.token == Token.NAME) {
            throw new IllegalStateException("String node not created with Node.newString");
        }
        throw new UnsupportedOperationException(this + " is not a string node");
    }

    public String getRawString() {
        if (this.token == Token.TEMPLATELIT_STRING) {
            throw new IllegalStateException("Template Literal String node not created with Node.newTemplateLitString");
        }
        throw new UnsupportedOperationException(this + " is not a template literal string node");
    }

    @Nullable
    public String getCookedString() {
        if (this.token == Token.TEMPLATELIT_STRING) {
            throw new IllegalStateException("Template Literal String node not created with Node.newTemplateLitString");
        }
        throw new UnsupportedOperationException(this + " is not a template literal string node");
    }

    public final String toString() {
        return this.toString(true, true, true);
    }

    public final String toString(boolean printSource, boolean printAnnotations, boolean printType) {
        StringBuilder sb = new StringBuilder();
        this.toString(sb, printSource, printAnnotations, printType);
        return sb.toString();
    }

    private void toString(StringBuilder sb, boolean printSource, boolean printAnnotations, boolean printType) {
        String typeString;
        sb.append((Object)this.token);
        if (this instanceof StringNode) {
            sb.append(' ');
            sb.append(this.getString());
        } else if (this.token == Token.FUNCTION) {
            sb.append(' ');
            if (this.first == null || this.first.token != Token.NAME) {
                sb.append("<invalid>");
            } else {
                sb.append(this.first.getString());
            }
        } else if (this.token == Token.NUMBER) {
            sb.append(' ');
            sb.append(this.getDouble());
        }
        if (printSource) {
            int lineno = this.getLineno();
            if (lineno != -1) {
                sb.append(' ');
                sb.append(lineno);
            }
            if (this.length != 0) {
                sb.append(" [length: ");
                sb.append(this.length);
                sb.append(']');
            }
        }
        if (printAnnotations) {
            byte[] keys = this.getSortedPropTypes();
            for (int i = 0; i < keys.length; ++i) {
                Prop type = Prop.values()[keys[i]];
                PropListItem x = this.lookupProperty(type);
                sb.append(" [");
                sb.append(Node.propToString(type));
                sb.append(": ");
                sb.append(x);
                sb.append(']');
            }
        }
        if (printType && this.jstype != null && (typeString = this.jstype.toString()) != null) {
            sb.append(" : ");
            sb.append(typeString);
        }
    }

    @CheckReturnValue
    public final String toStringTree() {
        return this.toStringTreeImpl();
    }

    private String toStringTreeImpl() {
        try {
            StringBuilder s = new StringBuilder();
            this.appendStringTree(s);
            return s.toString();
        }
        catch (IOException e) {
            throw new RuntimeException("Should not happen\n" + e);
        }
    }

    public final void appendStringTree(Appendable appendable) throws IOException {
        Node.toStringTreeHelper(this, 0, appendable);
    }

    private static void toStringTreeHelper(Node n, int level, Appendable sb) throws IOException {
        for (int i = 0; i != level; ++i) {
            sb.append("    ");
        }
        sb.append(n.toString());
        sb.append('\n');
        Node cursor = n.first;
        while (cursor != null) {
            Node.toStringTreeHelper(cursor, level + 1, sb);
            cursor = cursor.next;
        }
    }

    public final void setStaticSourceFileFrom(Node other) {
        if (other.propListHead != null && (this.propListHead == null || this.propListHead.propType == Prop.SOURCE_FILE.ordinal() && this.propListHead.next == null)) {
            PropListItem tail = other.propListHead;
            while (tail.next != null) {
                tail = tail.next;
            }
            if (tail.propType == Prop.SOURCE_FILE.ordinal()) {
                this.propListHead = tail;
                return;
            }
        }
        this.setStaticSourceFile(other.getStaticSourceFile());
    }

    public final void setStaticSourceFile(@Nullable StaticSourceFile file) {
        this.putProp(Prop.SOURCE_FILE, file);
    }

    public final void setSourceFileForTesting(String name) {
        this.putProp(Prop.SOURCE_FILE, new SimpleSourceFile(name, StaticSourceFile.SourceKind.STRONG));
    }

    @Nullable
    public String getSourceFileName() {
        StaticSourceFile file = this.getStaticSourceFile();
        return file == null ? null : file.getName();
    }

    @Nullable
    public StaticSourceFile getStaticSourceFile() {
        return (StaticSourceFile)this.getProp(Prop.SOURCE_FILE);
    }

    public void setInputId(InputId inputId) {
        this.putProp(Prop.INPUT_ID, inputId);
    }

    @Nullable
    public InputId getInputId() {
        return (InputId)this.getProp(Prop.INPUT_ID);
    }

    @Nullable
    public String getOriginalName() {
        return (String)this.getProp(Prop.ORIGINALNAME);
    }

    public void setOriginalName(String originalName) {
        this.putProp(Prop.ORIGINALNAME, originalName);
    }

    public final boolean isIndexable() {
        return !this.getBooleanProp(Prop.NON_INDEXABLE);
    }

    public final void makeNonIndexable() {
        this.putBooleanProp(Prop.NON_INDEXABLE, true);
    }

    public final void makeNonIndexableRecursive() {
        this.makeNonIndexable();
        for (Node child : this.children()) {
            child.makeNonIndexableRecursive();
        }
    }

    public final boolean isFromExterns() {
        StaticSourceFile file = this.getStaticSourceFile();
        return file == null ? false : file.isExtern();
    }

    public final int getLength() {
        return this.length;
    }

    public final void setLength(int length) {
        this.length = length;
    }

    public final void setLengthForTree(int length) {
        this.length = length;
        Node child = this.first;
        while (child != null) {
            child.setLengthForTree(length);
            child = child.next;
        }
    }

    public final int getLineno() {
        return Node.extractLineno(this.sourcePosition);
    }

    public final int getCharno() {
        return Node.extractCharno(this.sourcePosition);
    }

    public int getSourceOffset() {
        StaticSourceFile file = this.getStaticSourceFile();
        if (file == null) {
            return -1;
        }
        int lineno = this.getLineno();
        if (lineno == -1) {
            return -1;
        }
        return file.getLineOffset(lineno) + this.getCharno();
    }

    public final int getSourcePosition() {
        return this.sourcePosition;
    }

    public final void setLineno(int lineno) {
        int charno = this.getCharno();
        if (charno == -1) {
            charno = 0;
        }
        this.sourcePosition = Node.mergeLineCharNo(lineno, charno);
    }

    public final void setCharno(int charno) {
        this.sourcePosition = Node.mergeLineCharNo(this.getLineno(), charno);
    }

    public final void setSourceEncodedPosition(int sourcePosition) {
        this.sourcePosition = sourcePosition;
    }

    public final void setSourceEncodedPositionForTree(int sourcePosition) {
        this.sourcePosition = sourcePosition;
        Node child = this.first;
        while (child != null) {
            child.setSourceEncodedPositionForTree(sourcePosition);
            child = child.next;
        }
    }

    protected static int mergeLineCharNo(int lineno, int charno) {
        if (lineno < 0 || charno < 0) {
            return -1;
        }
        if ((charno & 0xFFFFF000) != 0) {
            return lineno << 12 | 0xFFF;
        }
        return lineno << 12 | charno & 0xFFF;
    }

    protected static int extractLineno(int lineCharNo) {
        if (lineCharNo == -1) {
            return -1;
        }
        return lineCharNo >>> 12;
    }

    protected static int extractCharno(int lineCharNo) {
        if (lineCharNo == -1) {
            return -1;
        }
        return lineCharNo & 0xFFF;
    }

    public final Iterable<Node> children() {
        if (this.first == null) {
            return Collections.emptySet();
        }
        return new SiblingNodeIterable(this.first);
    }

    public final Iterable<Node> siblings() {
        return new SiblingNodeIterable(this);
    }

    @Nullable
    final PropListItem getPropListHeadForTesting() {
        return this.propListHead;
    }

    final void setPropListHead(@Nullable PropListItem propListHead) {
        this.propListHead = propListHead;
    }

    @Nullable
    public final Node getParent() {
        return this.parent;
    }

    @Nullable
    public final Node getGrandparent() {
        return this.parent == null ? null : this.parent.parent;
    }

    @Nullable
    public final Node getAncestor(int level) {
        Node node;
        Preconditions.checkArgument(level >= 0);
        for (node = this; node != null && level-- > 0; node = node.getParent()) {
        }
        return node;
    }

    public final boolean isDescendantOf(Node node) {
        Node n = this;
        while (n != null) {
            if (n == node) {
                return true;
            }
            n = n.parent;
        }
        return false;
    }

    public final boolean isOnlyChildOf(Node possibleParent) {
        return possibleParent == this.getParent() && this.getPrevious() == null && this.getNext() == null;
    }

    public final boolean isFirstChildOf(Node possibleParent) {
        return possibleParent == this.getParent() && this.getPrevious() == null;
    }

    public final boolean isSecondChildOf(Node possibleParent) {
        Node previousNode = this.getPrevious();
        return previousNode != null && previousNode.isFirstChildOf(possibleParent);
    }

    public final AncestorIterable getAncestors() {
        return new AncestorIterable(this.getParent());
    }

    public final boolean hasOneChild() {
        return this.first != null && this.first.next == null;
    }

    public final boolean hasTwoChildren() {
        return this.first != null && this.first.next != null && this.first.next == this.getLastChild();
    }

    public final boolean hasZeroOrOneChild() {
        return this.first == this.getLastChild();
    }

    public final boolean hasMoreThanOneChild() {
        return this.first != null && this.first.next != null;
    }

    public final boolean hasXChildren(int x) {
        int c;
        Node n = this.first;
        for (c = 0; n != null && c <= x; ++c) {
            n = n.next;
        }
        return c == x;
    }

    public final int getChildCount() {
        int c = 0;
        Node n = this.first;
        while (n != null) {
            ++c;
            n = n.next;
        }
        return c;
    }

    public final boolean hasChild(Node child) {
        Node n = this.first;
        while (n != null) {
            if (child == n) {
                return true;
            }
            n = n.next;
        }
        return false;
    }

    public final boolean isEquivalentToShallow(Node node) {
        return this.isEquivalentTo(node, false, false, false, false);
    }

    public final boolean isEquivalentWithSideEffectsTo(Node node) {
        return this.isEquivalentTo(node, false, true, false, true);
    }

    public final boolean isEquivalentWithSideEffectsToShallow(Node node) {
        return this.isEquivalentTo(node, false, false, false, true);
    }

    public final boolean isEquivalentToTyped(Node node) {
        return this.isEquivalentTo(node, true, true, true, false);
    }

    public final boolean isEquivalentTo(Node node) {
        return this.isEquivalentTo(node, false, true, false, false);
    }

    final boolean isEquivalentTo(Node node, boolean compareType, boolean recurse, boolean jsDoc) {
        return this.isEquivalentTo(node, compareType, recurse, jsDoc, false);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isEquivalentTo(Node node, boolean compareType, boolean recurse, boolean jsDoc, boolean sideEffect) {
        if (this.token != node.token || this.getChildCount() != node.getChildCount() || this.getClass() != node.getClass()) {
            return false;
        }
        if (compareType && !JSType.isEquivalent(this.getJSType(), node.getJSType())) {
            return false;
        }
        if (jsDoc && !JSDocInfo.areEquivalent(this.getJSDocInfo(), node.getJSDocInfo())) {
            return false;
        }
        TypeDeclarationNode thisTDN = this.getDeclaredTypeExpression();
        TypeDeclarationNode thatTDN = node.getDeclaredTypeExpression();
        if (!(thisTDN == null && thatTDN == null || thisTDN != null && thatTDN != null && thisTDN.isEquivalentTo(thatTDN, compareType, recurse, jsDoc))) {
            return false;
        }
        for (Function function : PROP_GETTERS_FOR_EQUALITY) {
            if (Objects.equal(function.apply(this), function.apply(node))) continue;
            return false;
        }
        if (sideEffect) {
            if (this.getSideEffectFlags() != node.getSideEffectFlags()) {
                return false;
            }
            if (this.isUnusedParameter() != node.isUnusedParameter()) {
                return false;
            }
        }
        if (recurse) {
            Node n = this.first;
            Node node2 = node.first;
            while (n != null) {
                void var9_11;
                if (!n.isEquivalentTo((Node)var9_11, compareType, recurse, jsDoc, sideEffect)) {
                    return false;
                }
                n = n.next;
                Node node3 = var9_11.next;
            }
        }
        return true;
    }

    @Nullable
    public final String getQualifiedName() {
        switch (this.token) {
            case NAME: {
                String name = this.getString();
                return name.isEmpty() ? null : name;
            }
            case GETPROP: {
                StringBuilder builder = this.getQualifiedNameForGetProp(0);
                return builder != null ? builder.toString() : null;
            }
            case THIS: {
                return "this";
            }
            case SUPER: {
                return "super";
            }
        }
        return null;
    }

    @Nullable
    public final QualifiedName getQualifiedNameObject() {
        return this.isQualifiedName() ? new QualifiedName.NodeQname(this) : null;
    }

    @Nullable
    private StringBuilder getQualifiedNameForGetProp(int reserve) {
        StringBuilder builder;
        String propName = this.getLastChild().getString();
        reserve += 1 + propName.length();
        if (this.first.isGetProp()) {
            builder = this.first.getQualifiedNameForGetProp(reserve);
            if (builder == null) {
                return null;
            }
        } else {
            String left = this.first.getQualifiedName();
            if (left == null) {
                return null;
            }
            builder = new StringBuilder(left.length() + reserve);
            builder.append(left);
        }
        builder.append('.').append(propName);
        return builder;
    }

    @Nullable
    public final String getOriginalQualifiedName() {
        if (this.token == Token.NAME || this.getBooleanProp(Prop.IS_MODULE_NAME)) {
            String name = this.getOriginalName();
            if (name == null) {
                name = this.getString();
            }
            return name.isEmpty() ? null : name;
        }
        if (this.token == Token.GETPROP) {
            String left = this.getFirstChild().getOriginalQualifiedName();
            if (left == null) {
                return null;
            }
            String right = this.getLastChild().getOriginalName();
            if (right == null) {
                right = this.getLastChild().getString();
            }
            return left + "." + right;
        }
        if (this.token == Token.THIS) {
            return "this";
        }
        if (this.token == Token.SUPER) {
            return "super";
        }
        return null;
    }

    public final boolean isQualifiedName() {
        switch (this.getToken()) {
            case NAME: {
                return !this.getString().isEmpty();
            }
            case THIS: 
            case SUPER: {
                return true;
            }
            case GETPROP: {
                return this.getFirstChild().isQualifiedName();
            }
        }
        return false;
    }

    public final boolean matchesName(String name) {
        if (this.token != Token.NAME) {
            return false;
        }
        String internalString = this.getString();
        return !internalString.isEmpty() && name.equals(internalString);
    }

    public final boolean matchesName(Node n) {
        if (this.token != Token.NAME || n.token != Token.NAME) {
            return false;
        }
        String internalString = this.getString();
        return internalString != "" && internalString == n.getString();
    }

    public final boolean matchesQualifiedName(String name) {
        return this.matchesQualifiedName(name, name.length());
    }

    private boolean matchesQualifiedName(String qname, int endIndex) {
        int start = qname.lastIndexOf(46, endIndex - 1) + 1;
        switch (this.getToken()) {
            case NAME: {
                String name = this.getString();
                return start == 0 && !name.isEmpty() && name.length() == endIndex && qname.startsWith(name);
            }
            case THIS: {
                return start == 0 && 4 == endIndex && qname.startsWith("this");
            }
            case SUPER: {
                return start == 0 && 5 == endIndex && qname.startsWith("super");
            }
            case GETPROP: {
                String prop = this.getLastChild().getString();
                return start > 1 && prop.length() == endIndex - start && prop.regionMatches(0, qname, start, endIndex - start) && this.getFirstChild().matchesQualifiedName(qname, start - 1);
            }
        }
        return false;
    }

    public final boolean matchesQualifiedName(Node n) {
        if (n.token != this.token) {
            return false;
        }
        switch (this.token) {
            case NAME: {
                String internalString = this.getString();
                return internalString != "" && internalString == n.getString();
            }
            case THIS: 
            case SUPER: {
                return true;
            }
            case GETPROP: {
                return this.getLastChild().getString() == n.getLastChild().getString() && this.getFirstChild().matchesQualifiedName(n.getFirstChild());
            }
        }
        return false;
    }

    public final boolean isUnscopedQualifiedName() {
        switch (this.getToken()) {
            case NAME: {
                return this.getString() != "";
            }
            case GETPROP: {
                return this.getFirstChild().isUnscopedQualifiedName();
            }
        }
        return false;
    }

    public final boolean isValidAssignmentTarget() {
        switch (this.getToken()) {
            case NAME: 
            case GETPROP: 
            case GETELEM: 
            case ARRAY_PATTERN: 
            case OBJECT_PATTERN: {
                return true;
            }
        }
        return false;
    }

    public final Node detachFromParent() {
        return this.detach();
    }

    public final Node detach() {
        Preconditions.checkNotNull(this.parent);
        this.parent.removeChild(this);
        return this;
    }

    @Nullable
    public final Node removeFirstChild() {
        Node child = this.first;
        if (child != null) {
            this.removeChild(child);
        }
        return child;
    }

    @Nullable
    public final Node removeChildren() {
        Node children = this.first;
        Node child = this.first;
        while (child != null) {
            child.parent = null;
            child = child.next;
        }
        this.first = null;
        return children;
    }

    public final void detachChildren() {
        Node child = this.first;
        while (child != null) {
            Node nextChild = child.next;
            child.parent = null;
            child.next = null;
            child.previous = null;
            child = nextChild;
        }
        this.first = null;
    }

    public final Node removeChildAfter(Node prev) {
        Node target = prev.next;
        Preconditions.checkNotNull(target, "no next sibling.");
        this.removeChild(target);
        return target;
    }

    public final Node removeFirstOrChildAfter(@Nullable Node prev) {
        Preconditions.checkArgument(prev == null || prev.parent == this, "invalid node.");
        Node target = prev == null ? this.first : prev.next;
        Preconditions.checkNotNull(target, "no next sibling.");
        this.removeChild(target);
        return target;
    }

    @CheckReturnValue
    public final Node cloneNode() {
        return this.cloneNode(false);
    }

    @CheckReturnValue
    protected Node cloneNode(boolean cloneTypeExprs) {
        return this.copyNodeFields(new Node(this.token), cloneTypeExprs);
    }

    final <T extends Node> T copyNodeFields(T dst, boolean cloneTypeExprs) {
        JSDocInfo info;
        dst.setSourceEncodedPosition(this.sourcePosition);
        dst.setLength(this.getLength());
        dst.setJSType(this.jstype);
        dst.setPropListHead(this.propListHead);
        if (cloneTypeExprs && (info = this.getJSDocInfo()) != null) {
            this.setJSDocInfo(info.clone(true));
        }
        return dst;
    }

    @CheckReturnValue
    public final Node cloneTree() {
        return this.cloneTree(false);
    }

    @CheckReturnValue
    public final Node cloneTree(boolean cloneTypeExprs) {
        Node result = this.cloneNode(cloneTypeExprs);
        Node firstChild = null;
        Node lastChild = null;
        if (this.hasChildren()) {
            Node n2 = this.getFirstChild();
            while (n2 != null) {
                Node n2clone = n2.cloneTree(cloneTypeExprs);
                n2clone.parent = result;
                if (firstChild == null) {
                    lastChild = firstChild = n2clone;
                } else {
                    lastChild.next = n2clone;
                    n2clone.previous = lastChild;
                    lastChild = n2clone;
                }
                n2 = n2.next;
            }
            firstChild.previous = lastChild;
            lastChild.next = null;
            result.first = firstChild;
        }
        return result;
    }

    public final Node useSourceInfoFrom(Node other) {
        this.setStaticSourceFileFrom(other);
        this.putProp(Prop.ORIGINALNAME, other.getProp(Prop.ORIGINALNAME));
        this.sourcePosition = other.sourcePosition;
        this.length = other.length;
        return this;
    }

    public final Node srcref(Node other) {
        return this.useSourceInfoFrom(other);
    }

    public final Node useSourceInfoFromForTree(Node other) {
        this.useSourceInfoFrom(other);
        Node child = this.first;
        while (child != null) {
            child.useSourceInfoFromForTree(other);
            child = child.next;
        }
        return this;
    }

    public final Node srcrefTree(Node other) {
        return this.useSourceInfoFromForTree(other);
    }

    public final Node useSourceInfoIfMissingFrom(Node other) {
        if (this.getStaticSourceFile() == null) {
            this.setStaticSourceFileFrom(other);
            this.sourcePosition = other.sourcePosition;
            this.length = other.length;
        }
        if (this.getProp(Prop.ORIGINALNAME) == null) {
            this.putProp(Prop.ORIGINALNAME, other.getProp(Prop.ORIGINALNAME));
        }
        return this;
    }

    public final Node useSourceInfoIfMissingFromForTree(Node other) {
        this.useSourceInfoIfMissingFrom(other);
        Node child = this.first;
        while (child != null) {
            child.useSourceInfoIfMissingFromForTree(other);
            child = child.next;
        }
        return this;
    }

    @Nullable
    public final JSType getJSType() {
        return this.jstype;
    }

    public final JSType getJSTypeRequired() {
        Preconditions.checkNotNull(this.jstype, "no jstype: %s", (Object)this);
        return this.jstype;
    }

    public final Node setJSType(@Nullable JSType jstype) {
        this.jstype = jstype;
        return this;
    }

    @Nullable
    public final JSDocInfo getJSDocInfo() {
        return (JSDocInfo)this.getProp(Prop.JSDOC_INFO);
    }

    public final Node setJSDocInfo(JSDocInfo info) {
        this.putProp(Prop.JSDOC_INFO, info);
        return this;
    }

    public final void setChangeTime(int time) {
        this.putIntProp(Prop.CHANGE_TIME, time);
    }

    public final int getChangeTime() {
        return this.getIntProp(Prop.CHANGE_TIME);
    }

    public final void setDeleted(boolean deleted) {
        this.putBooleanProp(Prop.DELETED, deleted);
    }

    public final boolean isDeleted() {
        return this.getBooleanProp(Prop.DELETED);
    }

    public final void setTypedefTypeProp(JSType type) {
        this.putProp(Prop.TYPEDEF_TYPE, type);
    }

    public final JSType getTypedefTypeProp() {
        return (JSType)this.getProp(Prop.TYPEDEF_TYPE);
    }

    public final void setUnusedParameter(boolean unused) {
        this.putBooleanProp(Prop.IS_UNUSED_PARAMETER, unused);
    }

    public final boolean isUnusedParameter() {
        return this.getBooleanProp(Prop.IS_UNUSED_PARAMETER);
    }

    public final void setShorthandProperty(boolean shorthand) {
        this.putBooleanProp(Prop.IS_SHORTHAND_PROPERTY, shorthand);
    }

    public final boolean isShorthandProperty() {
        return this.getBooleanProp(Prop.IS_SHORTHAND_PROPERTY);
    }

    public final void setVarArgs(boolean varArgs) {
        this.putBooleanProp(Prop.VAR_ARGS, varArgs);
    }

    public final boolean isVarArgs() {
        return this.getBooleanProp(Prop.VAR_ARGS);
    }

    public final void setOptionalArg(boolean optionalArg) {
        this.putBooleanProp(Prop.OPT_ARG, optionalArg);
    }

    public final boolean isOptionalArg() {
        return this.getBooleanProp(Prop.OPT_ARG);
    }

    public final boolean isOptionalEs6Typed() {
        return this.getBooleanProp(Prop.OPT_ES6_TYPED);
    }

    public final void setIsSyntheticBlock(boolean val) {
        Preconditions.checkState(this.token == Token.BLOCK);
        this.putBooleanProp(Prop.SYNTHETIC, val);
    }

    public final boolean isSyntheticBlock() {
        return this.getBooleanProp(Prop.SYNTHETIC);
    }

    public final void setDirectives(Set<String> val) {
        this.putProp(Prop.DIRECTIVES, val);
    }

    @Nullable
    public final Set<String> getDirectives() {
        return (Set)this.getProp(Prop.DIRECTIVES);
    }

    public final void setIsAddedBlock(boolean val) {
        this.putBooleanProp(Prop.ADDED_BLOCK, val);
    }

    public final boolean isAddedBlock() {
        return this.getBooleanProp(Prop.ADDED_BLOCK);
    }

    public final void setStaticMember(boolean isStatic) {
        this.putBooleanProp(Prop.STATIC_MEMBER, isStatic);
    }

    public final boolean isStaticMember() {
        return this.getBooleanProp(Prop.STATIC_MEMBER);
    }

    public final void setIsGeneratorFunction(boolean isGenerator) {
        this.putBooleanProp(Prop.GENERATOR_FN, isGenerator);
    }

    public final boolean isGeneratorFunction() {
        return this.getBooleanProp(Prop.GENERATOR_FN);
    }

    public final void setGeneratorMarker(boolean isGeneratorMarker) {
        this.putBooleanProp(Prop.IS_GENERATOR_MARKER, isGeneratorMarker);
    }

    public final boolean isGeneratorMarker() {
        return this.getBooleanProp(Prop.IS_GENERATOR_MARKER);
    }

    public final void setGeneratorSafe(boolean isGeneratorSafe) {
        this.putBooleanProp(Prop.IS_GENERATOR_SAFE, isGeneratorSafe);
    }

    public final boolean isGeneratorSafe() {
        return this.getBooleanProp(Prop.IS_GENERATOR_SAFE);
    }

    public final void setIsArrowFunction(boolean isArrow) {
        Preconditions.checkState(this.isFunction());
        this.putBooleanProp(Prop.ARROW_FN, isArrow);
    }

    public final boolean isArrowFunction() {
        return this.isFunction() && this.getBooleanProp(Prop.ARROW_FN);
    }

    public void setIsAsyncFunction(boolean isAsync) {
        Preconditions.checkState(this.isFunction());
        this.putBooleanProp(Prop.ASYNC_FN, isAsync);
    }

    public final boolean isAsyncFunction() {
        return this.isFunction() && this.getBooleanProp(Prop.ASYNC_FN);
    }

    public final boolean isAsyncGeneratorFunction() {
        return this.isAsyncFunction() && this.isGeneratorFunction();
    }

    public final void setYieldAll(boolean isGenerator) {
        this.putBooleanProp(Prop.YIELD_ALL, isGenerator);
    }

    public final boolean isYieldAll() {
        return this.getBooleanProp(Prop.YIELD_ALL);
    }

    public final boolean isEs6Class() {
        return this.isClass() || this.getBooleanProp(Prop.IS_ES6_CLASS);
    }

    public final String getDefineName() {
        return (String)this.getProp(Prop.DEFINE_NAME);
    }

    public final void setDefineName(String name) {
        this.putProp(Prop.DEFINE_NAME, name);
    }

    public final void setSideEffectFlags(int flags) {
        Preconditions.checkState(this.isCall() || this.isNew() || this.isTaggedTemplateLit(), "Side-effect flags can only be set on invocation nodes; got %s", (Object)this);
        this.putIntProp(Prop.SIDE_EFFECT_FLAGS, ~flags & 0x1F);
    }

    public final void setSideEffectFlags(SideEffectFlags flags) {
        this.setSideEffectFlags(flags.valueOf());
    }

    public final int getSideEffectFlags() {
        return ~this.getIntProp(Prop.SIDE_EFFECT_FLAGS) & 0x1F;
    }

    public final boolean isOnlyModifiesThisCall() {
        int consideredFlags = this.getSideEffectFlags();
        consideredFlags |= 0x10;
        return (consideredFlags &= 0xFFFFFFFD) == 16;
    }

    public final boolean isOnlyModifiesArgumentsCall() {
        int consideredFlags = this.getSideEffectFlags();
        consideredFlags |= 0x10;
        return (consideredFlags &= 0xFFFFFFFB) == 16;
    }

    public final boolean isNoSideEffectsCall() {
        int consideredFlags = this.getSideEffectFlags();
        return (consideredFlags |= 0x10) == 16;
    }

    public final boolean isLocalResultCall() {
        return !Node.allBitsSet(this.getSideEffectFlags(), 16);
    }

    public final boolean mayMutateArguments() {
        return Node.allBitsSet(this.getSideEffectFlags(), 4);
    }

    public final boolean mayMutateGlobalStateOrThrow() {
        return Node.anyBitSet(this.getSideEffectFlags(), 9);
    }

    private static boolean allBitsSet(int value, int mask) {
        return (value & mask) == mask;
    }

    private static boolean anyBitSet(int value, int mask) {
        return (value & mask) != 0;
    }

    private final int getConstantVarFlags() {
        return this.getIntProp(Prop.CONSTANT_VAR_FLAGS);
    }

    private final void setConstantVarFlag(int flag, boolean value) {
        int flags = this.getConstantVarFlags();
        flags = value ? (flags |= flag) : (flags &= ~flag);
        this.putIntProp(Prop.CONSTANT_VAR_FLAGS, flags);
    }

    public final boolean isDeclaredConstantVar() {
        Preconditions.checkState(this.isName(), "Should only be called on name nodes.");
        return Node.anyBitSet(this.getConstantVarFlags(), 1);
    }

    public final void setDeclaredConstantVar(boolean value) {
        Preconditions.checkState(this.isName(), "Should only be called on name nodes.");
        this.setConstantVarFlag(1, value);
    }

    public final boolean isInferredConstantVar() {
        Preconditions.checkState(this.isName(), "Should only be called on name nodes.");
        return Node.anyBitSet(this.getConstantVarFlags(), 2);
    }

    public final void setInferredConstantVar(boolean value) {
        Preconditions.checkState(this.isName(), "Should only be called on name nodes.");
        this.setConstantVarFlag(2, value);
    }

    public boolean isQuotedString() {
        return false;
    }

    public void setQuotedString() {
        throw new IllegalStateException(this + " is not a StringNode");
    }

    public final boolean isAdd() {
        return this.token == Token.ADD;
    }

    public final boolean isSub() {
        return this.token == Token.SUB;
    }

    public final boolean isAnd() {
        return this.token == Token.AND;
    }

    public final boolean isArrayLit() {
        return this.token == Token.ARRAYLIT;
    }

    public final boolean isArrayPattern() {
        return this.token == Token.ARRAY_PATTERN;
    }

    public final boolean isAssign() {
        return this.token == Token.ASSIGN;
    }

    public final boolean isAssignAdd() {
        return this.token == Token.ASSIGN_ADD;
    }

    public final boolean isNormalBlock() {
        return this.isBlock();
    }

    public final boolean isBlock() {
        return this.token == Token.BLOCK;
    }

    public final boolean isRoot() {
        return this.token == Token.ROOT;
    }

    public final boolean isAwait() {
        return this.token == Token.AWAIT;
    }

    public final boolean isBreak() {
        return this.token == Token.BREAK;
    }

    public final boolean isCall() {
        return this.token == Token.CALL;
    }

    public final boolean isCase() {
        return this.token == Token.CASE;
    }

    public final boolean isCast() {
        return this.token == Token.CAST;
    }

    public final boolean isCatch() {
        return this.token == Token.CATCH;
    }

    public final boolean isClass() {
        return this.token == Token.CLASS;
    }

    public final boolean isClassMembers() {
        return this.token == Token.CLASS_MEMBERS;
    }

    public final boolean isComma() {
        return this.token == Token.COMMA;
    }

    public final boolean isComputedProp() {
        return this.token == Token.COMPUTED_PROP;
    }

    public final boolean isContinue() {
        return this.token == Token.CONTINUE;
    }

    public final boolean isConst() {
        return this.token == Token.CONST;
    }

    public final boolean isDebugger() {
        return this.token == Token.DEBUGGER;
    }

    public final boolean isDec() {
        return this.token == Token.DEC;
    }

    public final boolean isDefaultCase() {
        return this.token == Token.DEFAULT_CASE;
    }

    public final boolean isDefaultValue() {
        return this.token == Token.DEFAULT_VALUE;
    }

    public final boolean isDelProp() {
        return this.token == Token.DELPROP;
    }

    public final boolean isDestructuringLhs() {
        return this.token == Token.DESTRUCTURING_LHS;
    }

    public final boolean isDestructuringPattern() {
        return this.isObjectPattern() || this.isArrayPattern();
    }

    public final boolean isDo() {
        return this.token == Token.DO;
    }

    public final boolean isEmpty() {
        return this.token == Token.EMPTY;
    }

    public final boolean isExport() {
        return this.token == Token.EXPORT;
    }

    public final boolean isExportSpec() {
        return this.token == Token.EXPORT_SPEC;
    }

    public final boolean isExportSpecs() {
        return this.token == Token.EXPORT_SPECS;
    }

    public final boolean isExprResult() {
        return this.token == Token.EXPR_RESULT;
    }

    public final boolean isFalse() {
        return this.token == Token.FALSE;
    }

    public final boolean isVanillaFor() {
        return this.token == Token.FOR;
    }

    public final boolean isForIn() {
        return this.token == Token.FOR_IN;
    }

    public final boolean isForOf() {
        return this.token == Token.FOR_OF;
    }

    public final boolean isForAwaitOf() {
        return this.token == Token.FOR_AWAIT_OF;
    }

    public final boolean isFunction() {
        return this.token == Token.FUNCTION;
    }

    public final boolean isGetterDef() {
        return this.token == Token.GETTER_DEF;
    }

    public final boolean isGetElem() {
        return this.token == Token.GETELEM;
    }

    public final boolean isGetProp() {
        return this.token == Token.GETPROP;
    }

    public final boolean isHook() {
        return this.token == Token.HOOK;
    }

    public final boolean isIf() {
        return this.token == Token.IF;
    }

    public final boolean isImport() {
        return this.token == Token.IMPORT;
    }

    public final boolean isImportStar() {
        return this.token == Token.IMPORT_STAR;
    }

    public final boolean isImportSpec() {
        return this.token == Token.IMPORT_SPEC;
    }

    public final boolean isImportSpecs() {
        return this.token == Token.IMPORT_SPECS;
    }

    public final boolean isIn() {
        return this.token == Token.IN;
    }

    public final boolean isInc() {
        return this.token == Token.INC;
    }

    public final boolean isInstanceOf() {
        return this.token == Token.INSTANCEOF;
    }

    public final boolean isInterfaceMembers() {
        return this.token == Token.INTERFACE_MEMBERS;
    }

    public final boolean isRecordType() {
        return this.token == Token.RECORD_TYPE;
    }

    public final boolean isCallSignature() {
        return this.token == Token.CALL_SIGNATURE;
    }

    public final boolean isIndexSignature() {
        return this.token == Token.INDEX_SIGNATURE;
    }

    public final boolean isLabel() {
        return this.token == Token.LABEL;
    }

    public final boolean isLabelName() {
        return this.token == Token.LABEL_NAME;
    }

    public final boolean isLet() {
        return this.token == Token.LET;
    }

    public final boolean isMemberFunctionDef() {
        return this.token == Token.MEMBER_FUNCTION_DEF;
    }

    public final boolean isMemberVariableDef() {
        return this.token == Token.MEMBER_VARIABLE_DEF;
    }

    public final boolean isModuleBody() {
        return this.token == Token.MODULE_BODY;
    }

    public final boolean isName() {
        return this.token == Token.NAME;
    }

    public final boolean isNE() {
        return this.token == Token.NE;
    }

    public final boolean isNew() {
        return this.token == Token.NEW;
    }

    public final boolean isNot() {
        return this.token == Token.NOT;
    }

    public final boolean isNull() {
        return this.token == Token.NULL;
    }

    public final boolean isNumber() {
        return this.token == Token.NUMBER;
    }

    public final boolean isObjectLit() {
        return this.token == Token.OBJECTLIT;
    }

    public final boolean isObjectPattern() {
        return this.token == Token.OBJECT_PATTERN;
    }

    public final boolean isOr() {
        return this.token == Token.OR;
    }

    public final boolean isParamList() {
        return this.token == Token.PARAM_LIST;
    }

    public final boolean isRegExp() {
        return this.token == Token.REGEXP;
    }

    public final boolean isRest() {
        return this.token == Token.ITER_REST || this.token == Token.OBJECT_REST;
    }

    public final boolean isReturn() {
        return this.token == Token.RETURN;
    }

    public final boolean isScript() {
        return this.token == Token.SCRIPT;
    }

    public final boolean isSetterDef() {
        return this.token == Token.SETTER_DEF;
    }

    public final boolean isSpread() {
        return this.token == Token.ITER_SPREAD || this.token == Token.OBJECT_SPREAD;
    }

    public final boolean isString() {
        return this.token == Token.STRING;
    }

    public final boolean isStringKey() {
        return this.token == Token.STRING_KEY;
    }

    public final boolean isSuper() {
        return this.token == Token.SUPER;
    }

    public final boolean isSwitch() {
        return this.token == Token.SWITCH;
    }

    public final boolean isTaggedTemplateLit() {
        return this.token == Token.TAGGED_TEMPLATELIT;
    }

    public final boolean isTemplateLit() {
        return this.token == Token.TEMPLATELIT;
    }

    public final boolean isTemplateLitString() {
        return this.token == Token.TEMPLATELIT_STRING;
    }

    public final boolean isTemplateLitSub() {
        return this.token == Token.TEMPLATELIT_SUB;
    }

    public final boolean isThis() {
        return this.token == Token.THIS;
    }

    public final boolean isThrow() {
        return this.token == Token.THROW;
    }

    public final boolean isTrue() {
        return this.token == Token.TRUE;
    }

    public final boolean isTry() {
        return this.token == Token.TRY;
    }

    public final boolean isTypeOf() {
        return this.token == Token.TYPEOF;
    }

    public final boolean isVar() {
        return this.token == Token.VAR;
    }

    public final boolean isVoid() {
        return this.token == Token.VOID;
    }

    public final boolean isWhile() {
        return this.token == Token.WHILE;
    }

    public final boolean isWith() {
        return this.token == Token.WITH;
    }

    public final boolean isYield() {
        return this.token == Token.YIELD;
    }

    @GwtIncompatible(value="ObjectOutputStream")
    private void writeObject(ObjectOutputStream out) throws Exception {
        Preconditions.checkState(Token.values().length < 255);
        out.writeByte(this.token.ordinal());
        this.writeEncodedInt(out, this.sourcePosition);
        this.writeEncodedInt(out, this.length);
        boolean isStartingNode = false;
        if (incompleteNodes == null) {
            isStartingNode = true;
            incompleteNodes = new ArrayList<Node>();
        }
        incompleteNodes.add(this);
        Node currentChild = this.first;
        while (currentChild != null) {
            out.writeObject(currentChild);
            currentChild = currentChild.next;
        }
        out.writeObject(null);
        out.writeObject(this.propListHead);
        if (isStartingNode) {
            List<Node> nodeList = incompleteNodes;
            incompleteNodes = null;
            for (Node n : nodeList) {
                out.writeObject(n.jstype);
            }
        }
    }

    @GwtIncompatible(value="ObjectInputStream")
    private void readObject(ObjectInputStream in) throws Exception {
        this.token = Token.values()[in.readUnsignedByte()];
        this.sourcePosition = this.readEncodedInt(in);
        this.length = this.readEncodedInt(in);
        boolean isStartingNode = false;
        if (incompleteNodes == null) {
            isStartingNode = true;
            incompleteNodes = new ArrayList<Node>();
        }
        incompleteNodes.add(this);
        this.first = (Node)in.readObject();
        if (this.first != null) {
            Node currentChild;
            Preconditions.checkState(this.first.parent == null);
            this.first.parent = this;
            Node lastChild = this.first;
            while ((currentChild = (Node)in.readObject()) != null) {
                Preconditions.checkState(currentChild.parent == null);
                currentChild.parent = this;
                Preconditions.checkState(currentChild.previous == null);
                currentChild.previous = lastChild;
                Preconditions.checkState(lastChild.next == null);
                lastChild.next = currentChild;
                lastChild = currentChild;
            }
            Preconditions.checkState(this.first.previous == null);
            this.first.previous = lastChild;
        }
        this.propListHead = (PropListItem)in.readObject();
        if (isStartingNode) {
            List<Node> nodeList = incompleteNodes;
            incompleteNodes = null;
            for (Node n : nodeList) {
                n.jstype = (JSType)in.readObject();
            }
        }
    }

    @GwtIncompatible(value="ObjectOutput")
    private void writeEncodedInt(ObjectOutput out, int value) throws IOException {
        while (value > 127 || value < 0) {
            out.writeByte(value & 0x7F | 0x80);
            value >>>= 7;
        }
        out.writeByte(value);
    }

    @GwtIncompatible(value="ObjectInput")
    private int readEncodedInt(ObjectInput in) throws IOException {
        byte current;
        int value = 0;
        int shift = 0;
        while ((current = in.readByte()) < 0) {
            value |= (current & 0x7F) << shift;
            shift += 7;
        }
        return value |= current << shift;
    }

    private static final class ConstantVarFlags {
        static final int DECLARED = 1;
        static final int INFERRED = 2;

        private ConstantVarFlags() {
        }
    }

    public static final class SideEffectFlags {
        public static final int MUTATES_GLOBAL_STATE = 1;
        public static final int MUTATES_THIS = 2;
        public static final int MUTATES_ARGUMENTS = 4;
        public static final int THROWS = 8;
        public static final int ESCAPED_RETURN = 16;
        private static final int USED_BITS_MASK = 31;
        public static final int NO_SIDE_EFFECTS = 16;
        public static final int ALL_SIDE_EFFECTS = 31;
        private int value = 31;

        public SideEffectFlags() {
        }

        public SideEffectFlags(int value) {
            this.value = value;
        }

        public int valueOf() {
            return this.value;
        }

        public SideEffectFlags setAllFlags() {
            this.value = 31;
            return this;
        }

        public SideEffectFlags clearAllFlags() {
            this.value = 0;
            return this;
        }

        public void clearSideEffectFlags() {
            this.value &= 0x10;
        }

        public SideEffectFlags setMutatesGlobalState() {
            this.value |= 7;
            return this;
        }

        public SideEffectFlags setThrows() {
            this.value |= 8;
            return this;
        }

        public SideEffectFlags setMutatesThis() {
            this.value |= 2;
            return this;
        }

        public SideEffectFlags setMutatesArguments() {
            this.value |= 4;
            return this;
        }

        public SideEffectFlags setReturnsTainted() {
            this.value |= 0x10;
            return this;
        }

        @DoNotCall
        public String toString() {
            StringBuilder builder = new StringBuilder("Side effects: ");
            if ((this.value & 2) != 0) {
                builder.append("this ");
            }
            if ((this.value & 1) != 0) {
                builder.append("global ");
            }
            if ((this.value & 8) != 0) {
                builder.append("throw ");
            }
            if ((this.value & 4) != 0) {
                builder.append("args ");
            }
            if ((this.value & 0x10) != 0) {
                builder.append("return ");
            }
            return builder.toString();
        }
    }

    public static final class AncestorIterable
    implements Iterable<Node> {
        @Nullable
        private Node cur;

        AncestorIterable(@Nullable Node cur) {
            this.cur = cur;
        }

        @Override
        public Iterator<Node> iterator() {
            return new Iterator<Node>(){

                @Override
                public boolean hasNext() {
                    return cur != null;
                }

                @Override
                public Node next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    Node n = cur;
                    cur = cur.getParent();
                    return n;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    private static final class SiblingNodeIterator
    implements Iterator<Node> {
        @Nullable
        private Node current;

        SiblingNodeIterator(Node start) {
            this.current = start;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public Node next() {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            Node n = this.current;
            this.current = this.current.getNext();
            return n;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class SiblingNodeIterable
    implements Iterable<Node> {
        private final Node start;

        SiblingNodeIterable(Node start) {
            this.start = start;
        }

        @Override
        public Iterator<Node> iterator() {
            return new SiblingNodeIterator(this.start);
        }
    }

    private static final class IntPropListItem
    extends PropListItem {
        final int intValue;

        IntPropListItem(byte propType, int intValue, @Nullable PropListItem next) {
            super(propType, next);
            this.intValue = intValue;
        }

        @Override
        public int getIntValue() {
            return this.intValue;
        }

        @Override
        public Object getObjectValue() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return String.valueOf(this.intValue);
        }

        @Override
        public PropListItem chain(@Nullable PropListItem next) {
            return new IntPropListItem(this.propType, this.intValue, next);
        }
    }

    private static final class ObjectPropListItem
    extends PropListItem {
        private final Object objectValue;

        ObjectPropListItem(byte propType, Object objectValue, @Nullable PropListItem next) {
            super(propType, next);
            this.objectValue = objectValue;
        }

        @Override
        public int getIntValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getObjectValue() {
            return this.objectValue;
        }

        public String toString() {
            return String.valueOf(this.objectValue);
        }

        @Override
        public PropListItem chain(@Nullable PropListItem next) {
            return new ObjectPropListItem(this.propType, this.objectValue, next);
        }
    }

    private static abstract class PropListItem
    implements Serializable {
        @Nullable
        final PropListItem next;
        final byte propType;

        PropListItem(byte propType, @Nullable PropListItem next) {
            this.propType = propType;
            this.next = next;
        }

        public abstract int getIntValue();

        public abstract Object getObjectValue();

        public abstract PropListItem chain(@Nullable PropListItem var1);
    }

    private static final class TemplateLiteralSubstringNode
    extends Node {
        private static final long serialVersionUID = 1L;
        @Nullable
        private String cooked;
        private String raw;

        private TemplateLiteralSubstringNode() {
            super(Token.TEMPLATELIT_STRING);
        }

        TemplateLiteralSubstringNode(@Nullable String cooked, String raw) {
            super(Token.TEMPLATELIT_STRING);
            this.cooked = cooked;
            this.setRaw(raw);
        }

        TemplateLiteralSubstringNode(@Nullable String cooked, String raw, int lineno, int charno) {
            super(Token.TEMPLATELIT_STRING, lineno, charno);
            this.cooked = cooked;
            this.setRaw(raw);
        }

        @Override
        public String getRawString() {
            return this.raw;
        }

        @Override
        @Nullable
        public String getCookedString() {
            return this.cooked;
        }

        public void setRaw(String str) {
            if (null == str) {
                throw new IllegalArgumentException("TemplateLiteralSubstringNode: raw str is null");
            }
            this.raw = str.intern();
        }

        @Override
        public boolean isEquivalentTo(Node node, boolean compareType, boolean recur, boolean jsDoc, boolean sideEffect) {
            return super.isEquivalentTo(node, compareType, recur, jsDoc, sideEffect) && this.raw == ((TemplateLiteralSubstringNode)node).raw && Objects.equal(this.cooked, ((TemplateLiteralSubstringNode)node).cooked);
        }

        @Override
        public TemplateLiteralSubstringNode cloneNode(boolean cloneTypeExprs) {
            TemplateLiteralSubstringNode clone = new TemplateLiteralSubstringNode();
            clone.raw = this.raw;
            clone.cooked = this.cooked;
            return this.copyNodeFields(clone, cloneTypeExprs);
        }
    }

    private static final class StringNode
    extends Node {
        private static final long serialVersionUID = 1L;
        private String str;

        private StringNode(Token token) {
            super(token);
        }

        StringNode(Token token, String str) {
            super(token);
            this.setString(str);
        }

        StringNode(Token token, String str, int lineno, int charno) {
            super(token, lineno, charno);
            this.setString(str);
        }

        @Override
        public String getString() {
            return this.str;
        }

        @Override
        public void setString(String str) {
            if (null == str) {
                throw new IllegalArgumentException("StringNode: str is null");
            }
            this.str = str.intern();
        }

        @Override
        public boolean isEquivalentTo(Node node, boolean compareType, boolean recur, boolean jsDoc, boolean sideEffect) {
            return super.isEquivalentTo(node, compareType, recur, jsDoc, sideEffect) && this.str == ((StringNode)node).str;
        }

        @Override
        public boolean isQuotedString() {
            return this.getBooleanProp(Prop.QUOTED);
        }

        @Override
        public void setQuotedString() {
            this.putBooleanProp(Prop.QUOTED, true);
        }

        @Override
        public StringNode cloneNode(boolean cloneTypeExprs) {
            StringNode clone = new StringNode(this.token);
            clone.str = this.str;
            return this.copyNodeFields(clone, cloneTypeExprs);
        }

        @Override
        @GwtIncompatible(value="ObjectInputStream")
        private void readObject(ObjectInputStream in) throws Exception {
            in.defaultReadObject();
            this.str = this.str.intern();
        }
    }

    private static final class NumberNode
    extends Node {
        private static final long serialVersionUID = 1L;
        private double number;

        NumberNode(double number) {
            super(Token.NUMBER);
            this.number = number;
        }

        public NumberNode(double number, int lineno, int charno) {
            super(Token.NUMBER, lineno, charno);
            this.number = number;
        }

        @Override
        public double getDouble() {
            return this.number;
        }

        @Override
        public void setDouble(double d) {
            this.number = d;
        }

        @Override
        public boolean isEquivalentTo(Node node, boolean compareType, boolean recur, boolean jsDoc, boolean sideEffect) {
            double thatValue;
            double thisValue;
            boolean equiv = super.isEquivalentTo(node, compareType, recur, jsDoc, sideEffect);
            if (equiv && (thisValue = this.getDouble()) == (thatValue = ((NumberNode)node).getDouble())) {
                return thisValue != 0.0 || 1.0 / thisValue == 1.0 / thatValue;
            }
            return false;
        }

        @Override
        public NumberNode cloneNode(boolean cloneTypeExprs) {
            return this.copyNodeFields(new NumberNode(this.number), cloneTypeExprs);
        }
    }

    public static final class TypeDeclarationNode
    extends Node {
        private static final long serialVersionUID = 1L;
        private String str;

        public TypeDeclarationNode(Token nodeType, String str) {
            super(nodeType);
            this.str = str;
        }

        public TypeDeclarationNode(Token nodeType) {
            super(nodeType);
        }

        public TypeDeclarationNode(Token nodeType, Node child) {
            super(nodeType, child);
        }

        @Override
        public String getString() {
            return this.str;
        }

        @Override
        public TypeDeclarationNode cloneNode(boolean cloneTypeExprs) {
            return this.copyNodeFields(new TypeDeclarationNode(this.token, this.str), cloneTypeExprs);
        }
    }

    private static enum Prop {
        NON_JSDOC_COMMENT,
        JSDOC_INFO,
        VAR_ARGS,
        INCRDECR,
        QUOTED,
        OPT_ARG,
        SYNTHETIC,
        ADDED_BLOCK,
        ORIGINALNAME,
        SIDE_EFFECT_FLAGS,
        IS_CONSTANT_NAME,
        IS_NAMESPACE,
        DIRECTIVES,
        DIRECT_EVAL,
        FREE_CALL,
        SOURCE_FILE,
        INPUT_ID,
        SLASH_V,
        INFERRED,
        CHANGE_TIME,
        REFLECTED_OBJECT,
        STATIC_MEMBER,
        GENERATOR_FN,
        ARROW_FN,
        ASYNC_FN,
        YIELD_ALL,
        EXPORT_DEFAULT,
        EXPORT_ALL_FROM,
        CONSTANT_VAR_FLAGS,
        IS_GENERATOR_MARKER,
        IS_GENERATOR_SAFE,
        COMPUTED_PROP_METHOD,
        COMPUTED_PROP_GETTER,
        COMPUTED_PROP_SETTER,
        COMPUTED_PROP_VARIABLE,
        DECLARED_TYPE_EXPR,
        TYPE_BEFORE_CAST,
        OPT_ES6_TYPED,
        GENERIC_TYPE,
        IMPLEMENTS,
        CONSTRUCT_SIGNATURE,
        ACCESS_MODIFIER,
        NON_INDEXABLE,
        PARSE_RESULTS,
        GOOG_MODULE,
        GOOG_MODULE_REQUIRE,
        FEATURE_SET,
        IS_MODULE_NAME,
        WAS_PREVIOUSLY_PROVIDED,
        IS_ES6_CLASS,
        TRANSPILED,
        DELETED,
        MODULE_ALIAS,
        IS_UNUSED_PARAMETER,
        MODULE_EXPORT,
        IS_SHORTHAND_PROPERTY,
        ES6_MODULE,
        TYPEDEF_TYPE,
        DEFINE_NAME;

    }
}

