/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.GwtIncompatible;
import com.google.debugging.sourcemap.proto.Mapping;
import com.google.gson.stream.JsonWriter;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.LightweightMessageFormatter;
import com.google.javascript.jscomp.SortingErrorManager;
import com.google.javascript.jscomp.SourceExcerptProvider;
import com.google.javascript.jscomp.parsing.parser.util.format.SimpleFormat;
import com.google.javascript.rhino.TokenUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;

public class JsonErrorReportGenerator
implements SortingErrorManager.ErrorReportGenerator {
    private final PrintStream stream;
    private final SourceExcerptProvider sourceExcerptProvider;
    private static final LightweightMessageFormatter.LineNumberingFormatter excerptFormatter = new LightweightMessageFormatter.LineNumberingFormatter();

    public JsonErrorReportGenerator(PrintStream stream, SourceExcerptProvider sourceExcerptProvider) {
        this.stream = stream;
        this.sourceExcerptProvider = sourceExcerptProvider;
    }

    @Override
    @GwtIncompatible
    public void generateReport(SortingErrorManager manager) {
        ByteArrayOutputStream bufferedStream = new ByteArrayOutputStream();
        try (JsonWriter jsonWriter = new JsonWriter(new OutputStreamWriter((OutputStream)bufferedStream, "UTF-8"));){
            jsonWriter.beginArray();
            for (SortingErrorManager.ErrorWithLevel message : manager.getSortedDiagnostics()) {
                Mapping.OriginalMapping mapping;
                String sourceName = message.error.getSourceName();
                int lineNumber = message.error.getLineNumber();
                int charno = message.error.getCharno();
                jsonWriter.beginObject();
                jsonWriter.name("level").value(message.level == CheckLevel.ERROR ? "error" : "warning");
                jsonWriter.name("description").value(message.error.getDescription());
                jsonWriter.name("key").value(message.error.getType().key);
                jsonWriter.name("source").value(sourceName);
                jsonWriter.name("line").value(lineNumber);
                jsonWriter.name("column").value(charno);
                String sourceExcerpt = SourceExcerptProvider.SourceExcerpt.LINE.get(this.sourceExcerptProvider, sourceName, lineNumber, excerptFormatter);
                if (sourceExcerpt != null) {
                    StringBuilder b = new StringBuilder(sourceExcerpt);
                    b.append("\n");
                    if (0 <= charno && charno <= sourceExcerpt.length()) {
                        for (int i = 0; i < charno; ++i) {
                            char c = sourceExcerpt.charAt(i);
                            if (TokenUtil.isWhitespace(c)) {
                                b.append(c);
                                continue;
                            }
                            b.append(' ');
                        }
                        if (message.error.getNode() == null) {
                            b.append("^");
                        } else {
                            int length = Math.max(1, Math.min(message.error.getNode().getLength(), sourceExcerpt.length() - charno));
                            for (int i = 0; i < length; ++i) {
                                b.append("^");
                            }
                        }
                    }
                    jsonWriter.name("context").value(b.toString());
                }
                if ((mapping = this.sourceExcerptProvider.getSourceMapping(sourceName, message.error.getLineNumber(), message.error.getCharno())) != null) {
                    jsonWriter.name("originalLocation").beginObject();
                    jsonWriter.name("source").value(mapping.getOriginalFile());
                    jsonWriter.name("line").value(mapping.getLineNumber());
                    jsonWriter.name("column").value(mapping.getColumnPosition());
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            StringBuilder summaryBuilder = new StringBuilder();
            if (manager.getTypedPercent() > 0.0) {
                summaryBuilder.append(SimpleFormat.format("%d error(s), %d warning(s), %.1f%% typed", manager.getErrorCount(), manager.getWarningCount(), manager.getTypedPercent()));
            } else {
                summaryBuilder.append(SimpleFormat.format("%d error(s), %d warning(s)", manager.getErrorCount(), manager.getWarningCount()));
            }
            jsonWriter.beginObject();
            jsonWriter.name("level").value("info");
            jsonWriter.name("description").value(summaryBuilder.toString());
            jsonWriter.endObject();
            jsonWriter.endArray();
            jsonWriter.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.stream.append(bufferedStream.toString());
    }
}

