/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstFactory;
import com.google.javascript.jscomp.Es6TemplateLiterals;
import com.google.javascript.jscomp.Es6ToEs3Util;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import java.util.ArrayList;
import java.util.List;

public final class LateEs6ToEs3Converter
implements NodeTraversal.Callback,
HotSwapCompilerPass {
    private final AbstractCompiler compiler;
    private final AstFactory astFactory;
    private final Es6TemplateLiterals templateLiteralConverter;
    private static final FeatureSet transpiledFeatures = FeatureSet.BARE_MINIMUM.with(FeatureSet.Feature.COMPUTED_PROPERTIES, FeatureSet.Feature.MEMBER_DECLARATIONS, FeatureSet.Feature.TEMPLATE_LITERALS);
    private final boolean addTypes;
    private final JSTypeRegistry registry;
    private final JSType stringType;
    private static final String FRESH_COMP_PROP_VAR = "$jscomp$compprop";

    public LateEs6ToEs3Converter(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.astFactory = compiler.createAstFactory();
        this.templateLiteralConverter = new Es6TemplateLiterals(compiler);
        this.addTypes = compiler.hasTypeCheckingRun();
        this.registry = compiler.getTypeRegistry();
        this.stringType = Es6ToEs3Util.createType(this.addTypes, this.registry, JSTypeNative.STRING_TYPE);
    }

    @Override
    public void process(Node externs, Node root) {
        TranspilationPasses.processTranspile(this.compiler, externs, transpiledFeatures, this);
        TranspilationPasses.processTranspile(this.compiler, root, transpiledFeatures, this);
        TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(this.compiler, transpiledFeatures);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        TranspilationPasses.hotSwapTranspile(this.compiler, scriptRoot, transpiledFeatures, this);
        TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(this.compiler, transpiledFeatures);
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case GETTER_DEF: 
            case SETTER_DEF: {
                if (!FeatureSet.ES3.contains(this.compiler.getOptions().getOutputFeatureSet())) break;
                Es6ToEs3Util.cannotConvert(this.compiler, n, "ES5 getters/setters (consider using --language_out=ES5)");
                return false;
            }
            case FUNCTION: {
                if (!n.isAsyncFunction()) break;
                throw new IllegalStateException("async functions should have already been converted");
            }
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case OBJECTLIT: {
                this.visitObject(n);
                break;
            }
            case MEMBER_FUNCTION_DEF: {
                if (!parent.isObjectLit()) break;
                this.visitMemberFunctionDefInObjectLit(n, parent);
                break;
            }
            case TAGGED_TEMPLATELIT: {
                this.templateLiteralConverter.visitTaggedTemplateLiteral(t, n, this.addTypes);
                break;
            }
            case TEMPLATELIT: {
                if (parent.isTaggedTemplateLit()) break;
                this.templateLiteralConverter.visitTemplateLiteral(t, n);
                break;
            }
        }
    }

    private void visitMemberFunctionDefInObjectLit(Node n, Node parent) {
        String name = n.getString();
        Node nameNode = n.getFirstFirstChild();
        Node stringKey = this.astFactory.createStringKey(name, n.getFirstChild().detach());
        stringKey.setJSDocInfo(n.getJSDocInfo());
        parent.replaceChild(n, stringKey);
        stringKey.useSourceInfoFrom(nameNode);
        this.compiler.reportChangeToEnclosingScope(stringKey);
    }

    private void visitObject(Node obj) {
        for (Node child : obj.children()) {
            if (!child.isComputedProp()) continue;
            this.visitObjectWithComputedProperty(obj);
            return;
        }
    }

    private void visitObjectWithComputedProperty(Node obj) {
        Preconditions.checkArgument(obj.isObjectLit());
        List<Node> props = new ArrayList();
        Node currElement = obj.getFirstChild();
        JSType objectType = obj.getJSType();
        while (currElement != null) {
            if (currElement.getBooleanProp(Node.COMPUTED_PROP_GETTER) || currElement.getBooleanProp(Node.COMPUTED_PROP_SETTER)) {
                Es6ToEs3Util.cannotConvertYet(this.compiler, currElement, "computed getter/setter in an object literal");
                return;
            }
            if (currElement.isGetterDef() || currElement.isSetterDef()) {
                currElement = currElement.getNext();
                continue;
            }
            Node nextNode = currElement.getNext();
            obj.removeChild(currElement);
            props.add(currElement);
            currElement = nextNode;
        }
        String objName = FRESH_COMP_PROP_VAR + this.compiler.getUniqueNameIdSupplier().get();
        props = Lists.reverse(props);
        Node result = this.astFactory.createName(objName, objectType);
        for (Node propdef : props) {
            if (propdef.isComputedProp()) {
                Node propertyExpression = propdef.removeFirstChild();
                Node value = propdef.removeFirstChild();
                result = this.astFactory.createComma(this.astFactory.createAssign(this.astFactory.createGetElem(this.astFactory.createName(objName, objectType), propertyExpression), value), result);
                continue;
            }
            Node val = propdef.removeFirstChild();
            boolean isQuotedAccess = propdef.isQuotedString();
            propdef.setToken(Token.STRING);
            propdef.setJSType(this.stringType);
            propdef.putBooleanProp(Node.QUOTED_PROP, false);
            Node objNameNode = this.astFactory.createName(objName, objectType);
            Node access = isQuotedAccess ? this.astFactory.createGetElem(objNameNode, propdef) : this.astFactory.createGetProp(objNameNode, propdef.getString());
            result = this.astFactory.createComma(this.astFactory.createAssign(access, val), result);
        }
        Node statement = obj;
        while (!NodeUtil.isStatement(statement)) {
            statement = statement.getParent();
        }
        result.useSourceInfoIfMissingFromForTree(obj);
        obj.replaceWith(result);
        JSType simpleObjectType = null;
        Node var = IR.var(this.astFactory.createName(objName, objectType), Es6ToEs3Util.withType(obj, simpleObjectType));
        var.useSourceInfoIfMissingFromForTree(statement);
        statement.getParent().addChildBefore(var, statement);
        this.compiler.reportChangeToEnclosingScope(var);
    }
}

