/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.Es6ConvertSuper;
import com.google.javascript.jscomp.Es6ConvertSuperConstructorCalls;
import com.google.javascript.jscomp.Es6ExtractClasses;
import com.google.javascript.jscomp.Es6ForOfConverter;
import com.google.javascript.jscomp.Es6InjectRuntimeLibraries;
import com.google.javascript.jscomp.Es6NormalizeShorthandProperties;
import com.google.javascript.jscomp.Es6RelativizeImportPaths;
import com.google.javascript.jscomp.Es6RenameVariablesInParamLists;
import com.google.javascript.jscomp.Es6RewriteArrowFunction;
import com.google.javascript.jscomp.Es6RewriteBlockScopedDeclaration;
import com.google.javascript.jscomp.Es6RewriteBlockScopedFunctionDeclaration;
import com.google.javascript.jscomp.Es6RewriteClass;
import com.google.javascript.jscomp.Es6RewriteClassExtendsExpressions;
import com.google.javascript.jscomp.Es6RewriteDestructuring;
import com.google.javascript.jscomp.Es6RewriteGenerators;
import com.google.javascript.jscomp.Es6RewriteModules;
import com.google.javascript.jscomp.Es6RewriteModulesToCommonJsModules;
import com.google.javascript.jscomp.Es6RewriteRestAndSpread;
import com.google.javascript.jscomp.Es6SplitVariableDeclarations;
import com.google.javascript.jscomp.Es7RewriteExponentialOperator;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.LateEs6ToEs3Converter;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.PassFactory;
import com.google.javascript.jscomp.PreprocessorSymbolTable;
import com.google.javascript.jscomp.RewriteAsyncFunctions;
import com.google.javascript.jscomp.RewriteAsyncIteration;
import com.google.javascript.jscomp.RewriteCatchWithNoBinding;
import com.google.javascript.jscomp.RewriteObjectSpread;
import com.google.javascript.jscomp.RewritePolyfills;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.Node;
import java.util.List;

public class TranspilationPasses {
    private static final PassFactory es6RewriteModuleToCjs = PassFactory.builder().setName("es6RewriteModuleToCjs").setInternalFactory(Es6RewriteModulesToCommonJsModules::new).setFeatureSet(FeatureSet.latest()).build();
    private static final PassFactory es6RelativizeImportPaths = PassFactory.builder().setName("es6RelativizeImportPaths").setInternalFactory(Es6RelativizeImportPaths::new).setFeatureSet(FeatureSet.latest()).build();
    private static final PassFactory rewriteAsyncFunctions = PassFactory.builderForHotSwap().setName("rewriteAsyncFunctions").setInternalFactory(compiler -> new RewriteAsyncFunctions.Builder((AbstractCompiler)compiler).rewriteSuperPropertyReferencesWithoutSuper(!compiler.getOptions().needsTranspilationFrom(FeatureSet.ES6)).build()).setFeatureSet(FeatureSet.ES_NEXT).build();
    private static final PassFactory rewriteAsyncIteration = PassFactory.builderForHotSwap().setName("rewriteAsyncIteration").setInternalFactory(compiler -> new RewriteAsyncIteration.Builder((AbstractCompiler)compiler).rewriteSuperPropertyReferencesWithoutSuper(!compiler.getOptions().needsTranspilationFrom(FeatureSet.ES6)).build()).setFeatureSet(FeatureSet.ES_NEXT).build();
    private static final PassFactory rewriteObjectSpread = PassFactory.builderForHotSwap().setName("rewriteObjectSpread").setInternalFactory(RewriteObjectSpread::new).setFeatureSet(FeatureSet.ES_NEXT).build();
    private static final PassFactory rewriteCatchWithNoBinding = PassFactory.builderForHotSwap().setName("rewriteCatchWithNoBinding").setInternalFactory(RewriteCatchWithNoBinding::new).setFeatureSet(FeatureSet.ES_NEXT).build();
    private static final PassFactory rewriteExponentialOperator = PassFactory.builderForHotSwap().setName("rewriteExponentialOperator").setInternalFactory(Es7RewriteExponentialOperator::new).setFeatureSet(FeatureSet.ES2018).build();
    private static final PassFactory es6NormalizeShorthandProperties = PassFactory.builderForHotSwap().setName("es6NormalizeShorthandProperties").setInternalFactory(Es6NormalizeShorthandProperties::new).setFeatureSet(FeatureSet.ES2018).build();
    static final PassFactory es6RewriteClassExtends = PassFactory.builderForHotSwap().setName("Es6ExtractClassExtends").setInternalFactory(Es6RewriteClassExtendsExpressions::new).setFeatureSet(FeatureSet.ES2018).build();
    static final PassFactory es6ExtractClasses = PassFactory.builderForHotSwap().setName("Es6ExtractClasses").setInternalFactory(Es6ExtractClasses::new).setFeatureSet(FeatureSet.ES8).build();
    static final PassFactory es6RewriteClass = PassFactory.builderForHotSwap().setName("Es6RewriteClass").setInternalFactory(Es6RewriteClass::new).setFeatureSet(FeatureSet.ES8).build();
    static final PassFactory es6RenameVariablesInParamLists = PassFactory.builderForHotSwap().setName("Es6RenameVariablesInParamLists").setInternalFactory(Es6RenameVariablesInParamLists::new).setFeatureSet(FeatureSet.ES2018).build();
    static final PassFactory es6RewriteArrowFunction = PassFactory.builderForHotSwap().setName("Es6RewriteArrowFunction").setInternalFactory(Es6RewriteArrowFunction::new).setFeatureSet(FeatureSet.ES8).build();
    static final PassFactory rewritePolyfills = PassFactory.builderForHotSwap().setName("RewritePolyfills").setInternalFactory(RewritePolyfills::new).setFeatureSet(FeatureSet.latest()).build();
    static final PassFactory es6SplitVariableDeclarations = PassFactory.builderForHotSwap().setName("Es6SplitVariableDeclarations").setInternalFactory(Es6SplitVariableDeclarations::new).setFeatureSet(FeatureSet.latest()).build();
    static final PassFactory es6ConvertSuperConstructorCalls = PassFactory.builderForHotSwap().setName("es6ConvertSuperConstructorCalls").setInternalFactory(Es6ConvertSuperConstructorCalls::new).setFeatureSet(FeatureSet.ES8).build();
    static final PassFactory es6ConvertSuper = PassFactory.builderForHotSwap().setName("es6ConvertSuper").setInternalFactory(Es6ConvertSuper::new).setFeatureSet(FeatureSet.ES2018).build();
    static final PassFactory es6InjectRuntimeLibraries = PassFactory.builderForHotSwap().setName("es6InjectRuntimeLibraries").setInternalFactory(Es6InjectRuntimeLibraries::new).setFeatureSet(FeatureSet.ES_NEXT).build();
    static final PassFactory es6RewriteRestAndSpread = PassFactory.builderForHotSwap().setName("es6RewriteRestAndSpread").setInternalFactory(Es6RewriteRestAndSpread::new).setFeatureSet(FeatureSet.latest()).build();
    static final PassFactory lateConvertEs6ToEs3 = PassFactory.builderForHotSwap().setName("lateConvertEs6").setInternalFactory(LateEs6ToEs3Converter::new).setFeatureSet(FeatureSet.latest()).build();
    static final PassFactory es6ForOf = PassFactory.builderForHotSwap().setName("es6ForOf").setInternalFactory(Es6ForOfConverter::new).setFeatureSet(FeatureSet.ES8).build();
    static final PassFactory rewriteBlockScopedFunctionDeclaration = PassFactory.builderForHotSwap().setName("Es6RewriteBlockScopedFunctionDeclaration").setInternalFactory(Es6RewriteBlockScopedFunctionDeclaration::new).setFeatureSet(FeatureSet.ES8).build();
    static final PassFactory rewriteBlockScopedDeclaration = PassFactory.builderForHotSwap().setName("Es6RewriteBlockScopedDeclaration").setInternalFactory(Es6RewriteBlockScopedDeclaration::new).setFeatureSet(FeatureSet.ES8).build();
    static final PassFactory rewriteGenerators = PassFactory.builderForHotSwap().setName("rewriteGenerators").setInternalFactory(Es6RewriteGenerators::new).setFeatureSet(FeatureSet.ES8).build();

    private TranspilationPasses() {
    }

    public static void addEs6ModulePass(List<PassFactory> passes, PreprocessorSymbolTable.CachedInstanceFactory preprocessorTableFactory) {
        passes.add(PassFactory.builderForHotSwap().setName("es6RewriteModule").setInternalFactory(compiler -> {
            preprocessorTableFactory.maybeInitialize((AbstractCompiler)compiler);
            return new Es6RewriteModules((AbstractCompiler)compiler, compiler.getModuleMetadataMap(), compiler.getModuleMap(), preprocessorTableFactory.getInstanceOrNull());
        }).setFeatureSet(FeatureSet.ES_NEXT).build());
    }

    public static void addPreTypecheckTranspilationPasses(List<PassFactory> passes, CompilerOptions options) {
        passes.add(es6InjectRuntimeLibraries);
    }

    public static void addEs6ModuleToCjsPass(List<PassFactory> passes) {
        passes.add(es6RewriteModuleToCjs);
    }

    public static void addEs6RewriteImportPathPass(List<PassFactory> passes) {
        passes.add(es6RelativizeImportPaths);
    }

    public static void addPostCheckTranspilationPasses(List<PassFactory> passes, CompilerOptions options) {
        if (options.needsTranspilationFrom(FeatureSet.ES_NEXT)) {
            passes.add(rewriteCatchWithNoBinding);
        }
        if (options.needsTranspilationFrom(FeatureSet.ES2018)) {
            passes.add(rewriteAsyncIteration);
            passes.add(rewriteObjectSpread);
        }
        if (options.needsTranspilationFrom(FeatureSet.ES8)) {
            passes.add(TranspilationPasses.createFeatureRemovalPass("markTrailingCommasInParameterListsRemoved", FeatureSet.Feature.TRAILING_COMMA_IN_PARAM_LIST, new FeatureSet.Feature[0]));
            passes.add(rewriteAsyncFunctions);
        }
        if (options.needsTranspilationFrom(FeatureSet.ES7)) {
            passes.add(rewriteExponentialOperator);
        }
        if (options.needsTranspilationFrom(FeatureSet.ES6)) {
            passes.add(TranspilationPasses.createFeatureRemovalPass("markEs6FeaturesNotRequiringTranspilationAsRemoved", FeatureSet.Feature.BINARY_LITERALS, FeatureSet.Feature.OCTAL_LITERALS, FeatureSet.Feature.REGEXP_FLAG_U, FeatureSet.Feature.REGEXP_FLAG_Y));
            passes.add(es6NormalizeShorthandProperties);
            passes.add(es6RewriteClassExtends);
            passes.add(es6ConvertSuper);
            passes.add(es6RenameVariablesInParamLists);
            passes.add(es6SplitVariableDeclarations);
            passes.add(TranspilationPasses.getEs6RewriteDestructuring(Es6RewriteDestructuring.ObjectDestructuringRewriteMode.REWRITE_ALL_OBJECT_PATTERNS));
            passes.add(es6RewriteArrowFunction);
            passes.add(es6ExtractClasses);
            passes.add(es6RewriteClass);
            passes.add(es6RewriteRestAndSpread);
            passes.add(lateConvertEs6ToEs3);
            passes.add(es6ForOf);
            passes.add(rewriteBlockScopedFunctionDeclaration);
            passes.add(rewriteBlockScopedDeclaration);
            passes.add(rewriteGenerators);
            passes.add(es6ConvertSuperConstructorCalls);
        } else if (options.needsTranspilationOf(FeatureSet.Feature.OBJECT_PATTERN_REST)) {
            passes.add(es6RenameVariablesInParamLists);
            passes.add(es6SplitVariableDeclarations);
            passes.add(TranspilationPasses.getEs6RewriteDestructuring(Es6RewriteDestructuring.ObjectDestructuringRewriteMode.REWRITE_OBJECT_REST));
        }
    }

    public static void addRewritePolyfillPass(List<PassFactory> passes) {
        passes.add(rewritePolyfills);
    }

    static final PassFactory getEs6RewriteDestructuring(Es6RewriteDestructuring.ObjectDestructuringRewriteMode rewriteMode) {
        return PassFactory.builderForHotSwap().setName("Es6RewriteDestructuring").setInternalFactory(compiler -> new Es6RewriteDestructuring.Builder((AbstractCompiler)compiler).setDestructuringRewriteMode(rewriteMode).build()).setFeatureSet(FeatureSet.ES2018).build();
    }

    static boolean isScriptEs6OrHigher(Node script) {
        FeatureSet features = NodeUtil.getFeatureSetOfScript(script);
        return features != null && !FeatureSet.ES5.contains(features);
    }

    static boolean doesScriptHaveUnsupportedFeatures(Node script, FeatureSet supportedFeatures) {
        FeatureSet features = NodeUtil.getFeatureSetOfScript(script);
        return features != null && !supportedFeatures.contains(features);
    }

    static void processTranspile(AbstractCompiler compiler, Node combinedRoot, FeatureSet featureSet, NodeTraversal.Callback ... callbacks) {
        if (compiler.getOptions().needsTranspilationFrom(featureSet)) {
            FeatureSet languageOutFeatures = compiler.getOptions().getOutputFeatureSet();
            for (Node singleRoot : combinedRoot.children()) {
                if (!TranspilationPasses.doesScriptHaveUnsupportedFeatures(singleRoot, languageOutFeatures)) continue;
                for (NodeTraversal.Callback callback : callbacks) {
                    singleRoot.putBooleanProp(Node.TRANSPILED, true);
                    NodeTraversal.traverse(compiler, singleRoot, callback);
                }
            }
        }
    }

    static void hotSwapTranspile(AbstractCompiler compiler, Node scriptRoot, FeatureSet featureSet, NodeTraversal.Callback ... callbacks) {
        FeatureSet languageOutFeatures;
        if (compiler.getOptions().needsTranspilationFrom(featureSet) && TranspilationPasses.doesScriptHaveUnsupportedFeatures(scriptRoot, languageOutFeatures = compiler.getOptions().getOutputFeatureSet())) {
            for (NodeTraversal.Callback callback : callbacks) {
                scriptRoot.putBooleanProp(Node.TRANSPILED, true);
                NodeTraversal.traverse(compiler, scriptRoot, callback);
            }
        }
    }

    static void maybeMarkFeaturesAsTranspiledAway(AbstractCompiler compiler, FeatureSet transpiledFeatures) {
        if (!compiler.hasHaltingErrors()) {
            compiler.setFeatureSet(compiler.getFeatureSet().without(transpiledFeatures));
        }
    }

    static void maybeMarkFeaturesAsTranspiledAway(AbstractCompiler compiler, FeatureSet.Feature transpiledFeature, FeatureSet.Feature ... moreTranspiledFeatures) {
        if (!compiler.hasHaltingErrors()) {
            compiler.setFeatureSet(compiler.getFeatureSet().without(transpiledFeature, moreTranspiledFeatures));
        }
    }

    private static PassFactory createFeatureRemovalPass(String passName, FeatureSet.Feature featureToRemove, FeatureSet.Feature ... moreFeaturesToRemove) {
        return PassFactory.builderForHotSwap().setName(passName).setInternalFactory(compiler -> new HotSwapCompilerPass((AbstractCompiler)compiler, featureToRemove, moreFeaturesToRemove){
            final /* synthetic */ AbstractCompiler val$compiler;
            final /* synthetic */ FeatureSet.Feature val$featureToRemove;
            final /* synthetic */ FeatureSet.Feature[] val$moreFeaturesToRemove;
            {
                this.val$compiler = abstractCompiler;
                this.val$featureToRemove = feature;
                this.val$moreFeaturesToRemove = featureArray;
            }

            @Override
            public void hotSwapScript(Node scriptRoot, Node originalRoot) {
                TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(this.val$compiler, this.val$featureToRemove, this.val$moreFeaturesToRemove);
            }

            @Override
            public void process(Node externs, Node root) {
                TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(this.val$compiler, this.val$featureToRemove, this.val$moreFeaturesToRemove);
            }
        }).setFeatureSet(FeatureSet.latest()).build();
    }
}

