/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.javascript.rhino.ClosurePrimitive;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.jstype.ArrowType;
import com.google.javascript.rhino.jstype.EquivalenceMethod;
import com.google.javascript.rhino.jstype.FunctionParamBuilder;
import com.google.javascript.rhino.jstype.InstanceObjectType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.Property;
import com.google.javascript.rhino.jstype.PrototypeObjectType;
import com.google.javascript.rhino.jstype.RelationshipVisitor;
import com.google.javascript.rhino.jstype.TemplateType;
import com.google.javascript.rhino.jstype.TemplateTypeMap;
import com.google.javascript.rhino.jstype.UnknownType;
import com.google.javascript.rhino.jstype.Visitor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FunctionType
extends PrototypeObjectType
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ConstructorAmbiguity constructorAmbiguity = ConstructorAmbiguity.UNKNOWN;
    private ArrowType call;
    private Property prototypeSlot;
    private final Kind kind;
    private PropAccess propAccess;
    private JSType typeOfThis;
    private Node source;
    private boolean isStructuralInterface;
    private final boolean isAbstract;
    private ImmutableList<ObjectType> implementedInterfaces = ImmutableList.of();
    private ImmutableList<ObjectType> extendedInterfaces = ImmutableList.of();
    private List<FunctionType> subTypes = null;
    private boolean wasAddedToExtendedConstructorSubtypes = false;
    private final ClosurePrimitive closurePrimitive;
    private final FunctionType canonicalRepresentation;
    private static final String DELEGATE_SUFFIX = ObjectType.createDelegateSuffix("Proxy");

    FunctionType(Builder builder) {
        super(builder);
        this.setPrettyPrint(true);
        Node source = builder.sourceNode;
        Preconditions.checkArgument(source == null || source.isFunction() || source.isClass());
        this.source = source;
        this.kind = builder.kind;
        switch (this.kind) {
            case CONSTRUCTOR: {
                this.propAccess = PropAccess.ANY;
                this.typeOfThis = builder.typeOfThis != null ? builder.typeOfThis : InstanceObjectType.builderForCtor(this).build();
                break;
            }
            case ORDINARY: {
                this.typeOfThis = builder.typeOfThis != null ? builder.typeOfThis : this.registry.getNativeObjectType(JSTypeNative.UNKNOWN_TYPE);
                break;
            }
            case INTERFACE: {
                this.typeOfThis = builder.typeOfThis != null ? builder.typeOfThis : InstanceObjectType.builderForCtor(this).build();
            }
        }
        this.call = builder.buildArrowType();
        this.closurePrimitive = builder.primitiveId;
        this.isStructuralInterface = false;
        this.isAbstract = builder.isAbstract();
        FunctionType canonicalRepresentation = builder.canonicalRepresentation;
        Preconditions.checkArgument(canonicalRepresentation == null || this.kind == Kind.CONSTRUCTOR, "Only constructors should have canonical representations");
        this.canonicalRepresentation = canonicalRepresentation;
    }

    @Override
    public final boolean isInstanceType() {
        return this == this.registry.getNativeType(JSTypeNative.U2U_CONSTRUCTOR_TYPE);
    }

    @Override
    public boolean isConstructor() {
        return this.kind == Kind.CONSTRUCTOR;
    }

    @Override
    public final boolean isInterface() {
        return this.kind == Kind.INTERFACE;
    }

    @Override
    public final boolean isOrdinaryFunction() {
        return this.kind == Kind.ORDINARY;
    }

    final Kind getKind() {
        return this.kind;
    }

    public final boolean makesStructs() {
        if (!this.hasInstanceType()) {
            return false;
        }
        if (this.propAccess == PropAccess.STRUCT) {
            return true;
        }
        if (this.propAccess == PropAccess.ANY_EXPLICIT) {
            return false;
        }
        FunctionType superc = this.getSuperClassConstructor();
        if (superc != null && superc.makesStructs()) {
            this.setStruct();
            return true;
        }
        return false;
    }

    public final boolean makesDicts() {
        if (!this.isConstructor()) {
            return false;
        }
        if (this.propAccess == PropAccess.DICT) {
            return true;
        }
        if (this.propAccess == PropAccess.ANY_EXPLICIT) {
            return false;
        }
        FunctionType superc = this.getSuperClassConstructor();
        if (superc != null && superc.makesDicts()) {
            this.setDict();
            return true;
        }
        return false;
    }

    public final void setStruct() {
        this.propAccess = PropAccess.STRUCT;
    }

    public final void setDict() {
        this.propAccess = PropAccess.DICT;
    }

    public final void setExplicitUnrestricted() {
        this.propAccess = PropAccess.ANY_EXPLICIT;
    }

    @Override
    public FunctionType toMaybeFunctionType() {
        return this;
    }

    @Override
    public final boolean canBeCalled() {
        return true;
    }

    public final boolean hasImplementedInterfaces() {
        FunctionType superCtor;
        if (!this.implementedInterfaces.isEmpty()) {
            return true;
        }
        FunctionType functionType = superCtor = this.isConstructor() ? this.getSuperClassConstructor() : null;
        if (superCtor != null) {
            return superCtor.hasImplementedInterfaces();
        }
        return false;
    }

    public final Iterable<Node> getParameters() {
        Node n = this.getParametersNode();
        if (n != null) {
            return n.children();
        }
        return Collections.emptySet();
    }

    public final Iterable<JSType> getParameterTypes() {
        ArrayList<JSType> types = new ArrayList<JSType>();
        for (Node n : this.getParameters()) {
            types.add(n.getJSType());
        }
        return types;
    }

    public final Node getParametersNode() {
        return this.call.parameters;
    }

    public final int getMinArity() {
        int i = 0;
        int min = 0;
        for (Node n : this.getParameters()) {
            ++i;
            if (n.isOptionalArg() || n.isVarArgs()) continue;
            min = i;
        }
        return min;
    }

    public final int getMaxArity() {
        Node lastParam;
        Node params = this.getParametersNode();
        if (!(params == null || (lastParam = params.getLastChild()) != null && lastParam.isVarArgs())) {
            return params.getChildCount();
        }
        return Integer.MAX_VALUE;
    }

    public final JSType getReturnType() {
        return this.call.returnType;
    }

    public final boolean isReturnTypeInferred() {
        return this.call.returnTypeInferred;
    }

    final ArrowType getInternalArrowType() {
        return this.call;
    }

    @Override
    public final Property getSlot(String name) {
        if ("prototype".equals(name)) {
            this.getPrototype();
            return this.prototypeSlot;
        }
        return super.getSlot(name);
    }

    @Override
    public final Set<String> getOwnPropertyNames() {
        if (this.prototypeSlot == null) {
            return super.getOwnPropertyNames();
        }
        ImmutableSet.Builder names = ImmutableSet.builder();
        names.add("prototype");
        names.addAll(super.getOwnPropertyNames());
        return names.build();
    }

    public final ObjectType getPrototypeProperty() {
        return this.getPrototype();
    }

    public final ObjectType getPrototype() {
        if (this.prototypeSlot == null) {
            String refName = this.getReferenceName();
            if (refName == null) {
                this.setPrototypeNoCheck(this.registry.getNativeObjectType(JSTypeNative.UNKNOWN_TYPE), null);
            } else {
                this.setPrototype(((PrototypeObjectType.Builder)((PrototypeObjectType.Builder)((PrototypeObjectType.Builder)PrototypeObjectType.builder(this.registry).setName(this.getReferenceName() + ".prototype")).setImplicitPrototype(this.registry.getNativeObjectType(JSTypeNative.OBJECT_TYPE))).setNative(this.isNativeObjectType())).build(), null);
            }
        }
        return (ObjectType)this.prototypeSlot.getType();
    }

    public final void setPrototypeBasedOn(ObjectType baseType) {
        this.setPrototypeBasedOn(baseType, null);
    }

    final void setPrototypeBasedOn(ObjectType baseType, Node propertyNode) {
        FunctionType superCtor;
        if (this.source != null && this.source.isClass() && (superCtor = baseType.getConstructor()) != null) {
            this.setImplicitPrototype(superCtor);
        }
        if (baseType.hasReferenceName() || this.isNativeObjectType() || baseType.isFunctionPrototypeType()) {
            if (this.prototypeSlot != null && this.hasInstanceType() && baseType.equals(this.getInstanceType())) {
                return;
            }
            baseType = ((PrototypeObjectType.Builder)((PrototypeObjectType.Builder)PrototypeObjectType.builder(this.registry).setName(this.getReferenceName() + ".prototype")).setImplicitPrototype(baseType)).build();
        }
        this.setPrototype(baseType, propertyNode);
    }

    final boolean setPrototype(ObjectType prototype, Node propertyNode) {
        if (prototype == null) {
            return false;
        }
        if (this.isConstructor() && prototype == this.getInstanceType()) {
            return false;
        }
        return this.setPrototypeNoCheck(prototype, propertyNode);
    }

    private boolean setPrototypeNoCheck(ObjectType prototype, Node propertyNode) {
        ObjectType oldPrototype = this.prototypeSlot == null ? null : (ObjectType)this.prototypeSlot.getType();
        boolean replacedPrototype = oldPrototype != null;
        this.prototypeSlot = new Property("prototype", prototype, true, propertyNode == null ? this.source : propertyNode);
        prototype.setOwnerFunction(this);
        if (oldPrototype != null) {
            oldPrototype.setOwnerFunction(null);
        }
        if (this.isConstructor() || this.isInterface()) {
            FunctionType superClass = this.getSuperClassConstructor();
            if (superClass != null) {
                superClass.addSubType(this);
                this.wasAddedToExtendedConstructorSubtypes = true;
            }
            if (this.isInterface()) {
                for (ObjectType interfaceType : this.getExtendedInterfaces()) {
                    if (interfaceType.getConstructor() == null) continue;
                    interfaceType.getConstructor().addSubType(this);
                }
            }
        }
        if (replacedPrototype) {
            this.clearCachedValues();
        }
        return true;
    }

    public final Iterable<ObjectType> getAllImplementedInterfaces() {
        LinkedHashSet<ObjectType> interfaces = new LinkedHashSet<ObjectType>();
        for (ObjectType type : this.getImplementedInterfaces()) {
            this.addRelatedInterfaces(type, interfaces);
        }
        return interfaces;
    }

    private void addRelatedInterfaces(ObjectType instance, Set<ObjectType> set) {
        FunctionType constructor = instance.getConstructor();
        if (constructor != null) {
            if (!constructor.isInterface()) {
                return;
            }
            if (!set.add(instance)) {
                return;
            }
            for (ObjectType interfaceType : instance.getCtorExtendedInterfaces()) {
                this.addRelatedInterfaces(interfaceType, set);
            }
        }
    }

    public final Collection<ObjectType> getAncestorInterfaces() {
        HashSet<ObjectType> result = new HashSet<ObjectType>();
        if (this.isConstructor()) {
            result.addAll(this.getImplementedInterfaces());
        } else {
            result.addAll(this.getExtendedInterfaces());
        }
        return result;
    }

    public final ImmutableList<ObjectType> getImplementedInterfaces() {
        FunctionType superCtor;
        FunctionType functionType = superCtor = this.isConstructor() ? this.getSuperClassConstructor() : null;
        if (superCtor == null) {
            return this.implementedInterfaces;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(this.implementedInterfaces);
        while (superCtor != null) {
            builder.addAll(superCtor.implementedInterfaces);
            superCtor = superCtor.getSuperClassConstructor();
        }
        return builder.build();
    }

    public final ImmutableList<ObjectType> getOwnImplementedInterfaces() {
        return this.implementedInterfaces;
    }

    public final void setImplementedInterfaces(List<ObjectType> implementedInterfaces) {
        Preconditions.checkState(this.isConstructor());
        this.implementedInterfaces = ImmutableList.copyOf(implementedInterfaces);
        for (ObjectType type : implementedInterfaces) {
            this.registry.registerTypeImplementingInterface(this, type);
            this.typeOfThis.mergeSupertypeTemplateTypes(type);
        }
    }

    public final ImmutableList<ObjectType> getExtendedInterfaces() {
        return this.extendedInterfaces;
    }

    public final int getExtendedInterfacesCount() {
        return this.extendedInterfaces.size();
    }

    public final void setExtendedInterfaces(List<ObjectType> extendedInterfaces) {
        Preconditions.checkState(this.isInterface());
        this.extendedInterfaces = ImmutableList.copyOf(extendedInterfaces);
        for (ObjectType extendedInterface : extendedInterfaces) {
            this.typeOfThis.mergeSupertypeTemplateTypes(extendedInterface);
        }
    }

    @Override
    public final JSType getPropertyType(String name) {
        if (!this.hasOwnProperty(name)) {
            boolean isCall = "call".equals(name);
            boolean isBind = "bind".equals(name);
            if (isCall || isBind) {
                this.defineDeclaredProperty(name, this.getCallOrBindSignature(isCall), this.source);
            } else if ("apply".equals(name)) {
                FunctionParamBuilder builder = new FunctionParamBuilder(this.registry);
                builder.addOptionalParams(this.registry.createNullableType(this.getTypeOfThis()), this.registry.createNullableType(this.registry.getNativeType(JSTypeNative.OBJECT_TYPE)));
                this.defineDeclaredProperty(name, FunctionType.builder(this.registry).withParamsNode(builder.build()).withReturnType(this.getReturnType()).withTemplateKeys(this.getTemplateTypeMap().getTemplateKeys()).build(), this.source);
            }
        }
        return super.getPropertyType(name);
    }

    public final FunctionType getBindReturnType(int argsToBind) {
        Node origParams;
        Builder builder = FunctionType.builder(this.registry).withReturnType(this.getReturnType()).withTemplateKeys(this.getTemplateTypeMap().getTemplateKeys());
        if (argsToBind >= 0 && (origParams = this.getParametersNode()) != null) {
            Node params = origParams.cloneTree();
            for (int i = 1; i < argsToBind && params.getFirstChild() != null && !params.getFirstChild().isVarArgs(); ++i) {
                params.removeFirstChild();
            }
            builder.withParamsNode(params);
        }
        return builder.build();
    }

    private FunctionType getCallOrBindSignature(boolean isCall) {
        boolean isBind = !isCall;
        Builder builder = FunctionType.builder(this.registry).withReturnType(isCall ? this.getReturnType() : this.getBindReturnType(-1)).withTemplateKeys(this.getTemplateTypeMap().getTemplateKeys());
        Node origParams = this.getParametersNode();
        if (origParams != null) {
            Node firstArg;
            Node params = origParams.cloneTree();
            Node thisTypeNode = Node.newString(Token.NAME, "thisType");
            thisTypeNode.setJSType(this.registry.createOptionalNullableType(this.getTypeOfThis()));
            params.addChildToFront(thisTypeNode);
            if (isBind) {
                for (Node current = thisTypeNode.getNext(); current != null; current = current.getNext()) {
                    current.setOptionalArg(true);
                }
            } else if (isCall && ((firstArg = thisTypeNode.getNext()) == null || firstArg.isOptionalArg() || firstArg.isVarArgs())) {
                thisTypeNode.setOptionalArg(true);
            }
            builder.withParamsNode(params);
        }
        return builder.build();
    }

    @Override
    boolean defineProperty(String name, JSType type, boolean inferred, Node propertyNode) {
        if ("prototype".equals(name)) {
            ObjectType objType = type.toObjectType();
            if (objType != null) {
                if (this.prototypeSlot != null && objType.isEquivalentTo(this.prototypeSlot.getType())) {
                    return true;
                }
                this.setPrototypeBasedOn(objType, propertyNode);
                return true;
            }
            return false;
        }
        return super.defineProperty(name, type, inferred, propertyNode);
    }

    final FunctionType supAndInfHelper(FunctionType that, boolean leastSuper) {
        JSType functionInstance;
        Preconditions.checkNotNull(that);
        if (this.isEquivalentTo(that)) {
            return this;
        }
        if (this.isOrdinaryFunction() && that.isOrdinaryFunction() && !this.call.hasUnknownParamsOrReturn() && !that.call.hasUnknownParamsOrReturn()) {
            boolean isSubtypeOfThat = this.isSubtype(that);
            boolean isSubtypeOfThis = that.isSubtype(this);
            if (isSubtypeOfThat && !isSubtypeOfThis) {
                return leastSuper ? that : this;
            }
            if (isSubtypeOfThis && !isSubtypeOfThat) {
                return leastSuper ? this : that;
            }
            FunctionType merged = this.tryMergeFunctionPiecewise(that, leastSuper);
            if (merged != null) {
                return merged;
            }
        }
        if ((functionInstance = this.registry.getNativeType(JSTypeNative.U2U_CONSTRUCTOR_TYPE)).isEquivalentTo(that)) {
            return leastSuper ? that : this;
        }
        if (functionInstance.isEquivalentTo(this)) {
            return leastSuper ? this : that;
        }
        FunctionType greatestFn = this.registry.getNativeFunctionType(JSTypeNative.U2U_CONSTRUCTOR_TYPE);
        FunctionType leastFn = this.registry.getNativeFunctionType(JSTypeNative.LEAST_FUNCTION_TYPE);
        return leastSuper ? greatestFn : leastFn;
    }

    private FunctionType tryMergeFunctionPiecewise(FunctionType other, boolean leastSuper) {
        JSType maybeNewTypeOfThis;
        Node newParamsNode = null;
        if (!this.call.hasEqualParameters(other.call, EquivalenceMethod.IDENTITY, JSType.EqCache.create())) {
            return null;
        }
        newParamsNode = this.call.parameters;
        JSType newReturnType = leastSuper ? this.call.returnType.getLeastSupertype(other.call.returnType) : this.call.returnType.getGreatestSubtype(other.call.returnType);
        JSType newTypeOfThis = null;
        newTypeOfThis = FunctionType.isEquivalent(this.typeOfThis, other.typeOfThis) ? this.typeOfThis : (maybeNewTypeOfThis = leastSuper ? this.typeOfThis.getLeastSupertype(other.typeOfThis) : this.typeOfThis.getGreatestSubtype(other.typeOfThis));
        boolean newReturnTypeInferred = this.call.returnTypeInferred || other.call.returnTypeInferred;
        return FunctionType.builder(this.registry).withParamsNode(newParamsNode).withReturnType(newReturnType, newReturnTypeInferred).withTypeOfThis(newTypeOfThis).build();
    }

    @Override
    public final FunctionType getSuperClassConstructor() {
        Preconditions.checkArgument(this.isConstructor() || this.isInterface());
        ObjectType maybeSuperInstanceType = this.getPrototype().getImplicitPrototype();
        if (maybeSuperInstanceType == null) {
            return null;
        }
        return maybeSuperInstanceType.getConstructor();
    }

    final boolean checkFunctionEquivalenceHelper(FunctionType that, EquivalenceMethod eqMethod, JSType.EqCache eqCache) {
        if (this == that) {
            return true;
        }
        if (this.kind != that.kind) {
            return false;
        }
        switch (this.kind) {
            case CONSTRUCTOR: 
            case INTERFACE: {
                return false;
            }
            case ORDINARY: {
                return this.typeOfThis.checkEquivalenceHelper(that.typeOfThis, eqMethod, eqCache) && this.call.checkArrowEquivalenceHelper(that.call, eqMethod, eqCache);
            }
        }
        throw new AssertionError();
    }

    @Override
    int recursionUnsafeHashCode() {
        int hc = this.kind.hashCode();
        switch (this.kind) {
            case CONSTRUCTOR: 
            case INTERFACE: {
                return 31 * hc + System.identityHashCode(this);
            }
            case ORDINARY: {
                hc = 31 * hc + this.typeOfThis.hashCode();
                hc = 31 * hc + this.call.hashCode();
                return hc;
            }
        }
        throw new AssertionError();
    }

    public final boolean hasEqualCallType(FunctionType otherType) {
        return this.call.checkArrowEquivalenceHelper(otherType.call, EquivalenceMethod.IDENTITY, JSType.EqCache.create());
    }

    @Override
    StringBuilder appendTo(StringBuilder sb, boolean forAnnotations) {
        boolean hasKnownTypeOfThis;
        if (!this.isPrettyPrint() || this == this.registry.getNativeType(JSTypeNative.U2U_CONSTRUCTOR_TYPE)) {
            return sb.append(forAnnotations ? "!Function" : "Function");
        }
        if (this.hasInstanceType() && this.getSource() != null) {
            sb.append("(typeof ");
            this.getInstanceType().appendTo(sb, forAnnotations);
            sb.append(")");
            return sb;
        }
        this.setPrettyPrint(false);
        sb.append("function(");
        int paramNum = this.call.parameters.getChildCount();
        boolean bl = hasKnownTypeOfThis = !(this.typeOfThis instanceof UnknownType);
        if (hasKnownTypeOfThis) {
            if (this.isConstructor()) {
                sb.append("new:");
            } else {
                sb.append("this:");
            }
            this.typeOfThis.appendTo(sb, forAnnotations);
        }
        if (paramNum > 0) {
            if (hasKnownTypeOfThis) {
                sb.append(", ");
            }
            Node p = this.call.parameters.getFirstChild();
            this.appendArgString(sb, p, forAnnotations);
            for (p = p.getNext(); p != null; p = p.getNext()) {
                sb.append(", ");
                this.appendArgString(sb, p, forAnnotations);
            }
        }
        sb.append("): ");
        this.call.returnType.appendAsNonNull(sb, forAnnotations);
        this.setPrettyPrint(true);
        return sb;
    }

    private void appendArgString(StringBuilder sb, Node p, boolean forAnnotations) {
        if (p.isVarArgs()) {
            this.appendVarArgsString(sb, p.getJSType(), forAnnotations);
        } else if (p.isOptionalArg()) {
            this.appendOptionalArgString(sb, p.getJSType(), forAnnotations);
        } else {
            p.getJSType().appendAsNonNull(sb, forAnnotations);
        }
    }

    private void appendVarArgsString(StringBuilder sb, JSType paramType, boolean forAnnotations) {
        sb.append("...");
        paramType.appendAsNonNull(sb, forAnnotations);
    }

    private void appendOptionalArgString(StringBuilder sb, JSType paramType, boolean forAnnotations) {
        if (paramType.isUnionType()) {
            paramType = paramType.toMaybeUnionType().getRestrictedUnion(this.registry.getNativeType(JSTypeNative.VOID_TYPE));
        }
        paramType.appendAsNonNull(sb, forAnnotations).append("=");
    }

    @Override
    public boolean isSubtype(JSType that) {
        return this.isSubtype(that, JSType.ImplCache.create(), JSType.SubtypingMode.NORMAL);
    }

    @Override
    protected boolean isSubtype(JSType that, JSType.ImplCache implicitImplCache, JSType.SubtypingMode subtypingMode) {
        if (JSType.isSubtypeHelper(this, that, implicitImplCache, subtypingMode)) {
            return true;
        }
        if (that.isFunctionType()) {
            FunctionType other = that.toMaybeFunctionType();
            if (other.isInterface()) {
                return true;
            }
            if (this.isInterface()) {
                return false;
            }
            return this.shouldTreatThisTypesAsCovariant(other, implicitImplCache) && this.call.isSubtype(other.call, implicitImplCache, subtypingMode);
        }
        return this.getNativeType(JSTypeNative.FUNCTION_PROTOTYPE).isSubtype(that, implicitImplCache, subtypingMode);
    }

    private boolean shouldTreatThisTypesAsCovariant(FunctionType other, JSType.ImplCache implicitImplCache) {
        boolean shouldTreatThisTypesAsCovariant = other.typeOfThis.toObjectType() != null && other.typeOfThis.toObjectType().getConstructor() != null && other.typeOfThis.toObjectType().getConstructor().isInterface() || other.typeOfThis.isSubtype(this.typeOfThis, implicitImplCache, JSType.SubtypingMode.NORMAL) || this.typeOfThis.isSubtype(other.typeOfThis, implicitImplCache, JSType.SubtypingMode.NORMAL);
        return shouldTreatThisTypesAsCovariant;
    }

    @Override
    public <T> T visit(Visitor<T> visitor) {
        return visitor.caseFunctionType(this);
    }

    @Override
    <T> T visit(RelationshipVisitor<T> visitor, JSType that) {
        return visitor.caseFunctionType(this, that);
    }

    public final ObjectType getInstanceType() {
        Preconditions.checkState(this.hasInstanceType(), "Expected a constructor; got %s", (Object)this);
        return this.typeOfThis.toObjectType();
    }

    final void setInstanceType(ObjectType instanceType) {
        this.typeOfThis = instanceType;
    }

    public final boolean hasInstanceType() {
        return this.isConstructor() || this.isInterface();
    }

    @Override
    public final JSType getTypeOfThis() {
        return this.typeOfThis.isEmptyType() ? this.registry.getNativeObjectType(JSTypeNative.UNKNOWN_TYPE) : this.typeOfThis;
    }

    public final Node getSource() {
        return this.source;
    }

    public final void setSource(Node source) {
        if (this.prototypeSlot != null && (source == null || this.prototypeSlot.getNode() == null)) {
            this.prototypeSlot = new Property(this.prototypeSlot.getName(), this.prototypeSlot.getType(), this.prototypeSlot.isTypeInferred(), source);
        }
        this.source = source;
    }

    private void addSubType(FunctionType subType) {
        if (this.subTypes == null) {
            this.subTypes = new ArrayList<FunctionType>();
        }
        this.subTypes.add(subType);
    }

    final void addSubClassAfterResolution(FunctionType subClass) {
        Preconditions.checkArgument(this == subClass.getSuperClassConstructor());
        if (!subClass.wasAddedToExtendedConstructorSubtypes) {
            this.addSubType(subClass);
        }
    }

    @Override
    public final void clearCachedValues() {
        super.clearCachedValues();
        if (this.subTypes != null) {
            for (FunctionType subType : this.subTypes) {
                subType.clearCachedValues();
            }
        }
        if (!this.isNativeObjectType()) {
            if (this.hasInstanceType()) {
                this.getInstanceType().clearCachedValues();
            }
            if (this.prototypeSlot != null) {
                ((ObjectType)this.prototypeSlot.getType()).clearCachedValues();
            }
        }
    }

    public final Iterable<FunctionType> getDirectSubTypes() {
        return Iterables.concat(this.subTypes != null ? this.subTypes : ImmutableList.of(), this.registry.getDirectImplementors(this));
    }

    @Override
    public final boolean hasCachedValues() {
        return this.prototypeSlot != null || super.hasCachedValues();
    }

    @Override
    JSType resolveInternal(ErrorReporter reporter) {
        ImmutableList<ObjectType> resolvedExtended;
        ImmutableList<ObjectType> resolvedImplemented;
        JSType maybeTypeOfThis;
        this.setResolvedTypeInternal(this);
        this.call = (ArrowType)FunctionType.safeResolve(this.call, reporter);
        if (this.prototypeSlot != null) {
            this.prototypeSlot.setType(FunctionType.safeResolve(this.prototypeSlot.getType(), reporter));
        }
        if ((maybeTypeOfThis = FunctionType.safeResolve(this.typeOfThis, reporter)) != null) {
            if (maybeTypeOfThis.isNullType() || maybeTypeOfThis.isVoidType()) {
                this.typeOfThis = maybeTypeOfThis;
            } else if ((maybeTypeOfThis = ObjectType.cast(maybeTypeOfThis.restrictByNotNullOrUndefined())) != null) {
                this.typeOfThis = maybeTypeOfThis;
            }
        }
        if ((resolvedImplemented = this.resolveTypeListHelper(this.implementedInterfaces, reporter)) != null) {
            this.implementedInterfaces = resolvedImplemented;
        }
        if ((resolvedExtended = this.resolveTypeListHelper(this.extendedInterfaces, reporter)) != null) {
            this.extendedInterfaces = resolvedExtended;
        }
        if (this.subTypes != null) {
            for (int i = 0; i < this.subTypes.size(); ++i) {
                FunctionType subType = this.subTypes.get(i);
                this.subTypes.set(i, JSType.toMaybeFunctionType(subType.resolve(reporter)));
            }
        }
        return super.resolveInternal(reporter);
    }

    private ImmutableList<ObjectType> resolveTypeListHelper(ImmutableList<ObjectType> list, ErrorReporter reporter) {
        boolean changed = false;
        ImmutableList.Builder resolvedList = ImmutableList.builder();
        for (ObjectType type : list) {
            JSType rt = type.resolve(reporter);
            if (!rt.isObjectType()) {
                reporter.warning("not an object type: " + rt + " (at " + this.toString() + ")", this.source.getSourceFileName(), this.source.getLineno(), this.source.getCharno());
                continue;
            }
            ObjectType resolved = rt.toObjectType();
            resolvedList.add(resolved);
            changed |= resolved != type;
        }
        return changed ? resolvedList.build() : null;
    }

    @Override
    public final String toDebugHashCodeString() {
        boolean hasKnownTypeOfThis;
        if (this == this.registry.getNativeType(JSTypeNative.U2U_CONSTRUCTOR_TYPE)) {
            return super.toDebugHashCodeString();
        }
        StringBuilder b = new StringBuilder(32);
        b.append("function (");
        int paramNum = this.call.parameters.getChildCount();
        boolean bl = hasKnownTypeOfThis = !this.typeOfThis.isUnknownType();
        if (hasKnownTypeOfThis) {
            b.append("this:");
            b.append(this.getDebugHashCodeStringOf(this.typeOfThis));
        }
        if (paramNum > 0) {
            if (hasKnownTypeOfThis) {
                b.append(", ");
            }
            Node p = this.call.parameters.getFirstChild();
            b.append(this.getDebugHashCodeStringOf(p.getJSType()));
            for (p = p.getNext(); p != null; p = p.getNext()) {
                b.append(", ");
                b.append(this.getDebugHashCodeStringOf(p.getJSType()));
            }
        }
        b.append(")");
        b.append(": ");
        b.append(this.getDebugHashCodeStringOf(this.call.returnType));
        return b.toString();
    }

    private String getDebugHashCodeStringOf(JSType type) {
        if (type == this) {
            return "me";
        }
        return type.toDebugHashCodeString();
    }

    @Override
    final boolean hasAnyTemplateTypesInternal() {
        return this.getTemplateParamCount() > 0 || this.typeOfThis.hasAnyTemplateTypes() || this.call.hasAnyTemplateTypes();
    }

    public final boolean hasProperties() {
        return !super.getOwnPropertyNames().isEmpty();
    }

    public final void setImplicitMatch(boolean flag) {
        Preconditions.checkState(this.isInterface());
        this.isStructuralInterface = flag;
    }

    @Override
    public final boolean isStructuralInterface() {
        return this.isInterface() && this.isStructuralInterface;
    }

    public final boolean isAbstract() {
        return this.isAbstract;
    }

    @Override
    public final Map<String, JSType> getPropertyTypeMap() {
        LinkedHashMap<String, JSType> propTypeMap = new LinkedHashMap<String, JSType>();
        FunctionType.updatePropertyTypeMap(this, propTypeMap, new HashSet<FunctionType>());
        return propTypeMap;
    }

    private static void updatePropertyTypeMap(FunctionType type, Map<String, JSType> propTypeMap, HashSet<FunctionType> cache) {
        ImmutableList<ObjectType> iterable;
        if (type == null) {
            return;
        }
        ObjectType prototype = type.getPrototype();
        if (prototype != null) {
            Set<String> propNames = prototype.getOwnPropertyNames();
            for (String name : propNames) {
                if (propTypeMap.containsKey(name)) continue;
                JSType propType = prototype.getPropertyType(name);
                propTypeMap.put(name, propType);
            }
        }
        if ((iterable = type.getExtendedInterfaces()) != null) {
            for (ObjectType interfaceType : iterable) {
                FunctionType superConstructor = interfaceType.getConstructor();
                if (superConstructor == null || cache.contains(superConstructor)) continue;
                cache.add(superConstructor);
                FunctionType.updatePropertyTypeMap(superConstructor, propTypeMap, cache);
                cache.remove(superConstructor);
            }
        }
    }

    public final List<FunctionType> checkExtendsLoop() {
        return this.checkExtendsLoop(new HashSet<FunctionType>(), new ArrayList<FunctionType>());
    }

    private List<FunctionType> checkExtendsLoop(Set<FunctionType> cache, List<FunctionType> path) {
        ImmutableList<ObjectType> iterable = this.getExtendedInterfaces();
        if (iterable != null) {
            for (ObjectType interfaceType : iterable) {
                FunctionType superConstructor = interfaceType.getConstructor();
                if (superConstructor == null) continue;
                if (cache.contains(superConstructor)) {
                    path.add(superConstructor);
                    while (path.get(0) != superConstructor) {
                        path.remove(0);
                    }
                    return path;
                }
                cache.add(superConstructor);
                path.add(superConstructor);
                List<FunctionType> result = superConstructor.checkExtendsLoop(cache, path);
                if (result != null) {
                    return result;
                }
                cache.remove(superConstructor);
                path.remove(path.size() - 1);
            }
        }
        return null;
    }

    public final boolean acceptsArguments(List<? extends JSType> argumentTypes) {
        Iterator<? extends JSType> arguments = argumentTypes.iterator();
        Iterator<Node> parameters = this.getParameters().iterator();
        Node parameter = null;
        JSType argument = null;
        while (arguments.hasNext() && (parameters.hasNext() || parameter != null && parameter.isVarArgs())) {
            if (parameters.hasNext()) {
                parameter = parameters.next();
            }
            if ((argument = arguments.next()).isSubtypeOf(parameter.getJSType())) continue;
            return false;
        }
        int numArgs = argumentTypes.size();
        return this.getMinArity() <= numArgs && numArgs <= this.getMaxArity();
    }

    public final FunctionType forgetParameterAndReturnTypes() {
        FunctionType result = FunctionType.builder(this.registry).withName(this.getReferenceName()).withSourceNode(this.source).withTypeOfThis(this.getInstanceType()).withKind(this.kind).withCanonicalRepresentation(this).build();
        result.setPrototypeBasedOn(this.getInstanceType());
        return result;
    }

    public final ImmutableList<TemplateType> getConstructorOnlyTemplateParameters() {
        Preconditions.checkState(this.isConstructor(), this);
        TemplateTypeMap map = this.getTemplateTypeMap();
        int ctorOnlyKeyCount = this.getTemplateParamCount() - this.getInstanceType().getTemplateParamCount();
        return map.getTemplateKeys().subList(map.size() - ctorOnlyKeyCount, map.size());
    }

    boolean createsAmbiguousObjects() {
        if (this.constructorAmbiguity == ConstructorAmbiguity.UNKNOWN) {
            this.constructorAmbiguity = this.calculateConstructorAmbiguity();
        }
        return this.constructorAmbiguity == ConstructorAmbiguity.CONSTRUCTS_AMBIGUOUS_OBJECTS;
    }

    private ConstructorAmbiguity calculateConstructorAmbiguity() {
        FunctionType superConstructor;
        ConstructorAmbiguity constructorAmbiguity = this.isUnknownType() ? ConstructorAmbiguity.CONSTRUCTS_AMBIGUOUS_OBJECTS : (this.isNativeObjectType() ? ConstructorAmbiguity.CONSTRUCTS_UNAMBIGUOUS_OBJECTS : ((superConstructor = this.getSuperClassConstructor()) == null ? ConstructorAmbiguity.CONSTRUCTS_AMBIGUOUS_OBJECTS : (superConstructor.createsAmbiguousObjects() ? ConstructorAmbiguity.CONSTRUCTS_AMBIGUOUS_OBJECTS : (this.source != null ? ConstructorAmbiguity.CONSTRUCTS_UNAMBIGUOUS_OBJECTS : (this.isDelegateProxy() ? ConstructorAmbiguity.CONSTRUCTS_UNAMBIGUOUS_OBJECTS : ConstructorAmbiguity.CONSTRUCTS_AMBIGUOUS_OBJECTS)))));
        return constructorAmbiguity;
    }

    private boolean isDelegateProxy() {
        return this.hasReferenceName() && this.getReferenceName().endsWith(DELEGATE_SUFFIX);
    }

    public final ClosurePrimitive getClosurePrimitive() {
        return this.closurePrimitive;
    }

    public static Builder builder(JSTypeRegistry registry) {
        return new Builder(registry);
    }

    @Override
    JSType simplifyForOptimizations() {
        return this.canonicalRepresentation != null ? this.canonicalRepresentation : super.simplifyForOptimizations();
    }

    public static final class Builder
    extends PrototypeObjectType.Builder<Builder> {
        private static final int IS_ABSTRACT = 1;
        private static final int INFERRED_RETURN_TYPE = 4;
        private static final int RETURNS_OWN_INSTANCE_TYPE = 8;
        private Node sourceNode = null;
        private Node parametersNode = null;
        private JSType returnType = null;
        private JSType typeOfThis = null;
        private ObjectType setPrototypeBasedOn = null;
        private Set<TemplateType> constructorOnlyKeys = ImmutableSet.of();
        private Kind kind = Kind.ORDINARY;
        private int properties = 0;
        private ClosurePrimitive primitiveId = null;
        private FunctionType canonicalRepresentation = null;

        private Builder(JSTypeRegistry registry) {
            super(registry);
            this.setImplicitPrototype(registry.getNativeObjectType(JSTypeNative.U2U_CONSTRUCTOR_TYPE));
        }

        public Builder withName(String name) {
            return (Builder)this.setName(name);
        }

        public Builder withSourceNode(Node sourceNode) {
            this.sourceNode = sourceNode;
            return this;
        }

        public Builder withParamsNode(Node parametersNode) {
            this.parametersNode = parametersNode;
            return this;
        }

        Builder withEmptyParams() {
            this.parametersNode = this.registry.createEmptyParams();
            return this;
        }

        public Builder withReturnType(JSType returnType) {
            this.returnType = returnType;
            return this;
        }

        public Builder withReturnType(JSType returnType, boolean inferred) {
            this.returnType = returnType;
            this.properties = inferred ? this.properties | 4 : this.properties & 0xFFFFFFFB;
            return this;
        }

        Builder withReturnsOwnInstanceType() {
            this.properties |= 8;
            return this;
        }

        public Builder withInferredReturnType(JSType returnType) {
            this.returnType = returnType;
            this.properties |= 4;
            return this;
        }

        public Builder withTypeOfThis(JSType typeOfThis) {
            this.typeOfThis = typeOfThis;
            return this;
        }

        public Builder withTemplateKeys(ImmutableList<TemplateType> templateKeys) {
            return (Builder)((Builder)this.setTemplateTypeMap(this.registry.getEmptyTemplateTypeMap().copyWithExtension(templateKeys, ImmutableList.of()))).setTemplateParamCount(templateKeys.size());
        }

        public Builder withTemplateKeys(TemplateType ... templateKeys) {
            return this.withTemplateKeys(ImmutableList.copyOf(templateKeys));
        }

        public Builder withConstructorTemplateKeys(Iterable<TemplateType> constructorOnlyKeys) {
            this.constructorOnlyKeys = ImmutableSet.copyOf(constructorOnlyKeys);
            return this;
        }

        Builder withKind(Kind kind) {
            this.kind = kind;
            return this;
        }

        public Builder forConstructor() {
            this.kind = Kind.CONSTRUCTOR;
            return this;
        }

        public Builder forInterface() {
            this.kind = Kind.INTERFACE;
            this.parametersNode = this.registry.createEmptyParams();
            return this;
        }

        Builder forNativeType() {
            return (Builder)this.setNative(true);
        }

        public Builder withIsAbstract(boolean isAbstract) {
            this.properties = isAbstract ? this.properties | 1 : this.properties & 0xFFFFFFFE;
            return this;
        }

        private boolean isAbstract() {
            return (this.properties & 1) != 0;
        }

        public Builder withPrototypeBasedOn(ObjectType setPrototypeBasedOn) {
            this.setPrototypeBasedOn = setPrototypeBasedOn;
            return this;
        }

        public Builder withClosurePrimitiveId(ClosurePrimitive id) {
            this.primitiveId = id;
            return this;
        }

        private Builder withCanonicalRepresentation(FunctionType representation) {
            this.canonicalRepresentation = representation;
            return this;
        }

        private ArrowType buildArrowType() {
            boolean inferredReturnType = (this.properties & 4) != 0;
            return new ArrowType(this.registry, this.parametersNode, this.returnType, inferredReturnType);
        }

        public Builder copyFromOtherFunction(FunctionType otherType) {
            int isAbstract = otherType.isAbstract() ? 1 : 0;
            int inferredReturnType = otherType.isReturnTypeInferred() ? 4 : 0;
            ((Builder)((Builder)((Builder)this.setName(otherType.getReferenceName())).setNative(otherType.isNativeObjectType())).setTemplateTypeMap(otherType.getTemplateTypeMap())).setTemplateParamCount(otherType.getTemplateParamCount());
            this.sourceNode = otherType.getSource();
            this.parametersNode = otherType.getParametersNode();
            this.returnType = otherType.getReturnType();
            this.typeOfThis = otherType.getTypeOfThis();
            this.kind = otherType.getKind();
            this.properties = isAbstract | inferredReturnType;
            this.primitiveId = otherType.getClosurePrimitive();
            return this;
        }

        @Override
        public FunctionType build() {
            boolean hasConstructorOnlyKeys;
            boolean returnsOwnInstanceType = (this.properties & 8) != 0;
            boolean bl = hasConstructorOnlyKeys = !this.constructorOnlyKeys.isEmpty();
            if (hasConstructorOnlyKeys) {
                this.typeOfThis = this.registry.getNativeObjectType(JSTypeNative.UNKNOWN_TYPE);
            }
            FunctionType ft = new FunctionType(this);
            if (this.setPrototypeBasedOn != null) {
                ft.setPrototypeBasedOn(this.setPrototypeBasedOn);
            }
            if (returnsOwnInstanceType) {
                ft.getInternalArrowType().returnType = ft.getInstanceType();
            }
            if (hasConstructorOnlyKeys) {
                ft.setInstanceType(((InstanceObjectType.Builder)((InstanceObjectType.Builder)InstanceObjectType.builderForCtor(ft).setTemplateTypeMap(ft.templateTypeMap.copyWithoutKeys(this.constructorOnlyKeys))).setTemplateParamCount(ft.getTemplateParamCount() - this.constructorOnlyKeys.size())).build());
            }
            return ft;
        }
    }

    static enum ConstructorAmbiguity {
        UNKNOWN,
        CONSTRUCTS_AMBIGUOUS_OBJECTS,
        CONSTRUCTS_UNAMBIGUOUS_OBJECTS;

    }

    private static enum PropAccess {
        ANY,
        ANY_EXPLICIT,
        STRUCT,
        DICT;

    }

    static enum Kind {
        ORDINARY,
        CONSTRUCTOR,
        INTERFACE;

    }
}

