/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.checks.javadoc.AbstractJavadocCheck;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocUtils;
import java.util.ArrayList;
import java.util.List;

public class JavadocTagContinuationIndentationCheck
extends AbstractJavadocCheck {
    public static final String MSG_KEY = "tag.continuation.indent";
    private static final int DEFAULT_INDENTATION = 4;
    private int offset = 4;

    public void setOffset(int offset) {
        this.offset = offset;
    }

    @Override
    public int[] getDefaultJavadocTokens() {
        return new int[]{10068};
    }

    @Override
    public void visitJavadocToken(DetailNode ast) {
        List<DetailNode> textNodes = this.getAllNewlineNodes(ast);
        if (this.isInlineDescription(ast)) {
            return;
        }
        for (DetailNode newlineNode : textNodes) {
            DetailNode whitespace;
            DetailNode textNode = JavadocUtils.getNextSibling(JavadocUtils.getNextSibling(newlineNode));
            if (textNode == null || textNode.getType() != 10074 || textNode.getChildren().length <= 1 || (whitespace = JavadocUtils.getFirstChild(textNode)).getType() != 4 || whitespace.getText().length() - 1 >= this.offset) continue;
            this.log(textNode.getLineNumber(), MSG_KEY, this.offset);
        }
    }

    private List<DetailNode> getAllNewlineNodes(DetailNode descriptionNode) {
        ArrayList<DetailNode> textNodes = new ArrayList<DetailNode>();
        DetailNode node = JavadocUtils.getFirstChild(descriptionNode);
        while (JavadocUtils.getNextSibling(node) != null) {
            if (node.getType() == 6) {
                textNodes.add(node);
            }
            node = JavadocUtils.getNextSibling(node);
        }
        return textNodes;
    }

    private boolean isInlineDescription(DetailNode description) {
        for (DetailNode inlineTag = description.getParent(); inlineTag != null; inlineTag = inlineTag.getParent()) {
            if (inlineTag.getType() != 10072) continue;
            return true;
        }
        return false;
    }
}

