/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.api;

import com.puppycrawl.tools.checkstyle.Utils;
import com.puppycrawl.tools.checkstyle.api.AbstractViolationReporter;
import com.puppycrawl.tools.checkstyle.api.FileSetCheck;
import com.puppycrawl.tools.checkstyle.api.LocalizedMessage;
import com.puppycrawl.tools.checkstyle.api.LocalizedMessages;
import com.puppycrawl.tools.checkstyle.api.MessageDispatcher;
import java.io.File;
import java.util.List;
import java.util.TreeSet;

public abstract class AbstractFileSetCheck
extends AbstractViolationReporter
implements FileSetCheck {
    private MessageDispatcher dispatcher;
    private String[] fileExtensions = new String[0];
    private final LocalizedMessages messages = new LocalizedMessages();

    protected abstract void processFiltered(File var1, List<String> var2);

    @Override
    public void init() {
    }

    @Override
    public void destroy() {
    }

    @Override
    public void beginProcessing(String charset) {
    }

    @Override
    public final TreeSet<LocalizedMessage> process(File file, List<String> lines) {
        this.getMessageCollector().reset();
        if (Utils.fileExtensionMatches(file, this.fileExtensions)) {
            this.processFiltered(file, lines);
        }
        return this.getMessageCollector().getMessages();
    }

    @Override
    public void finishProcessing() {
    }

    @Override
    public final void setMessageDispatcher(MessageDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    protected final MessageDispatcher getMessageDispatcher() {
        return this.dispatcher;
    }

    public String[] getFileExtensions() {
        return this.fileExtensions;
    }

    public final void setFileExtensions(String[] extensions) {
        if (extensions == null) {
            this.fileExtensions = null;
            return;
        }
        this.fileExtensions = new String[extensions.length];
        for (int i = 0; i < extensions.length; ++i) {
            String extension = extensions[i];
            this.fileExtensions[i] = extension.startsWith(".") ? extension : "." + extension;
        }
    }

    protected final LocalizedMessages getMessageCollector() {
        return this.messages;
    }

    @Override
    public final void log(int line, String key, Object ... args) {
        this.log(line, 0, key, args);
    }

    @Override
    public final void log(int lineNo, int colNo, String key, Object ... args) {
        this.getMessageCollector().add(new LocalizedMessage(lineNo, colNo, this.getMessageBundle(), key, args, this.getSeverityLevel(), this.getId(), this.getClass(), this.getCustomMessages().get(key)));
    }

    protected final void fireErrors(String fileName) {
        TreeSet<LocalizedMessage> errors = this.getMessageCollector().getMessages();
        this.getMessageCollector().reset();
        this.getMessageDispatcher().fireErrors(fileName, errors);
    }
}

