/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.checks.coding.AbstractIllegalCheck;
import java.util.LinkedList;
import java.util.List;

public final class IllegalCatchCheck
extends AbstractIllegalCheck {
    public static final String MSG_KEY = "illegal.catch";

    public IllegalCatchCheck() {
        super(new String[]{"Exception", "Error", "RuntimeException", "Throwable", "java.lang.Error", "java.lang.Exception", "java.lang.RuntimeException", "java.lang.Throwable"});
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{96};
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{96};
    }

    @Override
    public void visitToken(DetailAST detailAST) {
        DetailAST paradef = detailAST.findFirstToken(21);
        DetailAST excTypeParent = paradef.findFirstToken(13);
        List<DetailAST> excTypes = this.getAllExceptionTypes(excTypeParent);
        for (DetailAST excType : excTypes) {
            FullIdent ident = FullIdent.createFullIdent(excType);
            if (!this.isIllegalClassName(ident.getText())) continue;
            this.log(detailAST, MSG_KEY, ident.getText());
        }
    }

    public List<DetailAST> getAllExceptionTypes(DetailAST parentToken) {
        DetailAST currentNode = parentToken.getFirstChild();
        LinkedList<DetailAST> exceptionTypes = new LinkedList<DetailAST>();
        if (currentNode.getType() == 112) {
            exceptionTypes.addAll(this.getAllExceptionTypes(currentNode));
            currentNode = currentNode.getNextSibling();
            if (currentNode != null) {
                exceptionTypes.add(currentNode);
            }
        } else {
            exceptionTypes.add(currentNode);
            while ((currentNode = currentNode.getNextSibling()) != null) {
                exceptionTypes.add(currentNode);
            }
        }
        return exceptionTypes;
    }
}

