/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.CheckUtils;

public class MultipleVariableDeclarationsCheck
extends Check {
    public static final String MSG_MULTIPLE = "multiple.variable.declarations";
    public static final String MSG_MULTIPLE_COMMA = "multiple.variable.declarations.comma";

    @Override
    public int[] getDefaultTokens() {
        return new int[]{10};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{10};
    }

    @Override
    public void visitToken(DetailAST ast) {
        boolean isCommaSeparated;
        DetailAST nextNode = ast.getNextSibling();
        boolean bl = isCommaSeparated = nextNode != null && nextNode.getType() == 74;
        if (nextNode == null) {
            return;
        }
        if (nextNode.getType() == 74 || nextNode.getType() == 45) {
            nextNode = nextNode.getNextSibling();
        }
        if (nextNode != null && nextNode.getType() == 10) {
            DetailAST firstNode = CheckUtils.getFirstNode(ast);
            if (isCommaSeparated) {
                if (ast.getParent().getType() != 35) {
                    this.log(firstNode, MSG_MULTIPLE_COMMA, new Object[0]);
                }
                return;
            }
            DetailAST lastNode = MultipleVariableDeclarationsCheck.getLastNode(ast);
            DetailAST firstNextNode = CheckUtils.getFirstNode(nextNode);
            if (firstNextNode.getLineNo() == lastNode.getLineNo()) {
                this.log(firstNode, MSG_MULTIPLE, new Object[0]);
            }
        }
    }

    private static DetailAST getLastNode(DetailAST node) {
        DetailAST currentNode = node;
        for (DetailAST child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            DetailAST newNode = MultipleVariableDeclarationsCheck.getLastNode(child);
            if (newNode.getLineNo() <= currentNode.getLineNo() && (newNode.getLineNo() != currentNode.getLineNo() || newNode.getColumnNo() <= currentNode.getColumnNo())) continue;
            currentNode = newNode;
        }
        return currentNode;
    }
}

