/*
 * Copyright 2017 Google Inc.
 *
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */
/*****************************************************************************************
 ******************** This file was generated by sksllex. Do not edit. *******************
 *****************************************************************************************/
#ifndef SKSL_LayoutLexer
#define SKSL_LayoutLexer
#include <cstddef>
#include <cstdint>
namespace SkSL {

struct LayoutToken {
    enum Kind {
#undef END_OF_FILE
        END_OF_FILE,
#undef LOCATION
        LOCATION,
#undef OFFSET
        OFFSET,
#undef BINDING
        BINDING,
#undef INDEX
        INDEX,
#undef SET
        SET,
#undef BUILTIN
        BUILTIN,
#undef INPUT_ATTACHMENT_INDEX
        INPUT_ATTACHMENT_INDEX,
#undef ORIGIN_UPPER_LEFT
        ORIGIN_UPPER_LEFT,
#undef OVERRIDE_COVERAGE
        OVERRIDE_COVERAGE,
#undef BLEND_SUPPORT_ALL_EQUATIONS
        BLEND_SUPPORT_ALL_EQUATIONS,
#undef BLEND_SUPPORT_MULTIPLY
        BLEND_SUPPORT_MULTIPLY,
#undef BLEND_SUPPORT_SCREEN
        BLEND_SUPPORT_SCREEN,
#undef BLEND_SUPPORT_OVERLAY
        BLEND_SUPPORT_OVERLAY,
#undef BLEND_SUPPORT_DARKEN
        BLEND_SUPPORT_DARKEN,
#undef BLEND_SUPPORT_LIGHTEN
        BLEND_SUPPORT_LIGHTEN,
#undef BLEND_SUPPORT_COLORDODGE
        BLEND_SUPPORT_COLORDODGE,
#undef BLEND_SUPPORT_COLORBURN
        BLEND_SUPPORT_COLORBURN,
#undef BLEND_SUPPORT_HARDLIGHT
        BLEND_SUPPORT_HARDLIGHT,
#undef BLEND_SUPPORT_SOFTLIGHT
        BLEND_SUPPORT_SOFTLIGHT,
#undef BLEND_SUPPORT_DIFFERENCE
        BLEND_SUPPORT_DIFFERENCE,
#undef BLEND_SUPPORT_EXCLUSION
        BLEND_SUPPORT_EXCLUSION,
#undef BLEND_SUPPORT_HSL_HUE
        BLEND_SUPPORT_HSL_HUE,
#undef BLEND_SUPPORT_HSL_SATURATION
        BLEND_SUPPORT_HSL_SATURATION,
#undef BLEND_SUPPORT_HSL_COLOR
        BLEND_SUPPORT_HSL_COLOR,
#undef BLEND_SUPPORT_HSL_LUMINOSITY
        BLEND_SUPPORT_HSL_LUMINOSITY,
#undef PUSH_CONSTANT
        PUSH_CONSTANT,
#undef POINTS
        POINTS,
#undef LINES
        LINES,
#undef LINE_STRIP
        LINE_STRIP,
#undef LINES_ADJACENCY
        LINES_ADJACENCY,
#undef TRIANGLES
        TRIANGLES,
#undef TRIANGLE_STRIP
        TRIANGLE_STRIP,
#undef TRIANGLES_ADJACENCY
        TRIANGLES_ADJACENCY,
#undef MAX_VERTICES
        MAX_VERTICES,
#undef INVOCATIONS
        INVOCATIONS,
#undef WHEN
        WHEN,
#undef KEY
        KEY,
#undef CTYPE
        CTYPE,
#undef INVALID
        INVALID,
    };

    LayoutToken() : fKind(Kind::INVALID), fOffset(-1), fLength(-1) {}

    LayoutToken(Kind kind, int offset, int length)
            : fKind(kind), fOffset(offset), fLength(length) {}

    Kind fKind;
    int fOffset;
    int fLength;
};

class LayoutLexer {
public:
    void start(const char* text, size_t length) {
        fText = text;
        fLength = length;
        fOffset = 0;
    }

    LayoutToken next();

private:
    const char* fText;
    int fLength;
    int fOffset;
};

}  // namespace SkSL
#endif
