/*
 * Decompiled with CFR 0.152.
 */
package jedecma;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import jedecma.Jedecma;

public class DgnEditor
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final JTextArea editor = new JTextArea();
    private int maxSizeText;
    private Vector dict = this.getDict();
    private boolean completionEnable = true;
    private boolean tipStatus = false;
    private TextAreaDocumentListener dList;

    public DgnEditor() {
        this(1024);
    }

    public DgnEditor(int mSize) {
        this.maxSizeText = mSize;
        if (Jedecma.jTextAreaFont != null) {
            this.editor.setFont(Jedecma.jTextAreaFont);
        }
        this.editor.registerKeyboardAction(new ActionListener(){
            KeyStroke enter = KeyStroke.getKeyStroke(10, 0);

            @Override
            public void actionPerformed(ActionEvent ae) {
                final TextAreaDocumentListener listener = DgnEditor.this.dList;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DgnEditor.this.editor.getDocument().removeDocumentListener(listener);
                        int i = DgnEditor.this.editor.getCaretPosition();
                        int start = DgnEditor.this.editor.getSelectionStart();
                        int end = DgnEditor.this.editor.getSelectionEnd();
                        if (start == end && DgnEditor.this.getTipStatus()) {
                            DgnEditor.this.setTipStatus(false);
                        }
                        if (!DgnEditor.this.getTipStatus()) {
                            String text = DgnEditor.this.editor.getText();
                            String s = text.substring(0, start);
                            String r = text.substring(end);
                            DgnEditor.this.editor.setText(String.valueOf(s) + "\n" + r);
                            DgnEditor.this.editor.select(start + 1, start + 1);
                        } else {
                            DgnEditor.this.editor.select(end, end);
                        }
                        DgnEditor.this.setTipStatus(false);
                        DgnEditor.this.editor.getDocument().addDocumentListener(listener);
                    }
                });
            }
        }, KeyStroke.getKeyStroke(10, 0), 0);
        this.editor.setDocument(new FixedSizePlainDocument(this.maxSizeText));
        this.editor.setLineWrap(true);
        this.editor.setWrapStyleWord(true);
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.editor), "Center");
        JPanel bPanel = new JPanel();
        this.add((Component)bPanel, "South");
        AbstractAction action = new AbstractAction(Jedecma.localMessagesBundle.getString("AUTOCOMP")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                JCheckBox cb = (JCheckBox)evt.getSource();
                boolean isSel = cb.isSelected();
                if (isSel) {
                    if (DgnEditor.this.dict.size() > 0) {
                        DgnEditor.this.setCompletionEnable(true);
                    } else {
                        cb.setSelected(false);
                    }
                } else {
                    DgnEditor.this.setCompletionEnable(false);
                }
            }
        };
        JCheckBox cBox = new JCheckBox(action);
        cBox.setSelected(true);
        bPanel.add(cBox);
        TextAreaDocumentListener dList = new TextAreaDocumentListener();
        this.editor.getDocument().addDocumentListener(dList);
    }

    public String getText() {
        return this.editor.getText();
    }

    public void setText(String text) {
        this.editor.setText(text);
    }

    private void setCompletionEnable(boolean b) {
        this.completionEnable = b;
    }

    private boolean getCompletionEnable() {
        return this.completionEnable;
    }

    private void setTipStatus(boolean b) {
        this.tipStatus = b;
    }

    private boolean getTipStatus() {
        return this.tipStatus;
    }

    private Vector getDict() {
        return Jedecma.dict;
    }

    public Iterator getDictIterator() {
        return this.dict.iterator();
    }

    class FixedSizePlainDocument
    extends PlainDocument {
        private static final long serialVersionUID = 1L;
        private int maxSize;

        public FixedSizePlainDocument(int limit) {
            this.maxSize = limit;
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (this.getLength() + str.length() > this.maxSize) {
                throw new BadLocationException("Insertion exceeds max size of document", offs);
            }
            super.insertString(offs, str, a);
        }
    }

    class TextAreaDocumentListener
    implements DocumentListener {
        TextAreaDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            if (DgnEditor.this.getCompletionEnable()) {
                this.findTip();
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            DgnEditor.this.setTipStatus(false);
        }

        private String find(String s) {
            String found = "";
            Iterator i = DgnEditor.this.getDictIterator();
            while (i.hasNext()) {
                int wordLen;
                String item = (String)i.next();
                if (!item.substring(0, wordLen = Math.min(s.length(), item.length())).equals(s.substring(0, wordLen))) continue;
                found = item;
                break;
            }
            return found;
        }

        private void findTip() {
            String word = this.currWord();
            if (word.length() >= 4) {
                char ch = word.charAt(word.length() - 1);
                String s = this.find(word = word.toUpperCase());
                if (s.length() > 0) {
                    final int caretInitial = DgnEditor.this.editor.getCaretPosition();
                    String st = s.substring(word.length());
                    if (Character.isLowerCase(ch)) {
                        st = st.toLowerCase();
                    }
                    final String subst = String.valueOf(st) + " ";
                    String text = DgnEditor.this.editor.getText();
                    int lText = text.length();
                    if (lText + st.length() <= DgnEditor.this.maxSizeText) {
                        final int caretFinal = caretInitial + subst.length();
                        final TextAreaDocumentListener listener = this;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                DgnEditor.this.editor.getDocument().removeDocumentListener(listener);
                                DgnEditor.this.editor.insert(subst, caretInitial + 1);
                                DgnEditor.this.editor.setSelectionStart(caretInitial + 1);
                                DgnEditor.this.editor.setSelectionEnd(caretFinal + 1);
                                DgnEditor.this.setTipStatus(true);
                                DgnEditor.this.editor.getDocument().addDocumentListener(listener);
                            }
                        });
                    }
                }
            }
        }

        private String currWord() {
            String cw = "";
            int caretPosition = DgnEditor.this.editor.getCaretPosition();
            if (caretPosition >= 0) {
                String text = DgnEditor.this.editor.getText();
                try {
                    int i = caretPosition;
                    while (i >= 0) {
                        char c = text.charAt(i);
                        if (c == ' ' || c == '\n') break;
                        if (!Character.isLetter(c)) {
                            cw = "";
                            break;
                        }
                        cw = String.valueOf(Character.toString(c)) + cw;
                        --i;
                    }
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
            return cw;
        }
    }
}

