#include <stdio.h>
#include <stdlib.h>
#include <windows.h>
#include <ddraw.h>
#include "globals.h"

#define	WIN32_LEAN_AND_MEAN

	LPDIRECTDRAW			Video_DD;
	LPDIRECTDRAWSURFACE		Video_FBuffer;
	LPDIRECTDRAWSURFACE		Video_BBuffer;	
	DDSURFACEDESC			SD;
	HRESULT					hr;	
	LPDIRECTDRAWCLIPPER		pClipper=NULL;				//only windowed mode

	HINSTANCE   hInst;
	HWND        hWnd;
	int         Exit=0;
	char		Keys[256];	
	int	table[100000*3];

	void	main (void);
	void	demo (void);


	char	font[]={
		0,0,1,0,0,
		0,1,0,1,0,
		0,1,0,1,0,
		1,0,0,0,1,
		1,0,0,0,1,
		1,1,1,1,1,
		1,0,0,0,1,
		1,0,0,0,1,

		0,1,1,0,0,
		1,0,0,1,0,
		1,0,0,1,0,
		1,1,1,0,0,
		1,1,1,0,0,
		1,0,0,1,0,
		1,0,0,1,0,
		0,1,1,0,0,

		0,1,1,1,0,
		1,0,0,0,1,
		1,0,0,0,0,
		1,0,0,0,0,
		1,0,0,0,0,
		1,0,0,0,0,
		1,0,0,0,1,
		0,1,1,1,0,

		1,1,1,1,0,
		1,0,0,0,1,
		1,0,0,0,1,
		1,0,0,0,1,
		1,0,0,0,1,
		1,0,0,0,1,
		1,0,0,0,1,
		1,1,1,1,0,

		1,1,1,1,0,
		1,0,0,0,0,
		1,0,0,0,0,
		1,0,0,0,0,
		1,1,1,0,0,
		1,0,0,0,0,
		1,0,0,0,0,
		1,1,1,1,0,

		1,1,1,1,0,
		1,0,0,0,0,
		1,0,0,0,0,
		1,0,0,0,0,
		1,1,1,0,0,
		1,0,0,0,0,
		1,0,0,0,0,
		1,0,0,0,0,

		1,1,1,1,0,
		1,0,0,0,0,
		1,0,0,0,0,
		1,0,0,0,0,
		1,0,1,1,0,
		1,0,0,0,1,
		1,0,0,0,1,
		1,1,1,1,0,

		0,0,0,0,0,
		0,0,0,0,0,
		0,0,0,0,0,
		0,0,0,0,0,
		1,1,1,1,1,
		0,0,0,0,0,
		0,0,0,0,0,
		0,0,0,0,0,

		0,1,0,1,0,
		0,1,0,1,0,
		1,1,1,1,1,
		0,1,0,1,0,
		0,1,0,1,0,
		1,1,1,1,1,
		0,1,0,1,0,
		0,1,0,1,0,


		0,0,0,1,0,
		0,0,1,1,0,
		0,0,1,1,0,
		0,1,0,1,0,
		0,0,0,1,0,
		0,0,0,1,0,
		0,0,0,1,0,
		0,0,0,1,0,

		0,0,0,0,0,
		0,0,1,1,0,
		0,1,0,0,1,
		0,0,0,0,1,
		0,0,0,1,0,
		0,0,1,0,0,
		0,1,0,0,0,
		1,1,1,1,1,

		0,1,1,1,0,
		1,0,0,0,1,
		0,0,0,0,1,
		0,0,1,1,0,
		0,0,0,0,1,
		0,0,0,0,1,
		1,0,0,0,1,
		0,1,1,1,0,

		0,0,0,1,0,
		0,0,1,0,1,
		0,0,1,0,1,
		0,1,0,0,1,
		0,1,0,0,1,
		1,1,1,1,1,
		0,0,0,1,0,
		0,0,0,1,0,

		0,1,1,1,1,
		1,0,0,0,0,
		1,0,0,0,0,
		0,1,1,0,0,
		0,0,0,1,0,
		0,0,0,1,0,
		0,0,0,1,0,
		1,1,1,0,0,

		0,0,1,1,0,
		0,1,0,0,0,
		1,0,0,0,0,
		1,0,0,0,0,
		1,1,1,1,0,
		1,0,0,0,1,
		1,0,0,0,1,
		0,1,1,1,0,

		1,1,1,1,1,
		0,0,0,0,1,
		0,0,0,1,0,
		0,0,1,0,0,
		0,0,1,0,0,
		0,1,0,0,0,
		0,1,0,0,0,
		1,0,0,0,0,

		0,1,1,1,0,
		1,0,0,0,1,
		1,0,0,0,1,
		0,1,1,1,0,
		1,0,0,0,1,
		1,0,0,0,1,
		1,0,0,0,1,
		0,1,1,1,0,

		0,1,1,1,0,
		1,0,0,0,1,
		1,0,0,0,1,
		0,1,1,1,1,
		0,0,0,0,1,
		0,0,0,0,1,
		0,0,0,0,1,
		0,0,0,0,1,

		0,1,1,1,0,
		1,0,0,1,1,
		1,0,0,1,1,
		1,0,1,0,1,
		1,0,1,0,1,
		1,0,1,0,1,
		1,1,0,0,1,
		0,1,1,1,0,
	};
long FAR PASCAL WinProc (HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam){
	
	switch(message){

	case WM_CREATE:
		break;
	case WM_KEYDOWN:
		Keys[wParam&255]=1;
		Exit=1;
		break;
	case WM_SYSCOMMAND:
		if(wParam==SC_SCREENSAVE)
			return TRUE;
		break;
	case WM_ERASEBKGND:
		return TRUE;
	/*case WM_PALETTECHANGED:		
		if ((HWND)wParam!=hWnd){			
			Video_FBuffer->SetPalette(Video_pal);
		}
		return TRUE;
		*/
	case WM_DESTROY:
		PostQuitMessage(0);
		break;
	}
	return (DefWindowProc(hWnd,message,wParam,lParam));
}



BOOL	setUpWindow(void){	
	WNDCLASS	wc;

	wc.style        =CS_HREDRAW | CS_VREDRAW;
	wc.lpfnWndProc  =WinProc;
	wc.cbClsExtra   =0;
	wc.cbWndExtra   =0;
	wc.hInstance    =hInst;
	wc.hIcon        =LoadIcon(hInst,IDI_APPLICATION);
	wc.hCursor      =0;
	wc.hbrBackground=0;
	wc.lpszMenuName =APPTITLE;
	wc.lpszClassName=APPNAME;
	
	RegisterClass(&wc);
	//hWnd=CreateWindowEx(WS_EX_TOPMOST,APPNAME,APPTITLE,WS_POPUP|WS_VISIBLE,
	//	0,0,1,1,NULL,NULL,hInst,NULL);


	if(FULLSCREEN){
		hWnd=CreateWindowEx(WS_EX_TOPMOST,APPNAME,APPTITLE,WS_POPUP,
			0,0,GetSystemMetrics(SM_CXSCREEN),GetSystemMetrics(SM_CYSCREEN),NULL,NULL,hInst,NULL);	
	} else {
		hWnd=CreateWindowEx(WS_EX_STATICEDGE,APPNAME,APPTITLE,WS_OVERLAPPEDWINDOW,
			0,0,SCREEN_WIDTH,SCREEN_HEIGHT,NULL,NULL,hInst,NULL);	
	}
  	
	if(!hWnd) return FALSE;
	ShowWindow(hWnd,SW_SHOW);
	UpdateWindow(hWnd);
	SetFocus(hWnd);
	SetActiveWindow(hWnd);
	SetForegroundWindow(hWnd);
	
	//if(FULLSCREEN)
	//	ShowCursor(FALSE);

	return TRUE;
}

int	ddrawInit(){
	DDSURFACEDESC	DDSd;
	DDPIXELFORMAT	ddPixelFormat;

	hr=DirectDrawCreate(NULL,&Video_DD,NULL);
	if(hr!=DD_OK) return FALSE;

	if(FULLSCREEN){
	
		hr=IDirectDraw_SetCooperativeLevel(Video_DD,hWnd,DDSCL_FULLSCREEN|DDSCL_EXCLUSIVE);		
		if(hr!=DD_OK) return FALSE;
		hr=IDirectDraw_SetDisplayMode(Video_DD,SCREEN_WIDTH,SCREEN_HEIGHT,SCREEN_BPP);
		if(hr!=DD_OK) return FALSE;
	
	} else {

		hr=IDirectDraw_SetCooperativeLevel(Video_DD,NULL,DDSCL_NORMAL);
		if(hr!=DD_OK) return FALSE;		

	}


	memset((void *)&DDSd,0,sizeof(DDSd));
	DDSd.dwSize=sizeof(DDSd);	
	DDSd.dwFlags=DDSD_CAPS;
	DDSd.ddsCaps.dwCaps=DDSCAPS_PRIMARYSURFACE;

	hr=IDirectDraw_CreateSurface(Video_DD,&DDSd,&Video_FBuffer,NULL);
	if(hr!=DD_OK) return FALSE;

	hr=IDirectDraw_CreateClipper(Video_DD,0,&pClipper,NULL);
	if(hr!=DD_OK) return FALSE;

	hr=IDirectDrawClipper_SetHWnd(pClipper,0,hWnd);
	if(hr!=DD_OK) return FALSE;

	hr=IDirectDrawSurface3_SetClipper(Video_FBuffer,pClipper);
	if(hr!=DD_OK) return FALSE;
	

	memset((void *)&DDSd,0,sizeof(DDSd));
	DDSd.dwSize=sizeof(DDSd);	
	DDSd.dwFlags=DDSD_CAPS | DDSD_HEIGHT | DDSD_WIDTH;
	DDSd.ddsCaps.dwCaps=DDSCAPS_OFFSCREENPLAIN;
	DDSd.dwHeight=SCREEN_HEIGHT;
	DDSd.dwWidth=SCREEN_WIDTH;

	hr=IDirectDraw_CreateSurface(Video_DD,&DDSd,&Video_BBuffer,NULL);
	if(hr!=DD_OK) return FALSE;

	

	ddPixelFormat.dwSize=sizeof(DDPIXELFORMAT);

	hr=IDirectDrawSurface3_GetPixelFormat(Video_BBuffer,&ddPixelFormat);
	if(hr!=DD_OK) return FALSE;

	if(((ddPixelFormat.dwFlags & DDPF_RGB)==0) ||
	   (ddPixelFormat.dwRGBBitCount != 15 &&
		ddPixelFormat.dwRGBBitCount != 16 &&
		ddPixelFormat.dwRGBBitCount != 24 &&
		ddPixelFormat.dwRGBBitCount != 32)){
		return FALSE;
	}
	return TRUE;
}


int chkDDerror(int hr){
	if(hr!=DD_OK) {
		switch(hr){
			case DDERR_INCOMPATIBLEPRIMARY:
				MessageBox(hWnd,"CreateSurface","Incompatible Primary",MB_OK);
				break;
			case DDERR_INVALIDCAPS:
				MessageBox(hWnd,"CreateSurface","Invalid CAPS",MB_OK);
				break;
			case DDERR_INVALIDOBJECT: 
				MessageBox(hWnd,"CreateSurface","Invalid Object",MB_OK);
				break;
			case DDERR_INVALIDPARAMS:
				MessageBox(hWnd,"CreateSurface","Invalid Params",MB_OK);
				break;
			case DDERR_INVALIDPIXELFORMAT:
				MessageBox(hWnd,"CreateSurface","Invalid Pixel Format",MB_OK);
				break;
			case DDERR_NOALPHAHW:
				MessageBox(hWnd,"CreateSurface","No Alpha Hardware",MB_OK);
				break;
			case DDERR_NOCOOPERATIVELEVELSET:
				MessageBox(hWnd,"CreateSurface","No Cooperative Level Set",MB_OK);
				break;
			case DDERR_NODIRECTDRAWHW:
				MessageBox(hWnd,"CreateSurface","No Direct Draw Hardware",MB_OK);
				break;
			case DDERR_NOEMULATION:
				MessageBox(hWnd,"CreateSurface","No Emulation",MB_OK);
				break;
			case DDERR_NOEXCLUSIVEMODE:
				MessageBox(hWnd,"CreateSurface","No Exclusive mode",MB_OK);
				break;
			case DDERR_NOFLIPHW:
				MessageBox(hWnd,"CreateSurface","No Flip Hardware",MB_OK);
				break;
			case DDERR_NOMIPMAPHW:
				MessageBox(hWnd,"CreateSurface","No MIPMAP Hardware",MB_OK);
				break;
			case DDERR_NOOVERLAYHW: 
				MessageBox(hWnd,"CreateSurface","No Overlay Hardware",MB_OK);
				break;
			case DDERR_NOZBUFFERHW: 
				MessageBox(hWnd,"CreateSurface","No ZBuffer Hardware",MB_OK);
				break;
			case DDERR_OUTOFMEMORY:
				MessageBox(hWnd,"CreateSurface","Out of Memory",MB_OK);
				break;
			case DDERR_OUTOFVIDEOMEMORY:
				MessageBox(hWnd,"CreateSurface","Out of Video Memory",MB_OK);
				break;
			case DDERR_PRIMARYSURFACEALREADYEXISTS:
				MessageBox(hWnd,"CreateSurface","Primary Surface Already Exists",MB_OK);
				break;
			case DDERR_UNSUPPORTEDMODE:
				MessageBox(hWnd,"CreateSurface","Unsuported Mode",MB_OK);
				break;
		}		
		return FALSE;
	}
}









void	getMsg(){
	MSG	msg;

	memset(Keys,0,256);
	if(PeekMessage(&msg,hWnd,0,0,PM_REMOVE)){
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
}

void	ddrawClose(){
	if(Video_DD!=NULL){
		if(Video_FBuffer!=NULL){
			IDirectDrawSurface_Release(Video_FBuffer);
			Video_FBuffer=NULL;
		}
	}
	IDirectDrawSurface_Release(Video_DD);
	Video_DD=NULL;
}

void	videoFlip(){
	RECT rcRectSrc;
	RECT rcRectDest;
	POINT p;

	p.x=0;
	p.y=0;
	ClientToScreen(hWnd, &p);

    GetClientRect(hWnd, &rcRectDest);
	
	OffsetRect(&rcRectDest,p.x,p.y);

    SetRect(&rcRectSrc,0,0,SCREEN_WIDTH,SCREEN_HEIGHT);

	IDirectDrawSurface_Blt(Video_FBuffer,&rcRectDest,Video_BBuffer,&rcRectSrc,DDBLT_WAIT,NULL);
}


int PASCAL WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpCmdLine,int nCmdShow){
	hInst=hInstance;
	if(!setUpWindow()){
		MessageBox (hWnd, "No s'ha pogut crear la finestra", "Error d'inicialitzaci", MB_OK);
	}
	if(!ddrawInit()){
		MessageBox (hWnd, "No s'ha pogut crear l'objecte DDraw", "Error d'inicialitzaci", MB_OK);
	}

	main();
	ddrawClose();
	return TRUE;
}


void	main(){	
	demo();
}



void	drawChar(int x,int y,int n,int *dst,int pitch){
	int	i,j;
	char	col;

	for(i=0;i<8;i++){
		for(j=0;j<5;j++){
			col=font[n*8*5+i*5+j];
			if(col) {
				dst[(i+y)*pitch/2+(x+j)*2]=0xffffff;
				dst[(i+y)*pitch/2+(x+j)*2+1]=0xffffff;
				dst[(i+y)*pitch/2+(x+j)*2+pitch/4]=0xffffff;
				dst[(i+y)*pitch/2+(x+j)*2+pitch/4+1]=0xffffff;
			}
		}
	}
}	

void	drawCharone(int x,int y,int n,int *dst,int pitch){
	int	i,j;
	char	col;

	for(i=0;i<8;i++){
		for(j=0;j<5;j++){
			col=font[n*8*5+i*5+j];
			if(col) {
				dst[(i+y)*pitch/4+(x+j)]=0xffffff;
			}
		}
	}
}	


void	drawLlum(int x,int y,int rad,int col,int *dst,int pitch){
	int	i,j;
	int	c1,c2;
	int	r1,g1,b1;
	int	r2,g2,b2;
	int	r3,g3,b3;
	int	dist;
	int	pos;
	int	radu;
	int	idist;

	radu=rad*rad;

	r2=col&0xff;
	g2=(col>>8)&0xff;
	b2=(col>>16)&0xff;
				
	r2*=rad*2;
	g2*=rad*2;
	b2*=rad*2;

	for(i=-rad;i<rad;i++){
		pos=(i+y)*pitch/4+x;
		for(j=-rad;j<rad;j++){
			dist=(i*i+j*j)+1;
			if(dist<radu){
				idist=65536 / (dist);
				c1=dst[pos+j];
				r1=c1&0xff;
				g1=(c1>>8)&0xff;
				b1=(c1>>16)&0xff;

				r3=(r2*idist)>>16;
				g3=(g2*idist)>>16;
				b3=(b2*idist)>>16;

				r1+=r3;
				g1+=g3;
				b1+=b3;

				if(r1>255) r1=255;
				if(g1>255) g1=255;
				if(b1>255) b1=255;
				dst[pos+j]=r1 + (g1<<8) + (b1<<16);
			}
		}
	}

}

void	demo(){
	int	i,j,k,n,pitch;
	int	*dst;
	static int despl=0;
	static int finc=3;
	static float angle=0.f;

/*
	for(j=0;j<10;j++){
		angles[j]=(float) ((float)rand()/(float)RAND_MAX)*2*3.14159265;
		velan[j]=(float) ((float)rand()/(float)RAND_MAX);
		rads[j]=10; //rand()%30+10;
		cols[j]=0xffffffff;
	}
*/

	j=0;
	for(i=0;i<100000;i++){
		k=rand()%28;
		if(k<8){
			table[j++]=k;
			table[j++]=rand()%2+7;
			table[j++]=rand()%10+9;
		}
		else {
			table[j++]=7;
			table[j++]=7;
			table[j++]=7;
		}
		
	}

	while(!Exit){
		SD.dwSize=sizeof(DDSURFACEDESC);
		hr=IDirectDrawSurface_Lock(Video_BBuffer,NULL,&SD,DDLOCK_WAIT,NULL);
		if(hr==DDERR_SURFACELOST) {MessageBox(NULL,"Surface lost!!","Surface lost!!",MB_OK);Exit=1;}
		
		pitch=SD.lPitch;
		dst=(char *)SD.lpSurface;
		
		for(i=0;i<640*480;i++) dst[i]=0x303060;

		for(j=0;j<20;j++){
			for(i=0;i<640;i++) dst[i+(j+224)*pitch/4]=0x6060A0;
		}


		j=0;
		for(k=0;k<8;k++){
			for(i=0;i<19;i++){
				drawChar(10+40*k,i*12+5,table[despl+j++],dst,pitch);
				drawChar(18+40*k,i*12+5,table[despl+j++],dst,pitch);
				n=table[despl+j++];
				drawChar(26+40*k,i*12+5,n,dst,pitch);
				drawCharone(70+80*k,i*12*2+10,n,dst,pitch);
				drawCharone(76+80*k,i*12*2+10,n,dst,pitch);
			}
		}

		drawLlum(200*sin(angle)+320,180*cos(angle)*sin(angle*0.234f)+240,50,0xffffff,dst,pitch);
		drawLlum(250*cos(angle/2)+320,150*sin(angle*0.234f)+240,30,0x2580ff,dst,pitch);
		drawLlum(100*cos(angle*0.83)*sin(angle*0.47)+420,120*cos(angle*0.34f)+240,60,0xff8030,dst,pitch);
		drawLlum(100*cos(-angle*0.83)*sin(-angle*0.47)+420,120*cos(angle*0.34f)+240,60,0x80ff30,dst,pitch);

		finc--;
		if(!finc){
			despl+=3;
			finc=3;
		}
		if(despl>50000) despl=0;

		
		angle+=0.08f;

		hr=IDirectDrawSurface_Unlock(Video_BBuffer,NULL);
		if(hr==DDERR_SURFACELOST) {MessageBox(NULL,"Surface lost!!","Surface lost!!",MB_OK);Exit=1;}

		videoFlip();		
		getMsg();
	}
}