unit smirnovMainUnit;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, AppEvnts, jpeg, StdCtrls, mmsystem, MPlayer;

type
  TMainForm = class(TForm)
    ApplicationEvents1: TApplicationEvents;
    Timer1: TTimer;
    Label1: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;
  Fullscreen: Boolean;

  //bmpLeaveYellow: TBitmap;
  //bmpLeaveRed: Bitmap;
  //bmpLeaveGreen: TBitmap;

  images: array [1..100] of TImage;
  tags: array [1..100] of integer;
  ix: array [1..100] of real;
  iy: array [1..100] of real;

  image: TImage;

  time: real;
  mode: integer;




implementation

{$R *.dfm}

procedure TMainForm.FormCreate(Sender: TObject);
var
  i, n: Integer;
begin

  sndPlaySound( '1.wav', SND_ASYNC );
  
  FullScreen := True;
  mode := 0;
  time := 0;

  if (Fullscreen = True) then
  begin


    Top := 0;
    Left := 0;
    Height := 480;
    Width := 640;
    BorderStyle := bsNone;
    FormStyle := fsStayOnTop;
  end;

  Color := clBlack;

  Randomize();

  for i:=1 to 50 do
  begin

    images[i] := TImage.Create( MainForm );
    images[i].Parent := MainForm;
    images[i].Stretch := True;
    images[i].Transparent := True;

    n := Random(3);
    if( n = 0 ) then images[i].Picture.LoadFromFile( 'leaveGreen.bmp' );
    if( n = 1 ) then images[i].Picture.LoadFromFile( 'leaveYellow.bmp' );
    if( n = 2 ) then images[i].Picture.LoadFromFile( 'leaveRed.bmp' );

    iy[i] := -Random(400) - 400;
    ix[i] := -Random(200);

    tags[i] := 30 + Random(80);

  end;







  
end;

procedure TMainForm.FormDestroy(Sender: TObject);
var
  i: integer;
begin

  for i:=1 to 100 do
  begin
    if ( images[i] <> NIL ) then images[i].Destroy;
  end;

  if ( image <> NIL ) then image.Destroy;

end;

procedure TMainForm.Timer1Timer(Sender: TObject);

var
  i: integer;
  rect: TRect;
begin

  if( mode = 0 ) then
  begin
    Label1.Font.Color := clWhite;
    Label1.BringToFront;


    if( time > 3000 ) then
    begin
      mode := 255;
    end;


    
    for i:=1 to 50 do
    begin

      iy[i] := iy[i] + 1 + i/10;
      ix[i] := ix[i] - Random(3) + i/10;

      images[i].Height := Abs( Round( tags[i] * sin( i + time/40 ) ) );
      images[i].Width := Abs( Round( tags[i] * cos( i + time/30 ) ) );

      images[i].Top := Round( iy[i] - images[i].Height/2 );
      images[i].Left := Round( ix[i] - images[i].Width/2 );

      if( iy[i] > 480 ) then
      begin
        iy[i] := -100;
        ix[i] := Random(300);
        tags[i] := 30 + Random(80);
      end;


    end;

    time := time + 1;

  end;

  
  if( mode = 2 ) then
  begin



  end;

  if( mode = 255 ) then
  begin
    Close();
  end;
  
end;


end.
