//--------------------------------------------------------------------------------------
// Global variables
//--------------------------------------------------------------------------------------
float4x4 matViewProjection;
const float off = 1.0 / 512.0;
texture glowTexture;


sampler GlowSampler = sampler_state
{
   texture = (glowTexture);
   MIPFILTER = LINEAR;
   MINFILTER = LINEAR;
   MAGFILTER = LINEAR;
};



//--------------------------------------------------------------------------------------
// Vertex shader output structure
//--------------------------------------------------------------------------------------
struct VS_OUTPUT 
{
   float4 Position : POSITION0;
   float2 Tex0     : TEXCOORD0;
};



VS_OUTPUT VS_Normal(float4 Position: POSITION, float2 Tex0 : TEXCOORD0)
{
   VS_OUTPUT Output = (VS_OUTPUT) 0;
   
   Output.Position = mul(matViewProjection,Position);
   Output.Tex0 = Tex0;

   return Output;
}



float4 PS_EdgeDetection( float2 TexCoord : TEXCOORD0 ) : COLOR0
{
   float4 col = tex2D(GlowSampler, TexCoord);

   float s00 = tex2D(GlowSampler, TexCoord + float2(-off, -off));  
   float s01 = tex2D(GlowSampler, TexCoord + float2( 0, -off));
   float s02 = tex2D(GlowSampler, TexCoord + float2( off, -off));
   float s10 = tex2D(GlowSampler, TexCoord + float2(-off, 0));
   float s12 = tex2D(GlowSampler, TexCoord + float2( off, 0));
   float s20 = tex2D(GlowSampler, TexCoord + float2(-off, off));
   float s21 = tex2D(GlowSampler, TexCoord + float2( 0, off));
   float s22 = tex2D(GlowSampler, TexCoord + float2( off, off));

   float sobelX = s00 + 2 * s10 + s20 - s02 - 2 * s12 - s22;
   float sobelY = s00 + 2 * s01 + s02 - s20 - 2 * s21 - s22;

   float edgeSqr = (sobelX * sobelX + sobelY * sobelY);
   
   col.r = (edgeSqr > (0.02 * 0.01));
   col.g = (edgeSqr > (0.04 * 0.03));
   col.b = (edgeSqr > (0.06 * 0.05));
   col.a = 1.0f;

   //return 1.0f - (edgeSqr > (0.07 * 0.07));

   return col;
}



technique RenderScene1
{
    pass P0
    {          
        VertexShader = compile vs_2_0 VS_Normal();
        PixelShader  = compile ps_2_0 PS_EdgeDetection();
    }
}
