//
// dont change unless you know what u doing!
// no will to clean up.. be free to fuck around
//

float4x4 		World	: WORLD;
float4x4 		View	: VIEW;
float4x4 		Proj	: PROJECTION;
float4x4		WVP		: WORLDVIEWPROJ;				// world * view * projection matrix
float4x4		worldIT	: WORLDINVERSETRANSPOSE;

float			fA;
float			fTime;
float			fBassValue;
float			fPitchValue;
float			fPingValue;


float4			eyeVec;			// camera eye
float4			mLightPos; // Light position array
float4			mLightColor = float4( 0.9, 0.85, 0.8, 1 ); // Light color array
int				mNumLights = 1;


float4 materialSpecular : Specular = { 1.0f, 1.0f, 1.0f, 1.0f };
float shininess : SpecularPower = 64;


//float attenuation1 = 1;
//float attenuation2 = 1;
//float attenuation3 = 1;



// simple app output
struct SIMPLE_APP_OUTPUT
{
	float3 position	: POSITION;
	float4 diffuse	: COLOR0;
	float2 texcoord0: TEXCOORD0;
};

struct SIMPLE_VS_OUTPUT
{
	float4 position		: POSITION;   // vertex position 
	float4 diffuse		: COLOR0;     // vertex diffuse color
	float2 texcoord0	: TEXCOORD0;  // uv maps
};



// app output
struct APP_OUTPUT
{
	float3 position	: POSITION;
	float3 normal	: NORMAL;
	float4 tangent  : TEXCOORD1;			// defined in vertex type (t = texcoord1, b = texcoord2)
	float4 diffuse	: COLOR0;
	float2 texcoord0: TEXCOORD0;
};

// Vertex shader output structure
struct VS_OUTPUT
{
	float4 position		: POSITION;   // vertex position 
	float4 diffuse		: COLOR0;     // vertex diffuse color
	float2 texcoord0	: TEXCOORD0;
	float3 view			: TEXCOORD1;
	float  tangentW		: TEXCOORD2;
	float4 light[1]		: TEXCOORD3;	// xyz is light position, w is distance between light and vertex in world space
};


VS_OUTPUT MainVS( APP_OUTPUT IN )
{
	VS_OUTPUT Output;

	float4 tempPos = float4( IN.position, 1.0 );
	
	// Do bulge effect (displace vectors)
	float3 dispDir = float3( IN.normal.x, IN.normal.y, IN.normal.z );
	//float dispValue = 9.08 * sin(IN.normal.z + fTime * 3);		// wobble.. nice!
//	float dispValue = fPitchValue*6 * sin(IN.normal.z+IN.normal.x + fTime * 2);

	float dispValue = fPitchValue * 12 * sin(0.025*tempPos.y + fTime * 0.72);

	// Displace vertex by some value
	tempPos.x += dispDir.x * dispValue;


	// transform position to clip space 
	Output.position = mul( tempPos, WVP );
	
	// pass on diffuse and tex coords
	Output.diffuse = IN.diffuse;
	Output.texcoord0 = IN.texcoord0 * 2;

	Output.tangentW = IN.tangent.w;
	float3 binormal = cross(IN.tangent, IN.normal);
//	float3 binormal = IN.tangent.w * cross(IN.tangent, IN.normal);
	
    // compute the 3x3 tranform matrix 
    // to transform from world space to tangent space
    
    float3 Tangent = mul( IN.tangent, worldIT );
    float3 Binormal = mul( binormal, worldIT );
    float3 Normal = mul( IN.normal, worldIT );

    float3x3 worldToTangentSpace;
	worldToTangentSpace[0] = float3( Tangent.x, Binormal.x, Normal.x );
	worldToTangentSpace[1] = float3( Tangent.y, Binormal.y, Normal.y );
	worldToTangentSpace[2] = float3( Tangent.z, Binormal.z, Normal.z );
    //float3x3 tangentToWorldSpace;
	//tangentToWorldSpace[0] = ( mul( IN.tangent, worldIT ) );
	//tangentToWorldSpace[1] = ( mul( binormal, worldIT ) );
	//tangentToWorldSpace[2] = ( mul( IN.normal, worldIT ) );
	//worldToTangentSpace = transpose( tangentToWorldSpace );
 	

	// position in world coodinates
	float3 worldpos = mul( IN.position, worldIT );
	
//	float3 ViewDir = View[3].xyz - worldpos;
	float3 ViewDir = eyeVec.xyz - worldpos;
	float3 ViewDirTS = normalize(mul(ViewDir, worldToTangentSpace));
	Output.view = ViewDirTS;


	float3 CurrLight;
	int i = 0;
	//for( int i=0; i<mNumLights; i++ )
	{
		CurrLight = mLightPos - worldpos;
		
		Output.light[i].xyz = (mul(CurrLight, worldToTangentSpace));

		//calculate the attenuation
		Output.light[i].w = (1/(1+( 0.005 * length(CurrLight))));
		
	}
	
	return Output;
}



// Pixel shader output structure
struct PS_OUTPUT
{
    float4 color : COLOR0;  // Pixel color    
};


texture g_BaseTexture;
sampler2D BaseTextureSampler : TEXUNIT0 = sampler_state
 {
       Texture = (g_BaseTexture);
       MIPFILTER = LINEAR;
       MAGFILTER = LINEAR;
       MINFILTER = LINEAR;
 };

texture g_BumpTexture;
sampler2D BumpTextureSampler : TEXUNIT1 = sampler_state
{
        Texture = (g_BumpTexture);
        MIPFILTER = LINEAR;
        MAGFILTER = LINEAR;
        MINFILTER = LINEAR;
};

	
PS_OUTPUT MainPS( VS_OUTPUT IN ) 
{ 
	PS_OUTPUT Output;
	float fBumpScale = 0.05;
	float sfHeightBias = -0.02;

	// eye vector
	float3 E = ( IN.view );

	// offset mapping
	// heightmap is stored in normalmap in the alpha channel
	float CurrHeight = tex2D(BumpTextureSampler, IN.texcoord0).a;
	float fHeight = CurrHeight * fBumpScale + sfHeightBias;
	float2 newTexCoord = (E * fHeight) + IN.texcoord0;

	float4 diffTexture = tex2D( BaseTextureSampler, newTexCoord );
	float3 bumpNormal = (2.0 * tex2D(BumpTextureSampler, newTexCoord).xyz - 1.0);
	bumpNormal = normalize( bumpNormal );

	// heights are set in alpha channel of normal map. this is our gloss map
	float gloss = CurrHeight;

	// Diffuse color
	float4 vDiffuseColor = diffTexture;

	// Hack up an ambient term/color.
	float fAmbientScale = 0.1;
	float4 vAmbientColor = vDiffuseColor * fAmbientScale;

	// Output color starts with ambient component	
	float4 tmpColor = vAmbientColor;

	// Loop thru light array
	int i = 0;
	//for( int i=0; i<1; i++ )
	{
		// light. only XYZ. W is used to store length of vector from light to vertex in world space
		float3 L = normalize( IN.light[i].xyz );

		// Half vector
		float3 H = normalize( E + L );

		// Compute diff term
		float diff = (dot( bumpNormal, L ) );

		// self shadowing term
		float Shadow = 4.0f * L.z;

		// attenuation
		float attenuation = IN.light[i].w;

		// specular term
		float spec = pow( dot(bumpNormal, H), shininess) * gloss;
		if( diff < 0.0 )
			spec = 0.0;

		float4 vSpecularColor = materialSpecular * spec;

		tmpColor += mLightColor * ((vDiffuseColor * diff) + vSpecularColor);// * attenuation;
		//tmpColor += mLightColor * Shadow * ((vDiffuseColor * diff) + vSpecularColor) * attenuation;
	}

	// hack the alpha channel
	tmpColor.a = fA;

	Output.color = tmpColor; 

	return Output;
}


PS_OUTPUT MainBlackPS( VS_OUTPUT IN ) 
{ 
	PS_OUTPUT Output;
	float4 tmpColor;

	tmpColor.rgb = 0;
	
	// hack the alpha channel
	tmpColor.a = fA;

	Output.color = tmpColor; 

	return Output;
}



//-----------------------------------------------------------------------------
// Simple Effect (1 technique with 1 pass)
//-----------------------------------------------------------------------------

technique TechniqueParallaxMapping
{
    pass Pass0
    {
		ZEnable			= true;
		ZWriteEnable	= true;
		Lighting		= false;
		FogEnable		= false;
		CullMode		= CW;
		AlphaBlendEnable= true;
		SrcBlend		= SRCALPHA;
		DestBlend		= INVSRCALPHA;

		VertexShader = compile vs_2_0 MainVS( );
		PixelShader  = compile ps_2_0 MainPS( );
    }
}

technique TechniqueBMappingBlend
{
    pass Pass0
    {
		ZEnable			= true;
		ZWriteEnable	= true;
		CullMode		= CW;
		AlphaBlendEnable= true;
		SrcBlend		= SRCALPHA;
		DestBlend		= ONE;

		VertexShader = compile vs_2_0 MainVS( );
		PixelShader  = compile ps_2_0 MainPS( );
    }
}

technique TechniqueBlack
{
    pass Pass0
    {
		ZEnable			= true;
		ZWriteEnable	= true;
		CullMode		= CW;
		AlphaBlendEnable= true;
		SrcBlend		= SRCALPHA;
		DestBlend		= ONE;

		VertexShader = compile vs_2_0 MainVS( );
		PixelShader  = compile ps_2_0 MainBlackPS( );
    }
}