//
// dont change unless you know what u doing!
//

matrix	World	: WORLD;
matrix	View	: VIEW;
matrix	Proj	: PROJECTION;
matrix	WVP	: WORLDVIEWPROJECTION;
float	P_size;
float4	K_diffuse;
float	fA;


texture g_BaseTexture;
sampler2D BaseTextureSampler = sampler_state
 {
       Texture = (g_BaseTexture);
       MIPFILTER = LINEAR;
       MAGFILTER = LINEAR;
       MINFILTER = LINEAR;
 };
	
 
 
struct OutputVS
{
    float4 pos          : POSITION;
    float2 tex          : TEXCOORD; 
    float4 diffuse      : COLOR;
};

struct OutputPS
{
	float4 color		: COLOR;
};

OutputVS ParticleVS(in float4 pos      : POSITION, 
                    in float2 tex      : TEXCOORD )
{
      OutputVS outVS = (OutputVS)0;


	outVS.pos = pos * P_size;                         // scale
	outVS.pos = mul(outVS.pos, transpose(View));
	outVS.pos.w = 1;

//	outVS.pos = mul(outVS.pos, WVP);
	outVS.pos = mul(outVS.pos, World);              // 
	outVS.pos = mul(outVS.pos, View);               // 
	outVS.pos = mul(outVS.pos, Proj);            	// w * v * p
	outVS.tex = tex;

	outVS.diffuse = K_diffuse;
 
	return outVS;
}
 
OutputPS ParticlePS( OutputVS IN )
{
    OutputPS outPS = (OutputPS)0;
 
 
	float4 tex = tex2D( BaseTextureSampler, IN.tex ) * IN.diffuse;
//	tex.a = fA;
//	outPS.color = tex;
  
	outPS.color = tex * IN.diffuse;
      
	return outPS;
}


technique ParticleTechnique
{
      pass P0
      {
            ZWriteEnable            = FALSE;
            CullMode				= NONE;
            AlphaBlendEnable        = TRUE;
            SrcBlend                = SRCALPHA;
            DestBlend               = INVSRCALPHA;

            VertexShader            = compile vs_1_1 ParticleVS();
            PixelShader				= compile ps_1_1 ParticlePS();
      }
}
