/*
 * Decompiled with CFR 0.152.
 */
package krister.Ess;

import java.lang.reflect.Method;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import krister.Ess.AudioOutput;
import krister.Ess.Ess;

public final class AudioStream
extends AudioOutput {
    private PlayThread playThread;
    private Method audioStreamWriteMethod;
    private AudioStream thisStream;
    static /* synthetic */ Class class$javax$sound$sampled$SourceDataLine;
    static /* synthetic */ Class class$krister$Ess$AudioStream;
    static /* synthetic */ Class class$krister$Ess$AudioOutput;

    public AudioStream() {
        this.setup(Ess.DEFAULT_BUFFER_SIZE, 44100.0f);
    }

    public AudioStream(int n) {
        this.setup(n, 44100.0f);
    }

    public AudioStream(int n, float f) {
        this.setup(n, f);
    }

    public void destroy() {
        if (this.audioOutputFadeED != null) {
            this.audioOutputFadeED.kill = true;
        }
        if (this.audioOutputPanED != null) {
            this.audioOutputPanED.kill = true;
        }
        this.stopSound();
        this.audioOutputFadeED = null;
        this.audioOutputPanED = null;
        this.playThread = null;
        this.fadeThread = null;
        this.panThread = null;
        this.line.stop();
        this.line.close();
        Ess.unregisterAudioStream(this);
    }

    public void sampleRate(float f) {
        this.stopSound();
        this.line.stop();
        this.line.close();
        this.setupLine(this.buffer.length, f);
    }

    public void bufferSize(int n) {
        this.stopSound();
        this.line.stop();
        this.line.close();
        this.setupLine(n, this.rSampleRate);
    }

    public void start() {
        if (this.rState != 2) {
            int n;
            for (n = 0; n < this.buffer.length; ++n) {
                this.buffer[n] = 0.0f;
            }
            for (n = 0; n < this.buffer2.length; ++n) {
                this.buffer2[n] = 0.0f;
            }
            new Thread(Ess.tg, this.playThread).start();
        }
    }

    public void stop() {
        this.stopSound();
    }

    private void setupLine(int n, float f) {
        this.sampleRate = this.rSampleRate = f;
        this.format = new AudioFormat(this.rSampleRate, 16, 2, true, true);
        this.info = new DataLine.Info(class$javax$sound$sampled$SourceDataLine == null ? (class$javax$sound$sampled$SourceDataLine = AudioStream.class$("javax.sound.sampled.SourceDataLine")) : class$javax$sound$sampled$SourceDataLine, this.format);
        try {
            this.line = (SourceDataLine)Ess.outputMixer.getLine(this.info);
            this.buffer = new float[n];
            this.buffer2 = new float[n * 2];
            this.duration = this.ms(n);
            this.size = n;
            this.zeroBuffer = new byte[n * 4];
            this.stereoBuffer = new byte[n * 4];
            this.line.open(this.format, n * 2);
            this.line.start();
        }
        catch (LineUnavailableException lineUnavailableException) {
            lineUnavailableException.printStackTrace();
        }
    }

    private void stopSound() {
        if (this.rState == 2) {
            this.playThread.stop();
            if (this.line != null) {
                this.line.flush();
            }
        }
    }

    private void setup(int n, float f) {
        Method method;
        this.playThread = new PlayThread();
        this.fadeThread = new AudioOutput.FadeThread();
        this.panThread = new AudioOutput.PanThread();
        this.updateBuffer2 = true;
        this.softClip = false;
        this.smoothPan = false;
        this.rState = 1;
        this.state = 1;
        this.setupLine(n, f);
        this.volume(1.0f);
        this.pan(0.0f);
        this.mute(false);
        Ess.registerAudioStream(this);
        try {
            this.audioStreamWriteMethod = Ess.parent.getClass().getMethod("audioStreamWrite", class$krister$Ess$AudioStream == null ? (class$krister$Ess$AudioStream = AudioStream.class$("krister.Ess.AudioStream")) : class$krister$Ess$AudioStream);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            method = Ess.parent.getClass().getMethod("audioOutputFade", class$krister$Ess$AudioOutput == null ? (class$krister$Ess$AudioOutput = AudioStream.class$("krister.Ess.AudioOutput")) : class$krister$Ess$AudioOutput);
            this.audioOutputFadeED = new AudioOutput.EventDispatcher(method, this);
            new Thread(Ess.tg, this.audioOutputFadeED).start();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            method = Ess.parent.getClass().getMethod("audioOutputPan", class$krister$Ess$AudioOutput == null ? (class$krister$Ess$AudioOutput = AudioStream.class$("krister.Ess.AudioOutput")) : class$krister$Ess$AudioOutput);
            this.audioOutputPanED = new AudioOutput.EventDispatcher(method, this);
            new Thread(Ess.tg, this.audioOutputPanED).start();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.thisStream = this;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final class PlayThread
    implements Runnable {
        public boolean kill;

        private PlayThread() {
        }

        public void run() {
            float f = AudioStream.this.rPan;
            this.kill = false;
            AudioStream.this.rState = 2;
            AudioStream.this.state = 2;
            while (!this.kill) {
                int n = AudioStream.this.buffer.length;
                if (!Ess.getMasterMute() && !AudioStream.this.rMute) {
                    float f2;
                    int n2;
                    float f3;
                    float f4;
                    float f5 = AudioStream.this.rVolume * Ess.getMasterVolume();
                    int n3 = 0;
                    if (f == AudioStream.this.rPan || !AudioStream.this.smoothPan) {
                        f = AudioStream.this.rPan;
                        f4 = (f + 1.0f) / 2.0f;
                        f3 = 1.0f - f4;
                        for (n2 = 0; n2 < n; ++n2) {
                            f2 = AudioStream.this.buffer[n2] * f5;
                            if (AudioStream.this.softClip) {
                                f2 = AudioOutput.softClip(f2);
                            }
                            Ess.setFrame(AudioStream.this.stereoBuffer, n3++, (int)((f2 *= 32767.0f) * f3));
                            Ess.setFrame(AudioStream.this.stereoBuffer, n3++, (int)(f2 * f4));
                        }
                    } else {
                        f4 = (f + 1.0f) / 2.0f;
                        f3 = 1.0f - f4;
                        for (n2 = 0; n2 < n; ++n2) {
                            f2 = AudioStream.this.buffer[n2] * f5;
                            if (AudioStream.this.softClip) {
                                f2 = AudioOutput.softClip(f2);
                            }
                            if ((int)(f2 *= 32767.0f) == 0) {
                                f = AudioStream.this.rPan;
                                f4 = (AudioStream.this.rPan + 1.0f) / 2.0f;
                                f3 = 1.0f - f4;
                            }
                            Ess.setFrame(AudioStream.this.stereoBuffer, n3++, (int)(f2 * f3));
                            Ess.setFrame(AudioStream.this.stereoBuffer, n3++, (int)(f2 * f4));
                        }
                    }
                    AudioStream.this.line.write(AudioStream.this.stereoBuffer, 0, n * 4);
                    AudioStream.this.bufferStartTime = AudioStream.this.rBufferStartTime = Ess.parent.millis();
                } else {
                    AudioStream.this.line.write(AudioStream.this.zeroBuffer, 0, n * 4);
                    AudioStream.this.bufferStartTime = AudioStream.this.rBufferStartTime = Ess.parent.millis();
                }
                if (AudioStream.this.updateBuffer2) {
                    System.arraycopy(AudioStream.this.buffer2, AudioStream.this.buffer.length, AudioStream.this.buffer2, 0, AudioStream.this.buffer.length);
                }
                try {
                    AudioStream.this.audioStreamWriteMethod.invoke((Object)Ess.parent, AudioStream.this.thisStream);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!AudioStream.this.updateBuffer2) continue;
                System.arraycopy(AudioStream.this.buffer, 0, AudioStream.this.buffer2, AudioStream.this.buffer.length, AudioStream.this.buffer.length);
            }
            AudioStream.this.rState = 1;
            AudioStream.this.state = 1;
        }

        private void stop() {
            this.kill = true;
            while (AudioStream.this.rState != 1) {
            }
        }
    }
}

