/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.converter;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javazoom.jl.converter.Converter;
import javazoom.jl.converter.WaveFileObuffer;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.Decoder;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.JavaLayerException;
import javazoom.jl.decoder.Obuffer;

/*
 * Exception performing whole class analysis ignored.
 */
public class Converter {
    public synchronized void convert(String string, String string2) throws JavaLayerException {
        this.convert(string, string2, null, null);
    }

    public synchronized void convert(String string, String string2, ProgressListener progressListener) throws JavaLayerException {
        this.convert(string, string2, progressListener, null);
    }

    public void convert(String string, String string2, ProgressListener progressListener, Decoder.Params params) throws JavaLayerException {
        if (string2.length() == 0) {
            string2 = null;
        }
        try {
            InputStream inputStream = this.openInput(string);
            this.convert(inputStream, string2, progressListener, params);
            inputStream.close();
        }
        catch (IOException iOException) {
            throw new JavaLayerException(iOException.getLocalizedMessage(), (Throwable)iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void convert(InputStream inputStream, String string, ProgressListener progressListener, Decoder.Params params) throws JavaLayerException {
        if (progressListener == null) {
            progressListener = PrintWriterProgressListener.newStdOut((int)0);
        }
        try {
            int n;
            if (!(inputStream instanceof BufferedInputStream)) {
                inputStream = new BufferedInputStream(inputStream);
            }
            int n2 = -1;
            if (inputStream.markSupported()) {
                inputStream.mark(-1);
                n2 = this.countFrames(inputStream);
                inputStream.reset();
            }
            progressListener.converterUpdate(1, n2, 0);
            WaveFileObuffer waveFileObuffer = null;
            Decoder decoder = new Decoder(params);
            Bitstream bitstream = new Bitstream(inputStream);
            if (n2 == -1) {
                n2 = Integer.MAX_VALUE;
            }
            long l = System.currentTimeMillis();
            try {
                for (n = 0; n < n2; ++n) {
                    try {
                        Obuffer obuffer;
                        Header header = bitstream.readFrame();
                        if (header == null) {
                            break;
                        }
                        progressListener.readFrame(n, header);
                        if (waveFileObuffer == null) {
                            int n3 = header.mode() == 3 ? 1 : 2;
                            int n4 = header.frequency();
                            waveFileObuffer = new WaveFileObuffer(n3, n4, string);
                            decoder.setOutputBuffer((Obuffer)waveFileObuffer);
                        }
                        if ((obuffer = decoder.decodeFrame(header, bitstream)) != waveFileObuffer) {
                            throw new InternalError("Output buffers are different.");
                        }
                        progressListener.decodedFrame(n, header, waveFileObuffer);
                        bitstream.closeFrame();
                        continue;
                    }
                    catch (Exception exception) {
                        boolean bl;
                        boolean bl2 = bl = !progressListener.converterException((Throwable)exception);
                        if (!bl) continue;
                        throw new JavaLayerException(exception.getLocalizedMessage(), (Throwable)exception);
                    }
                }
            }
            finally {
                if (waveFileObuffer != null) {
                    waveFileObuffer.close();
                }
            }
            int n5 = (int)(System.currentTimeMillis() - l);
            progressListener.converterUpdate(2, n5, n);
        }
        catch (IOException iOException) {
            throw new JavaLayerException(iOException.getLocalizedMessage(), (Throwable)iOException);
        }
    }

    protected int countFrames(InputStream inputStream) {
        return -1;
    }

    protected InputStream openInput(String string) throws IOException {
        File file = new File(string);
        FileInputStream fileInputStream = new FileInputStream(file);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        return bufferedInputStream;
    }
}

