uniform sampler2D dispMap;

uniform float time;
uniform float a;
uniform vec3 count;
uniform vec3 phase;
uniform vec3 amount;
uniform float texSize;


#define TWOPI 6.28318531
#define PI    3.14159265

/*
// spherical harmonics
vec3 getSpherePoint( float u, float v )
{
   float m[8];
   m[0] = 1.0;
   m[1] = 3.0;
   m[2] = 6.0 + sin(time*0.5)*2.0;
   m[3] = 3.0;
   m[4] = 3.0;
   m[5] = 1.0;
   m[6] = 0.0;
   m[7] = 1.0;

   float r = 0.0;
   r += pow( sin(m[0]*u), m[1] );
   r += pow( cos(m[2]*u), m[3] );
   r += pow( sin(m[4]*v), m[5] );
   r += pow( cos(m[6]*v), m[7] );

   float x = r * sin(u) * cos(v);
   float y = r * sin(u) * sin(v);
   float z = r * cos(u);

   return vec3( a*x, a*y, a*z );
}
*/


// sphere formula
vec3 getSpherePoint( float u, float v )
{
    // 0 <= u <= PI, 0 <= v <= TWOPI

	float x = sin(u) * cos(v);// + sin(20*u+count.x) * 0.075;
	float y = sin(u) * sin(v);// + cos(10*u+count.x) * 0.075;
	float z = cos(u);

	float r = a;
	r += sin(0.25*x * count.x + time + phase.x) * amount.x;
	r += cos(u*count.y + phase.y) * amount.y;

	//r += ((sin(u * count.x + phase.x)+1)*0.5) * amount.x;
	//r += ((cos(u * count.y + phase.y)+1)*0.5) * amount.y;
	//r += RadMod;

	return vec3( x*r, y*r, z*r );
}



vec4 texture2DLod_bilinear( sampler2D texSam, vec2 uv )
{
	float texelSize = 1.0 / texSize;
	
	vec4 height00 = texture2DLod(texSam, uv, 0);
	vec4 height10 = texture2DLod(texSam, uv+vec2(texelSize, 0), 0 );
	vec4 height01 = texture2DLod(texSam, uv+vec2(0, texelSize), 0 );
	vec4 height11 = texture2DLod(texSam, uv+vec2(texelSize, texelSize), 0 );
	vec2 f = fract( uv.xy * texSize );

	vec4 tA = mix( height00, height10, f.x );
	vec4 tB = mix( height01, height11, f.x );

	return mix( tA, tB, f.y );
}


void main(void) 
{ 
	vec4 newVertexPos;
	vec4 dv;
	float df;

	gl_TexCoord[0].xy = gl_MultiTexCoord0.xy;
	
    float u = (gl_Vertex.x) * PI;
    float v = (gl_Vertex.y) * TWOPI;

	vec3 pos = getSpherePoint( u, v );

	// Compute tangents and normals
	float step = (1.0/256.0);
	vec3 neighbour1 = getSpherePoint( u+step, v );
	vec3 neighbour2 = getSpherePoint( u, v+step );
	vec3 tangent = neighbour1 - pos;
	vec3 bitangent = neighbour2 - pos;

	vec3 normal = normalize( cross( tangent, bitangent ) );

	dv = texture2DLod_bilinear( dispMap, gl_MultiTexCoord0.xy );
	//dv = texture2DLod( dispMap, gl_MultiTexCoord0.xy, 0 );
	//dv = texture2D( dispMap, gl_MultiTexCoord0.xy );
	df = 0.30*dv.x + 0.59*dv.y + 0.11*dv.z;	

	newVertexPos = vec4( pos, 1);
	newVertexPos += vec4(normal * df * 10.0, 0.0);

	//gl_Normal = normal;
	gl_Position = gl_ModelViewProjectionMatrix * newVertexPos;
}