/*
 * Decompiled with CFR 0.152.
 */
package megamu.mesh;

import megamu.mesh.LinkedArray;
import quickhull3d.QuickHull3D;

public class Delaunay {
    float[][] edges;
    LinkedArray mesh;
    int[][] links;
    int linkCount;

    public Delaunay(float[][] points) {
        if (points.length < 1) {
            this.edges = new float[0][4];
            this.mesh = new LinkedArray(0);
            this.links = new int[0][2];
            this.linkCount = 0;
            return;
        }
        double[] qPoints = new double[points.length * 3 + 9];
        int i = 0;
        while (i < points.length) {
            qPoints[i * 3] = points[i][0];
            qPoints[i * 3 + 1] = points[i][1];
            qPoints[i * 3 + 2] = -(points[i][0] * points[i][0] + points[i][1] * points[i][1]);
            ++i;
        }
        qPoints[qPoints.length - 9] = -2000.0;
        qPoints[qPoints.length - 8] = 0.0;
        qPoints[qPoints.length - 7] = -4000000.0;
        qPoints[qPoints.length - 6] = 2000.0;
        qPoints[qPoints.length - 5] = 2000.0;
        qPoints[qPoints.length - 4] = -8000000.0;
        qPoints[qPoints.length - 3] = 2000.0;
        qPoints[qPoints.length - 2] = -2000.0;
        qPoints[qPoints.length - 1] = -8000000.0;
        QuickHull3D quickHull = new QuickHull3D(qPoints);
        int[][] faces = quickHull.getFaces(9);
        this.mesh = new LinkedArray(points.length + 3);
        this.links = new int[1][2];
        this.linkCount = 0;
        int i2 = 0;
        while (i2 < faces.length) {
            int j = 0;
            while (j < faces[i2].length) {
                int p = faces[i2][j];
                int q = faces[i2][(j + 1) % faces[i2].length];
                if (p < points.length && q < points.length && !this.mesh.linked(p, q)) {
                    this.mesh.link(p, q);
                    if (this.linkCount == this.links.length) {
                        int[][] tmplinks = new int[this.links.length * 2][2];
                        System.arraycopy(this.links, 0, tmplinks, 0, this.links.length);
                        this.links = tmplinks;
                    }
                    this.links[this.linkCount][0] = p;
                    this.links[this.linkCount][1] = q;
                    ++this.linkCount;
                }
                ++j;
            }
            ++i2;
        }
        this.edges = new float[this.linkCount][4];
        i2 = 0;
        while (i2 < this.linkCount) {
            this.edges[i2][0] = points[this.links[i2][0]][0];
            this.edges[i2][1] = points[this.links[i2][0]][1];
            this.edges[i2][2] = points[this.links[i2][1]][0];
            this.edges[i2][3] = points[this.links[i2][1]][1];
            ++i2;
        }
    }

    public float[][] getEdges() {
        return this.edges;
    }

    public int[][] getLinks() {
        return this.links;
    }

    public int[] getLinked(int i) {
        return this.mesh.get((int)i).links;
    }

    public int edgeCount() {
        return this.linkCount;
    }
}

