/*
 * Decompiled with CFR 0.152.
 */
package vitamin.math;

import vitamin.math.Vector3;

public class Plane {
    public Vector3 _normal;
    public float _d;

    public Plane() {
        this._normal = new Vector3();
        this._d = 0.0f;
    }

    public Plane(float x, float y, float z, float d) {
        this._normal = new Vector3(x, y, z);
        this._d = d;
    }

    public Plane(Vector3 n, float d) {
        this._normal = n;
        this._d = d;
    }

    public Plane(Vector3 p, Vector3 n) {
        this._normal = n.copy();
        this._normal.mul(-1.0f);
        this._d = -Vector3.dot(this._normal, p);
    }

    public Plane(Vector3 v0, Vector3 v1, Vector3 v2) {
        Vector3 e0 = Vector3.sub(v1, v0);
        Vector3 e1 = Vector3.sub(v2, v0);
        this._normal = Vector3.cross(e0, e1);
        this._normal.normalize();
        float a = this._normal.x;
        float b = this._normal.y;
        float c = this._normal.z;
        this._d = -(a * v0.x + b * v0.y + c * v0.z);
    }

    public void normalize() {
        float len = this._normal.length();
        this._normal.normalize();
        this._d /= len;
    }

    public void redefine(Vector3 v0, Vector3 v1, Vector3 v2) {
        Vector3 e0 = Vector3.sub(v1, v0);
        Vector3 e1 = Vector3.sub(v2, v0);
        this._normal = Vector3.cross(e0, e1);
        this._normal.normalize();
        float a = this._normal.x;
        float b = this._normal.y;
        float c = this._normal.z;
        this._d = -(a * v0.x + b * v0.y + c * v0.z);
    }

    public float signedDistance(Vector3 v) {
        float dot = Vector3.dot(this._normal, v);
        return dot + this._d;
    }

    public float distance(Vector3 v) {
        return this._normal.x * v.x + this._normal.y * v.y + this._normal.z * v.z + this._d;
    }
}

