/*
 * Decompiled with CFR 0.152.
 */
package vitamin;

import com.sun.opengl.cg.CGcontext;
import com.sun.opengl.cg.CGeffect;
import com.sun.opengl.cg.CGparameter;
import com.sun.opengl.cg.CGpass;
import com.sun.opengl.cg.CGprogram;
import com.sun.opengl.cg.CGtechnique;
import com.sun.opengl.cg.CgGL;
import com.sun.opengl.util.BufferUtil;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.media.opengl.GL;
import processing.core.PApplet;
import vitamin.eShaderLanguageType;
import vitamin.eShaderType;
import vitamin.math.Matrix;
import vitamin.math.Vector3;
import vitamin.math.Vector4;

public class CG {
    String _name;
    CGcontext _context;
    public eShaderLanguageType _shaderType;
    boolean vertexShaderEnabled;
    boolean fragmentShaderEnabled;
    boolean geometryShaderEnabled;
    CGprogram vertexProgram;
    CGprogram fragmentProgram;
    CGprogram geometryProgram;
    int vertexProfile;
    int fragmentProfile;
    int geometryProfile;
    int _vertexShaderId;
    int _fragmentShaderId;
    int _geometryShaderId;
    public int _glslProgram;
    CGeffect effect;
    CGtechnique technique;
    CGpass pass;
    GL _gl;

    public CG(GL gl) {
        this._gl = gl;
        this._name = null;
        this._context = CgGL.cgCreateContext();
        CgGL.cgGLRegisterStates((CGcontext)this._context);
        CgGL.cgGLSetManageTextureParameters((CGcontext)this._context, (boolean)true);
        this.vertexProgram = null;
        this.fragmentProgram = null;
        this.geometryProgram = null;
        this._vertexShaderId = -1;
        this._fragmentShaderId = -1;
        this._geometryShaderId = -1;
        this._glslProgram = -1;
        this.effect = null;
        this.technique = null;
        this.pass = null;
        this._shaderType = eShaderLanguageType.NONE;
    }

    public void checkErrors(String situation) {
        int[] error = new int[1];
        String string = CgGL.cgGetLastErrorString((int[])error, (int)0);
        if (error[0] != 0) {
            System.out.println(String.valueOf(this._name) + ", " + situation + ", " + string);
            if (error[0] == 1) {
                System.out.println(CgGL.cgGetLastListing((CGcontext)this._context));
            }
        }
    }

    public void checkProfiles() {
        if (CgGL.cgGLIsProfileSupported((int)6150)) {
            this.vertexProfile = 6150;
            System.out.println("CG_PROFILE_ARBVP1 supported");
        } else if (CgGL.cgGLIsProfileSupported((int)7001)) {
            this.vertexProfile = 7001;
            System.out.println("CG_PROFILE_VP40 supported");
        } else if (CgGL.cgGLIsProfileSupported((int)6148)) {
            this.vertexProfile = 6148;
            System.out.println("CG_PROFILE_VP30 supported");
        } else if (CgGL.cgGLIsProfileSupported((int)6146)) {
            this.vertexProfile = 6146;
            System.out.println("CG_PROFILE_VP20 supported");
        }
        if (CgGL.cgGLIsProfileSupported((int)7000)) {
            this.fragmentProfile = 7000;
            System.out.println("CG_PROFILE_ARBFP1 supported");
        } else if (CgGL.cgGLIsProfileSupported((int)6151)) {
            this.fragmentProfile = 6151;
            System.out.println("CG_PROFILE_FP40 supported");
        } else if (CgGL.cgGLIsProfileSupported((int)6149)) {
            this.fragmentProfile = 6149;
            System.out.println("CG_PROFILE_FP30 supported");
        } else if (CgGL.cgGLIsProfileSupported((int)6147)) {
            this.fragmentProfile = 6147;
            System.out.println("CG_PROFILE_FP20 supported");
        }
    }

    public void loadFXFromFile(String file) {
        int error = 0;
        this._shaderType = eShaderLanguageType.CGFX;
        this._name = file;
        System.out.println("\nLoading FX: " + file);
        this.effect = CgGL.cgCreateEffectFromFile((CGcontext)this._context, (String)file, null);
        error = CgGL.cgGetError();
        System.out.println(CgGL.cgGetErrorString((int)error));
        System.out.println(CgGL.cgGetLastListing((CGcontext)this._context));
        if (this.effect == null) {
            System.out.println("Cg error(s) in " + file);
            error = CgGL.cgGetError();
            System.out.println(CgGL.cgGetErrorString((int)error));
            System.out.println(CgGL.cgGetLastListing((CGcontext)this._context));
            System.out.println("fx file not loaded correctly");
        }
        this.technique = CgGL.cgGetFirstTechnique((CGeffect)this.effect);
        while (this.technique != null) {
            System.out.println("technique '" + CgGL.cgGetTechniqueName((CGtechnique)this.technique) + "' " + "validate: " + CgGL.cgValidateTechnique((CGtechnique)this.technique));
            this.technique = CgGL.cgGetNextTechnique((CGtechnique)this.technique);
        }
    }

    public void createProgramFromEffect(int profile, String entry) {
        if (profile == 0) {
            this.vertexProgram = CgGL.cgCreateProgramFromEffect((CGeffect)this.effect, (int)this.vertexProfile, (String)entry, null);
            if (this.vertexProgram == null) {
                System.out.println("vertexprogram is null");
            }
        } else if (profile == 1) {
            this.fragmentProgram = CgGL.cgCreateProgramFromEffect((CGeffect)this.effect, (int)this.fragmentProfile, (String)entry, null);
            if (this.fragmentProgram == null) {
                System.out.println("fragmentprogram is null");
            }
        } else if (profile == 2) {
            this.geometryProgram = CgGL.cgCreateProgramFromEffect((CGeffect)this.effect, (int)this.geometryProfile, (String)entry, null);
            if (this.geometryProgram == null) {
                System.out.println("geometryprogram is null");
            }
        }
    }

    void updateProgramParameters() {
    }

    public void enableFragmentProfile() {
        CgGL.cgGLEnableProfile((int)this.fragmentProfile);
    }

    public void getTechnique(String name) {
        this.technique = CgGL.cgGetNamedTechnique((CGeffect)this.effect, (String)name);
    }

    public void loadCgShader(String filename, eShaderType e) {
        this._shaderType = eShaderLanguageType.CG;
        switch (e) {
            case VERTEX_SHADER: {
                this.loadVertexProgram(filename);
                break;
            }
            case FRAGMENT_SHADER: {
                this.loadFragmentProgram(filename);
                break;
            }
            case GEOMETRY_SHADER: {
                this.loadGeometryProgram(filename);
                break;
            }
            default: {
                System.out.println("Error! Shader type is not supported!");
            }
        }
        this.activatePrograms();
    }

    boolean loadVertexProgram(String file) {
        this._shaderType = eShaderLanguageType.CG;
        this.vertexProfile = CgGL.cgGLGetLatestProfile((int)8);
        if (this.vertexProfile == 6145) {
            System.out.println("Vertex profile could not be created");
        } else {
            CgGL.cgGLSetOptimalOptions((int)this.vertexProfile);
        }
        this.vertexProgram = CgGL.cgCreateProgramFromFile((CGcontext)this._context, (int)4112, (String)file, (int)this.vertexProfile, null, null);
        this.checkErrorInfo(file, this.vertexProgram);
        boolean bl = this.vertexShaderEnabled = this.vertexProgram != null && this.vertexProfile != 6145;
        if (this.vertexShaderEnabled) {
            System.out.println("Loaded vertex program: " + file);
        } else {
            System.out.println("Failed to loaded vertex program: " + file);
        }
        return this.vertexShaderEnabled;
    }

    boolean loadFragmentProgram(String file) {
        this._shaderType = eShaderLanguageType.CG;
        this.fragmentProfile = CgGL.cgGLGetLatestProfile((int)9);
        if (this.fragmentProfile == 6145) {
            System.out.println("Fragment profile could not be created");
        } else {
            CgGL.cgGLSetOptimalOptions((int)this.fragmentProfile);
        }
        this.fragmentProgram = CgGL.cgCreateProgramFromFile((CGcontext)this._context, (int)4112, (String)file, (int)this.fragmentProfile, null, null);
        this.checkErrorInfo(file, this.fragmentProgram);
        boolean bl = this.fragmentShaderEnabled = this.fragmentProgram != null && this.fragmentProfile != 6145;
        if (this.fragmentShaderEnabled) {
            System.out.println("Loaded fragment program: " + file);
        } else {
            System.out.println("Failed to loaded fragment program: " + file);
        }
        return this.fragmentShaderEnabled;
    }

    boolean loadGeometryProgram(String file) {
        this._shaderType = eShaderLanguageType.CG;
        this.geometryProgram = CgGL.cgCreateProgramFromFile((CGcontext)this._context, (int)4112, (String)file, (int)7000, null, null);
        this.checkErrorInfo(file, this.geometryProgram);
        boolean bl = this.geometryShaderEnabled = this.geometryProgram != null && this.geometryProfile != 6145;
        if (this.geometryShaderEnabled) {
            System.out.println("Loaded geometry program: " + file);
        } else {
            System.out.println("Failed to loaded geometry program: " + file);
        }
        return this.geometryShaderEnabled;
    }

    public void activatePrograms() {
        if (this.vertexShaderEnabled) {
            CgGL.cgGLLoadProgram((CGprogram)this.vertexProgram);
        }
        if (this.fragmentShaderEnabled) {
            CgGL.cgGLLoadProgram((CGprogram)this.fragmentProgram);
        }
        if (this.geometryShaderEnabled) {
            CgGL.cgGLLoadProgram((CGprogram)this.geometryProgram);
        }
    }

    public void bindProgram() {
        if (this._shaderType == eShaderLanguageType.CG) {
            if (this.vertexShaderEnabled) {
                CgGL.cgGLBindProgram((CGprogram)this.vertexProgram);
                CgGL.cgGLEnableProfile((int)this.vertexProfile);
            }
            if (this.fragmentShaderEnabled) {
                CgGL.cgGLBindProgram((CGprogram)this.fragmentProgram);
                CgGL.cgGLEnableProfile((int)this.fragmentProfile);
            }
            if (this.geometryShaderEnabled) {
                CgGL.cgGLBindProgram((CGprogram)this.geometryProgram);
                CgGL.cgGLEnableProfile((int)this.geometryProfile);
            }
        } else if (this._shaderType == eShaderLanguageType.GLSL) {
            this._gl.glUseProgram(this._glslProgram);
        }
    }

    public void unbindProgram() {
        if (this._shaderType == eShaderLanguageType.CG) {
            if (this.vertexShaderEnabled) {
                CgGL.cgGLDisableProfile((int)this.vertexProfile);
            }
            if (this.fragmentShaderEnabled) {
                CgGL.cgGLEnableProfile((int)this.fragmentProfile);
            }
            if (this.geometryShaderEnabled) {
                CgGL.cgGLEnableProfile((int)this.geometryProfile);
            }
        } else if (this._shaderType == eShaderLanguageType.GLSL) {
            this._gl.glUseProgram(0);
        }
    }

    public void loadGLSLShader(PApplet p, String vfile, String ffile, String gfile) {
        this.loadVertexShader(p, vfile);
        this.loadFragmentShader(p, ffile);
        this.loadGeometryShader(p, gfile);
        this.compile();
    }

    public void loadVertexShader(PApplet p, String filename) {
        this._shaderType = eShaderLanguageType.GLSL;
        this._vertexShaderId = this._gl.glCreateShaderObjectARB(35633);
        String source = PApplet.join((String[])p.loadStrings(filename), (String)"\n");
        this._gl.glShaderSourceARB(this._vertexShaderId, 1, new String[]{source}, null, 0);
    }

    public void loadFragmentShader(PApplet p, String filename) {
        this._shaderType = eShaderLanguageType.GLSL;
        this._fragmentShaderId = this._gl.glCreateShaderObjectARB(35632);
        String source = PApplet.join((String[])p.loadStrings(filename), (String)"\n");
        this._gl.glShaderSourceARB(this._fragmentShaderId, 1, new String[]{source}, null, 0);
    }

    public void loadGeometryShader(PApplet p, String filename) {
        this._shaderType = eShaderLanguageType.GLSL;
        this._geometryShaderId = this._gl.glCreateShader(36313);
        String source = PApplet.join((String[])p.loadStrings(filename), (String)"\n");
        this._gl.glShaderSourceARB(this._geometryShaderId, 1, new String[]{source}, null, 0);
    }

    public void compile() {
        this._glslProgram = this._gl.glCreateProgramObjectARB();
        this._gl.glCompileShaderARB(this._vertexShaderId);
        this._gl.glAttachObjectARB(this._glslProgram, this._vertexShaderId);
        this.checkLogInfo("vshader:", this._vertexShaderId);
        this._gl.glCompileShaderARB(this._fragmentShaderId);
        this._gl.glAttachObjectARB(this._glslProgram, this._fragmentShaderId);
        this.checkLogInfo("fshader:", this._fragmentShaderId);
        this._gl.glLinkProgramARB(this._glslProgram);
        this._gl.glValidateProgramARB(this._glslProgram);
        this.checkLogInfo("GLSL program validation: ", this._glslProgram);
    }

    protected void checkLogInfo(String title, int obj) {
        IntBuffer iVal = BufferUtil.newIntBuffer((int)1);
        this._gl.glGetObjectParameterivARB(obj, 35716, iVal);
        int length = iVal.get();
        if (length <= 1) {
            System.err.println("checkloginfo: ERROR!");
            return;
        }
        ByteBuffer infoLog = BufferUtil.newByteBuffer((int)length);
        iVal.flip();
        this._gl.glGetInfoLogARB(obj, length, iVal, infoLog);
        byte[] infoBytes = new byte[length];
        infoLog.get(infoBytes);
        System.err.println(title);
        System.err.println(new String(infoBytes));
    }

    public void setVertexParameter1f(String paramName, float val) {
        switch (this._shaderType) {
            case CG: {
                CGparameter param = null;
                param = CgGL.cgGetNamedParameter((CGprogram)this.vertexProgram, (String)paramName);
                if (param != null) {
                    CgGL.cgGLSetParameter1f((CGparameter)param, (float)val);
                    break;
                }
                System.out.println("param1f is null");
                break;
            }
            case GLSL: {
                int location = this._gl.glGetUniformLocation(this._glslProgram, paramName);
                this._gl.glUniform1f(location, val);
                break;
            }
            default: {
                System.out.println("this shader type is not supported!");
            }
        }
    }

    public void setVertexParameter1i(String paramName, int val) {
        switch (this._shaderType) {
            case CG: {
                CGparameter param = null;
                param = CgGL.cgGetNamedParameter((CGprogram)this.vertexProgram, (String)paramName);
                if (param != null) {
                    CgGL.cgGLSetParameter1f((CGparameter)param, (float)val);
                    break;
                }
                System.out.println("param1i is null");
                break;
            }
            case GLSL: {
                int location = this._gl.glGetUniformLocation(this._glslProgram, paramName);
                this._gl.glUniform1i(location, val);
                break;
            }
            default: {
                System.out.println("this shader type is not supported!");
            }
        }
    }

    public void setFragmentParameter1f(String paramName, float val) {
        switch (this._shaderType) {
            case CG: {
                CGparameter param = null;
                param = CgGL.cgGetNamedParameter((CGprogram)this.fragmentProgram, (String)paramName);
                if (param != null) {
                    CgGL.cgGLSetParameter1f((CGparameter)param, (float)val);
                    break;
                }
                System.out.println("param1f is null");
                break;
            }
            case GLSL: {
                int location = this._gl.glGetUniformLocation(this._glslProgram, paramName);
                this._gl.glUniform1f(location, val);
                break;
            }
            default: {
                System.out.println("this shader type is not supported!");
            }
        }
    }

    public void setFragmentParameter1i(String paramName, int val) {
        switch (this._shaderType) {
            case CG: {
                CGparameter param = null;
                param = CgGL.cgGetNamedParameter((CGprogram)this.fragmentProgram, (String)paramName);
                if (param != null) {
                    CgGL.cgSetParameter1i((CGparameter)param, (int)val);
                    break;
                }
                System.out.println("param1f is null");
                break;
            }
            case GLSL: {
                int location = this._gl.glGetUniformLocation(this._glslProgram, paramName);
                this._gl.glUniform1i(location, val);
                break;
            }
            default: {
                System.out.println("this shader type is not supported!");
            }
        }
    }

    public void setVertexParameter2f(String paramName, float x, float y) {
        switch (this._shaderType) {
            case CG: {
                CGparameter param = null;
                param = CgGL.cgGetNamedParameter((CGprogram)this.vertexProgram, (String)paramName);
                if (param != null) {
                    CgGL.cgGLSetParameter2f((CGparameter)param, (float)x, (float)y);
                    break;
                }
                System.out.println("param2f is null");
                break;
            }
            case GLSL: {
                int location = this._gl.glGetUniformLocation(this._glslProgram, paramName);
                this._gl.glUniform2f(location, x, y);
                break;
            }
            default: {
                System.out.println("this shader type is not supported!");
            }
        }
    }

    public void setFragmentParameter2f(String paramName, float x, float y) {
        switch (this._shaderType) {
            case CG: {
                CGparameter param = null;
                param = CgGL.cgGetNamedParameter((CGprogram)this.fragmentProgram, (String)paramName);
                if (param != null) {
                    CgGL.cgGLSetParameter2f((CGparameter)param, (float)x, (float)y);
                    break;
                }
                System.out.println("param2f is null");
                break;
            }
            case GLSL: {
                int location = this._gl.glGetUniformLocation(this._glslProgram, paramName);
                this._gl.glUniform2f(location, x, y);
                break;
            }
            default: {
                System.out.println("this shader type is not supported!");
            }
        }
    }

    public void setVertexParameter3f(String paramName, float x, float y, float z) {
        switch (this._shaderType) {
            case CG: {
                CGparameter param = null;
                param = CgGL.cgGetNamedParameter((CGprogram)this.vertexProgram, (String)paramName);
                if (param != null) {
                    CgGL.cgGLSetParameter3f((CGparameter)param, (float)x, (float)y, (float)z);
                    break;
                }
                System.out.println("param3f is null");
                break;
            }
            case GLSL: {
                int location = this._gl.glGetUniformLocation(this._glslProgram, paramName);
                this._gl.glUniform3f(location, x, y, z);
                break;
            }
            default: {
                System.out.println("this shader type is not supported!");
            }
        }
    }

    public void setFragmentParameter3f(String paramName, float x, float y, float z) {
        switch (this._shaderType) {
            case CG: {
                CGparameter param = null;
                param = CgGL.cgGetNamedParameter((CGprogram)this.fragmentProgram, (String)paramName);
                if (param != null) {
                    CgGL.cgGLSetParameter3f((CGparameter)param, (float)x, (float)y, (float)z);
                    break;
                }
                System.out.println("param3f is null");
                break;
            }
            case GLSL: {
                int location = this._gl.glGetUniformLocation(this._glslProgram, paramName);
                this._gl.glUniform3f(location, x, y, z);
                break;
            }
            default: {
                System.out.println("this shader type is not supported!");
            }
        }
    }

    public void setVertexParameter4f(String paramName, float x, float y, float z, float w) {
        switch (this._shaderType) {
            case CG: {
                CGparameter param = null;
                param = CgGL.cgGetNamedParameter((CGprogram)this.vertexProgram, (String)paramName);
                if (param != null) {
                    CgGL.cgGLSetParameter4f((CGparameter)param, (float)x, (float)y, (float)z, (float)w);
                    break;
                }
                System.out.println("param4f is null");
                break;
            }
            case GLSL: {
                int location = this._gl.glGetUniformLocation(this._glslProgram, paramName);
                this._gl.glUniform4f(location, x, y, z, w);
                break;
            }
            default: {
                System.out.println("this shader type is not supported!");
            }
        }
    }

    public void setFragmentParameter4f(String paramName, float x, float y, float z, float w) {
        switch (this._shaderType) {
            case CG: {
                CGparameter param = null;
                param = CgGL.cgGetNamedParameter((CGprogram)this.fragmentProgram, (String)paramName);
                if (param != null) {
                    CgGL.cgGLSetParameter4f((CGparameter)param, (float)x, (float)y, (float)z, (float)w);
                    break;
                }
                System.out.println("param4f is null");
                break;
            }
            case GLSL: {
                int location = this._gl.glGetUniformLocation(this._glslProgram, paramName);
                this._gl.glUniform4f(location, x, y, z, w);
                break;
            }
            default: {
                System.out.println("this shader type is not supported!");
            }
        }
    }

    public void setVertexParameter4fv(String paramName, float[] buffer) {
        switch (this._shaderType) {
            case CG: {
                CGparameter param = null;
                param = CgGL.cgGetNamedParameter((CGprogram)this.vertexProgram, (String)paramName);
                if (param != null) {
                    CgGL.cgSetParameter4fv((CGparameter)param, (float[])buffer, (int)0);
                    break;
                }
                System.out.println("param4f is null");
                break;
            }
            case GLSL: {
                int location = this._gl.glGetUniformLocation(this._glslProgram, paramName);
                this._gl.glUniform4fv(location, 4, buffer, 0);
                break;
            }
            default: {
                System.out.println("this shader type is not supported!");
            }
        }
    }

    public void enableTextureParameter(String paramName) {
        if (this._shaderType != eShaderLanguageType.GLSL) {
            CGparameter param = CgGL.cgGetNamedEffectParameter((CGeffect)this.effect, (String)paramName);
            if (param != null) {
                CgGL.cgGLEnableTextureParameter((CGparameter)param);
            } else {
                System.out.println("Cant find texture parameter");
            }
        }
    }

    public void disableTextureParameter(String paramName) {
        if (this._shaderType != eShaderLanguageType.GLSL) {
            CGparameter param = CgGL.cgGetNamedEffectParameter((CGeffect)this.effect, (String)paramName);
            if (param != null) {
                CgGL.cgGLDisableTextureParameter((CGparameter)param);
            } else {
                System.out.println("Cant find texture parameter");
            }
        }
    }

    public void setTextureParameter(String paramName, int val) {
        CGparameter param = null;
        switch (this._shaderType) {
            case CGFX: {
                param = CgGL.cgGetNamedEffectParameter((CGeffect)this.effect, (String)paramName);
                if (param != null) {
                    CgGL.cgGLSetTextureParameter((CGparameter)param, (int)val);
                } else {
                    System.out.println("Cant find texture parameter");
                }
                CgGL.cgSetSamplerState((CGparameter)param);
                break;
            }
            case CG: {
                param = CgGL.cgGetNamedParameter((CGprogram)this.fragmentProgram, (String)paramName);
                if (param != null) {
                    CgGL.cgGLSetTextureParameter((CGparameter)param, (int)val);
                } else {
                    System.out.println("Cant find texture parameter");
                }
                CgGL.cgSetSamplerState((CGparameter)param);
                break;
            }
            case GLSL: {
                int texid = this._gl.glGetUniformLocationARB(this._glslProgram, paramName);
                this._gl.glUniform1i(texid, val);
                break;
            }
            default: {
                System.out.println("this function does not support this shader type!");
            }
        }
    }

    public void setParameter1f(String paramName, float val) {
        CGparameter param = null;
        switch (this._shaderType) {
            case CGFX: {
                param = CgGL.cgGetNamedEffectParameter((CGeffect)this.effect, (String)paramName);
                if (param != null) {
                    CgGL.cgGLSetParameter1f((CGparameter)param, (float)val);
                    break;
                }
                System.out.println("param1f is null");
                break;
            }
            case GLSL: {
                int location = this._gl.glGetUniformLocation(this._glslProgram, paramName);
                this._gl.glUniform1f(location, val);
                break;
            }
            default: {
                System.out.println("this function does not support this shader type!");
            }
        }
    }

    public void setParameter1i(String paramName, int val) {
        CGparameter param = null;
        switch (this._shaderType) {
            case CGFX: {
                param = CgGL.cgGetNamedEffectParameter((CGeffect)this.effect, (String)paramName);
                if (param != null) {
                    CgGL.cgSetParameter1i((CGparameter)param, (int)val);
                    break;
                }
                System.out.println("param1i is null");
                break;
            }
            case GLSL: {
                int location = this._gl.glGetUniformLocation(this._glslProgram, paramName);
                this._gl.glUniform1f(location, (float)val);
                break;
            }
            default: {
                System.out.println("this function does not support this shader type!");
            }
        }
    }

    public void setParameter2f(String paramName, float x, float y) {
        CGparameter param = null;
        switch (this._shaderType) {
            case CGFX: {
                param = CgGL.cgGetNamedEffectParameter((CGeffect)this.effect, (String)paramName);
                if (param != null) {
                    CgGL.cgGLSetParameter2f((CGparameter)param, (float)x, (float)y);
                    break;
                }
                System.out.println("param2f is null");
                break;
            }
            case GLSL: {
                int location = this._gl.glGetUniformLocation(this._glslProgram, paramName);
                this._gl.glUniform2f(location, x, y);
                break;
            }
            default: {
                System.out.println("this function does not support this shader type!");
            }
        }
    }

    public void setParameter3f(String paramName, float x, float y, float z) {
        CGparameter param = null;
        switch (this._shaderType) {
            case CGFX: {
                param = CgGL.cgGetNamedEffectParameter((CGeffect)this.effect, (String)paramName);
                if (param != null) {
                    CgGL.cgGLSetParameter3f((CGparameter)param, (float)x, (float)y, (float)z);
                    break;
                }
                System.out.println("param3f is null");
                break;
            }
            case GLSL: {
                int location = this._gl.glGetUniformLocation(this._glslProgram, paramName);
                this._gl.glUniform3f(location, x, y, z);
                break;
            }
            default: {
                System.out.println("this function does not support this shader type!");
            }
        }
    }

    public void setParameter3f(String paramName, Vector3 v) {
        CGparameter param = null;
        switch (this._shaderType) {
            case CGFX: {
                param = CgGL.cgGetNamedEffectParameter((CGeffect)this.effect, (String)paramName);
                if (param != null) {
                    CgGL.cgGLSetParameter3f((CGparameter)param, (float)v.x, (float)v.y, (float)v.z);
                    break;
                }
                System.out.println("param3f is null");
                break;
            }
            case GLSL: {
                int location = this._gl.glGetUniformLocation(this._glslProgram, paramName);
                this._gl.glUniform3f(location, v.x, v.y, v.z);
                break;
            }
            default: {
                System.out.println("this function does not support this shader type!");
            }
        }
    }

    public void setParameter4f(String paramName, float x, float y, float z, float w) {
        CGparameter param = null;
        switch (this._shaderType) {
            case CGFX: {
                param = CgGL.cgGetNamedEffectParameter((CGeffect)this.effect, (String)paramName);
                if (param != null) {
                    CgGL.cgGLSetParameter4f((CGparameter)param, (float)x, (float)y, (float)z, (float)w);
                    break;
                }
                System.out.println("param4f is null");
                break;
            }
            case GLSL: {
                int location = this._gl.glGetUniformLocation(this._glslProgram, paramName);
                this._gl.glUniform4f(location, x, y, z, w);
                break;
            }
            default: {
                System.out.println("this function does not support this shader type!");
            }
        }
    }

    public void setParameter4f(String paramName, Vector4 v) {
        CGparameter param = null;
        switch (this._shaderType) {
            case CGFX: {
                param = CgGL.cgGetNamedEffectParameter((CGeffect)this.effect, (String)paramName);
                if (param != null) {
                    CgGL.cgGLSetParameter4f((CGparameter)param, (float)v.x, (float)v.y, (float)v.z, (float)v.w);
                    break;
                }
                System.out.println("param4f is null");
                break;
            }
            case GLSL: {
                int location = this._gl.glGetUniformLocation(this._glslProgram, paramName);
                this._gl.glUniform4f(location, v.x, v.y, v.z, v.w);
                break;
            }
            default: {
                System.out.println("this function does not support this shader type!");
            }
        }
    }

    public void setParameter4fv(String paramName, float[] buffer) {
        CGparameter param = null;
        switch (this._shaderType) {
            case CGFX: {
                param = CgGL.cgGetNamedEffectParameter((CGeffect)this.effect, (String)paramName);
                if (param != null) {
                    CgGL.cgSetParameter4fv((CGparameter)param, (float[])buffer, (int)0);
                    break;
                }
                System.out.println("param4f is null");
                break;
            }
            case CG: {
                param = CgGL.cgGetNamedParameter((CGprogram)this.vertexProgram, (String)paramName);
                break;
            }
            default: {
                System.out.println("this function does not support this shader type!");
            }
        }
    }

    public void setParameter4x4fBySemantic(String semanticName, int matrix, int matrixType) {
        if (this._shaderType == eShaderLanguageType.CGFX) {
            CGparameter param = CgGL.cgGetEffectParameterBySemantic((CGeffect)this.effect, (String)semanticName);
            if (param != null) {
                CgGL.cgGLSetStateMatrixParameter((CGparameter)param, (int)matrix, (int)matrixType);
            } else {
                System.out.println("matrix semantic param is null");
            }
        } else {
            System.out.println("setParameter4x4fBySemantic cant be used except for cgfx ");
        }
    }

    public void setParameter4x4f(String paramName, int matrix, int matrixType) {
        CGparameter param = null;
        switch (this._shaderType) {
            case CGFX: {
                param = CgGL.cgGetNamedEffectParameter((CGeffect)this.effect, (String)paramName);
                break;
            }
            case CG: {
                param = CgGL.cgGetNamedParameter((CGprogram)this.vertexProgram, (String)paramName);
                break;
            }
            default: {
                System.out.println("this shader type is not supported!");
            }
        }
        if (param != null) {
            CgGL.cgGLSetStateMatrixParameter((CGparameter)param, (int)matrix, (int)matrixType);
        } else {
            System.out.println("matrix param is null");
        }
    }

    public void setParameter4x4f(String paramName, Matrix m) {
        CGparameter param = null;
        switch (this._shaderType) {
            case CGFX: {
                param = CgGL.cgGetNamedEffectParameter((CGeffect)this.effect, (String)paramName);
                break;
            }
            case CG: {
                param = CgGL.cgGetNamedParameter((CGprogram)this.vertexProgram, (String)paramName);
                break;
            }
            case GLSL: {
                int location = this._gl.glGetUniformLocation(this._glslProgram, paramName);
                this._gl.glUniformMatrix4fv(location, 1, true, m.getFloatBuffer());
                break;
            }
            default: {
                System.out.println("this shader type is not supported!");
            }
        }
        if (param != null) {
            CgGL.cgGLSetMatrixParameterfr((CGparameter)param, (float[])m._M, (int)0);
        } else {
            System.out.println("matrix param is null");
        }
    }

    public Matrix getParameter4x4f(String paramName) {
        if (this._shaderType != eShaderLanguageType.CG || this._shaderType != eShaderLanguageType.CGFX) {
            return null;
        }
        Matrix m = new Matrix();
        CGparameter param = this._shaderType == eShaderLanguageType.CGFX ? CgGL.cgGetNamedEffectParameter((CGeffect)this.effect, (String)paramName) : CgGL.cgGetNamedParameter((CGprogram)this.vertexProgram, (String)paramName);
        if (param != null) {
            CgGL.cgGLGetMatrixParameterfr((CGparameter)param, (FloatBuffer)m.getFloatBuffer());
        } else {
            System.out.println("matrix param is null");
        }
        return m;
    }

    public Vector4 getParameter4f(String paramName) {
        if (this._shaderType != eShaderLanguageType.CGFX) {
            return null;
        }
        float[] vt = new float[4];
        CGparameter param = CgGL.cgGetNamedEffectParameter((CGeffect)this.effect, (String)paramName);
        if (param != null) {
            CgGL.cgGLGetParameter4f((CGparameter)param, (float[])vt, (int)0);
        } else {
            System.out.println("matrix param is null");
        }
        return new Vector4(vt[0], vt[1], vt[2], vt[3]);
    }

    public void getFirstTechnique() {
        this.technique = CgGL.cgGetFirstTechnique((CGeffect)this.effect);
    }

    public CGpass getTechniqueFirstPass(String name) {
        this.technique = CgGL.cgGetNamedTechnique((CGeffect)this.effect, (String)name);
        if (this.technique == null) {
            System.out.println("technique '" + name + "' is null");
        }
        return CgGL.cgGetFirstPass((CGtechnique)this.technique);
    }

    public void startPass() {
        CgGL.cgSetPassState((CGpass)this.pass);
    }

    public void endPass() {
        CgGL.cgResetPassState((CGpass)this.pass);
    }

    public eShaderLanguageType type() {
        return this._shaderType;
    }

    public void checkErrorInfo(String fn, CGprogram program) {
        if (program == null) {
            int error = CgGL.cgGetError();
            System.out.println("Cg error(s) in " + fn);
            System.out.println(CgGL.cgGetErrorString((int)error));
            System.out.println(CgGL.cgGetLastListing((CGcontext)this._context));
        }
    }

    public void release() {
        if (this._shaderType == eShaderLanguageType.CG) {
            if (this.vertexShaderEnabled) {
                CgGL.cgDestroyProgram((CGprogram)this.vertexProgram);
            }
            if (this.fragmentShaderEnabled) {
                CgGL.cgDestroyProgram((CGprogram)this.fragmentProgram);
            }
            if (this.geometryShaderEnabled) {
                CgGL.cgDestroyProgram((CGprogram)this.geometryProgram);
            }
        }
        if (this._shaderType == eShaderLanguageType.CGFX) {
            CgGL.cgDestroyEffect((CGeffect)this.effect);
        }
        if (this._shaderType == eShaderLanguageType.GLSL) {
            this._gl.glDetachObjectARB(this._glslProgram, this._vertexShaderId);
            this._gl.glDetachObjectARB(this._glslProgram, this._fragmentShaderId);
            this._gl.glDetachObjectARB(this._glslProgram, this._geometryShaderId);
            this._gl.glDeleteObjectARB(this._vertexShaderId);
            this._gl.glDeleteObjectARB(this._fragmentShaderId);
            this._gl.glDeleteObjectARB(this._geometryShaderId);
        }
        CgGL.cgDestroyContext((CGcontext)this._context);
    }
}

