;Scroll? 512b intro
;by Shiru 07'10, for DiHalt'10

    device zxspectrum128

CLEAR	equ #1eaf
PRMES	equ #0c0a

OP_LDSP	equ #31
OP_JP	equ #c3


    org #8000

begin

makeSprites
	ld bc,#bfff
	call CLEAR
	ld de,#0cf8	;a=0 after CLEAR
	call PRMES

	ld hl,#50e0
	ld de,sprV+128
	ld ix,sprV+64
.l0
	push hl
.l1
	ld a,(hl)
	ld (de),a
	ld (ix),a
	ld (ix-64),a
	inc h
	ld a,e
	add a,8
	ld e,a
	inc ixl
	bit 6,a
	jr z,.l1
	sub 63
	ld e,a
	pop hl
	inc l
	bit 3,l
	jr z,.l0

.l2
	ld a,(ix+7)
	rra
	ld b,8
.l3
	ld a,(ix)
	rra
	ld (ix+64),a
	inc ix
	djnz .l3
	ld a,ixh
	cp #94
	jr nz,.l2

	display "makeSprites ",/d,$-makeSprites

makeCopyProc
	ld de,copyProc
.l0
	ld hl,copyProc1
	ld bc,7
	ldir
	ld hl,(copyProc1+1)
	ld c,32
	add hl,bc
	ld (copyProc1+1),hl
	ld c,b
	ld a,3
.l1
	add hl,bc
	push af
	push hl
	ex de,hl
	ld (hl),OP_LDSP
	inc hl
	ld (hl),e
	inc hl
	ld (hl),d
	inc hl
	ex de,hl
	ld a,4
.l2
	ld hl,copyProc2
	ld bc,4
	ldir
	dec a
	jr nz,.l2
	ld b,2048/256
	pop hl
	pop af
	dec a
	jr nz,.l1
	ld a,h
	cp #d8
	jr nz,.l0

	ex de,hl
	ld (hl),OP_JP
	inc hl
	ld (hl),copyProcExit&255
	inc hl
	ld (hl),copyProcExit/256

	display "makeCopyProc ",/d,$-makeCopyProc

makeDrawProcs
	ld hl,drawH1list
	ld de,drawH1Proc
.l0
	ld c,(hl)
	inc hl
	ld a,c
	or a
	jr z,.l2
	ld b,copyH/256
.l1
	ld a,(bc)
	or a
	jr z,.l0
	inc bc
	ld (de),a
	inc de
	jr .l1
.l2

	display "makeDrawProcs ",/d,$-makeDrawProcs

fillAttr
	out (#fe),a	;a=0
	ld b,2
.l0
	push bc
	call toggleScr

	ld de,#d800

	ld bc,24*256
.l2
	ld a,8
.l1
	push bc
	ld hl,attr
	ld b,0
	add hl,bc
	ld c,4
	ldir
	pop bc
	dec a
	jr nz,.l1
	ld a,c
	add a,4
	and 15
	ld c,a
	djnz .l2

	pop bc
	djnz .l0

	display "fillAttr ",/d,$-fillAttr

mainLoop
	ei
	halt
	di
	call toggleScr

	ld (mainSP),sp

	ld ix,vars-16
	ld iy,scrlist
mainDrawLoop
	ld d,#c0
	ld e,(iy+8)
	ld a,e
	or a
	jr z,.l4
	ld l,(iy)
	ld h,drawH1Proc/256
	inc iy
	jp (hl)
.l4

	ld hl,#c701
.l5
	ld bc,#05ff
.l6
	ld (hl),c
	ld a,h
	xor 7
	ld h,a
	inc l
	inc l
	djnz .l6
	ld a,l
	add a,64-10
	ld l,a
	jr nc,.l5

	ld hl,#c020
	ld d,%10000000
.l7
	ld b,5
.l8
	ld c,8
.l9
	ld a,(hl)
	or d
	ld (hl),a
	inc h
	dec c
	jr nz,.l9
	res 3,h
	ld a,d
	xor %10000001
	ld d,a
	inc l
	inc l
	djnz .l8
	ld a,l
	add a,64-10
	ld l,a
	jr nc,.l7

	jp copyProc
copyProcExit

mainSP=$+1
	ld sp,0

	jp mainLoop

	display "mainLoop ",/d,$-mainLoop

toggleScr
.mem=$+1
	ld a,16+8+5
	xor %00001010	;toggle visible screen and page at #c000 (5 or 7)
	ld (.mem),a
	ld bc,#7ffd
	out (c),a
	ret

codeLibrary

copyProc1
	ld sp,#c000
	pop af
	pop bc
	pop de
	pop hl
copyProc2
	push hl
	push de
	push bc
	push af
copyH	;5b
	pop de
	ld (hl),e
	inc l
	ld (hl),d
	inc l
	db 0
copyV	;13b
	ld b,4
	pop de
	ld (hl),e
	inc h
	ld (hl),d
	inc h
	djnz $-5
    ld de,-2048+32
	add hl,de
	db 0
skipH	;4b
	pop de
	ld (hl),e
	inc l
	inc l
	db 0
skipV	;10b
	dup 4
	pop de
	edup
	set 3,h
    ld de,-2048+32
	add hl,de
	db 0
calcAdr
	exx
	ld l,(ix+32)
	ld h,(ix+33)
	ld e,(ix+16)
	ld d,(ix+17)
	add hl,de
	ld a,h
	ld (ix+32),l
	ld (ix+33),h
	exx
	inc ix
	inc ix
	and 63
	ld l,a
	db 0
drawHs
	xor a
	ld h,a
	ld b,6
	add hl,hl
	djnz $-1
	ld a,sprH/256
	add a,h
	ld h,a
	ld sp,hl
	ex de,hl
	ld b,8
	ld a,l	;-17
	ld c,2
	db 0
drawHe
	dec c
	jr nz,$-10
	ld l,a
	inc h
	djnz $-17
	jp mainDrawLoop
	db 0
drawVs
	ld h,sprV/256
	ld sp,hl
	ex de,hl
	ld c,2
	db 0
drawVe
	dec c
	jr nz,$-50
	jp mainDrawLoop
	db 0

	display "codeLibrary ",/d,$-codeLibrary

tables

scrlist
	db drawH1Proc&255,drawH1Proc&255,drawH2Proc&255,drawH2Proc&255
	db drawV1Proc&255,drawV1Proc&255,drawV2Proc&255,drawV2Proc&255
	db #20,#a0,#60,#e0,#01,#05,#03,#07

attr
	db #00,#60,#00,#70
	db #68,#68,#68,#70
	db #00,#60,#00,#70
	db #78,#60,#78,#78

drawH1list
	db calcAdr&255,drawHs&255,copyH&255,skipH&255,drawHe&255
drawH2list
	db calcAdr&255,drawHs&255,skipH&255,copyH&255,drawHe&255
drawV1list
	db calcAdr&255,drawVs&255,copyV&255,skipV&255,copyV&255,copyV&255,drawVe&255
drawV2list
	db calcAdr&255,drawVs&255,copyV&255,copyV&255,copyV&255,skipV&255,drawVe&255,0

	display "tables ",/d,$-tables


vars
xinc	dw 256+0,256+80,-256-40,-256-120,256+20,256+100,-256-60,-256-140

end

xoff	dw 0,0,0,0,0,0,0,0

	align 256
sprV	ds 64*2
	align 256
sprH	ds 64*64

copyProc=#ad00
drawH1Proc=#be00
drawH2Proc=#be42
drawV1Proc=#be84
drawV2Proc=#bede

    display /d,end-begin

    ;savesna "test.sna",begin
    savebin "scrl512b.c",begin,end-begin