#!/usr/bin/ruby

require 'RMagick'

class Manager
	def initialize
		@color_map = [
			{ :pixel => Magick::Pixel.from_color('#000000'), :color => 0, :bright => 0 },
			# { :pixel => Magick::Pixel.from_color('#0000B0'), :color => 1, :bright => 0 },
			# { :pixel => Magick::Pixel.from_color('#B00000'), :color => 2, :bright => 0 },
			# { :pixel => Magick::Pixel.from_color('#B000B0'), :color => 3, :bright => 0 },
			# { :pixel => Magick::Pixel.from_color('#00B000'), :color => 4, :bright => 0 },
			# { :pixel => Magick::Pixel.from_color('#00B0B0'), :color => 5, :bright => 0 },
			# { :pixel => Magick::Pixel.from_color('#B0B000'), :color => 6, :bright => 0 },
			# { :pixel => Magick::Pixel.from_color('#B0B0B0'), :color => 7, :bright => 0 },
			{ :pixel => Magick::Pixel.from_color('#0000FF'), :color => 1, :bright => 1 },
			{ :pixel => Magick::Pixel.from_color('#FF0000'), :color => 2, :bright => 1 },
			{ :pixel => Magick::Pixel.from_color('#FF00FF'), :color => 3, :bright => 1 },
			{ :pixel => Magick::Pixel.from_color('#00FF00'), :color => 4, :bright => 1 },
			{ :pixel => Magick::Pixel.from_color('#00FFFF'), :color => 5, :bright => 1 },
			{ :pixel => Magick::Pixel.from_color('#FFFF00'), :color => 6, :bright => 1 },
			{ :pixel => Magick::Pixel.from_color('#FFFFFF'), :color => 7, :bright => 1 },
		]

		@color_hash = {}
		@color_map.each { |v| @color_hash[v[:pixel].to_color] = v }
	end

	def load(image_name)
		img = Magick::ImageList.new(image_name)
		img.scale!(256, 192) if img.rows != 192 || img.columns != 256

		@simg = Magick::Image.new(@color_map.size, 1)

		@simg.view(0, 0, @simg.columns, @simg.rows) do |sview|
			@color_map.each_with_index do |v, i|
				sview[0][i] = v[:pixel]
			end
		end

		# img.normalize
		# img = img.posterize(3)
		# img = img.ordered_dither('2x2')
		img = img.remap(@simg, Magick::NoDitherMethod)

		# img.display
		# Thread.exit

		return [img]
	end

	def convert_block(img, row, col)
		img_block = img.crop(col * 8, row * 8, 8, 8)
		img_block = img_block.quantize(2, Magick::RGBColorspace, Magick::NoDitherMethod)
		img_block = img_block.remap(@simg, Magick::NoDitherMethod)

		colors = {}
		pixels = Array.new(8) { Array.new(8) { '' } }

		img_block.each_pixel do |pix, c, r|
			cl = pix.to_color
			pixels[r][c] = cl

			colors[cl] = 0 unless colors.key?(cl)
			colors[cl] += 1
		end

		if colors.size == 1
			v = @color_hash[colors.keys.first]

			return {
				:data => [0, 0, 0, 0, 0, 0, 0, 0],
				:attr => (v[:color] << 3) | (v[:bright] << 6)
			}
		end

		ca = colors.to_a.sort { |a, b| b[1] <=> a[1] }
		data = []

		for r in (0..7)
			bt = 0

			for c in (0..7)
				bt <<= 1
				bt |= 1 if pixels[r][c] == ca[1][0]
			end

			data << bt
		end

		cp = @color_hash[ca[0][0]]
		ci = @color_hash[ca[1][0]]

		return {
			:data => data,
			:attr => (cp[:bright] << 6) | (ci[:bright] << 6) | (cp[:color] << 3) | ci[:color]
		}
	end

	def convert(img)
		blocks = []

		for row in (0..23)
			line = []
			puts "#{row+1}/24"

			for col in (0..31)
				line << convert_block(img, row, col)
			end

			blocks << line
		end

		return blocks
	end

	def save_blocks(file_name, blocks)
		res = Array.new(0x1B00) { 0 }

		for row in (0..23)
			for col in (0..31)
				base = ((row & 0b11000) << 8) | ((row & 7) << 5) | col
				# p base.to_s(16)

				for l in (0..7)
					res[base + (l << 8)] = blocks[row][col][:data][l]
				end

				res[0x1800 + row * 32 + col] = blocks[row][col][:attr]
			end
		end

		res.map! { |v| v.chr }

		File.open(file_name, 'wb') do |fo|
			fo << res
		end
	end

	def manage
		if ARGV.size != 1
			puts "Usage: #{$0} <image-name>"
			return
		end

		list = load(ARGV[0])
		out_base = ARGV[0].gsub(/\.[^\.]+$/, '')

		if list.size == 1
			blocks = convert(list[0])
			save_blocks(out_base + '.scr', blocks)
		else
			ind = 1

			list.each do |img|
				blocks = convert(img[0])
				save_blocks("#{out_base}-#{ind}.scr", blocks)
				ind += 1
			end
		end
	end
end

mng = Manager.new
mng.manage
