
uniform sampler2D colormap,depthpacked;
uniform float depthscale,focus_z,blurstrength; 
uniform int ivertdepth,direction;
float unpackFloatFromVec4i(const vec3 value)
{
	const vec3 bitSh = vec3( 1.0 / (256.0 * 256.0), 1.0 / 256.0, 1.0);
	return(dot(value, bitSh));
}

void main()
{
	int i;
	vec2 add=vec2(direction,1.0-direction);
	vec2 uv=gl_TexCoord[0].xy,uv2;
	vec4 col;
	float depth=unpackFloatFromVec4i(texture2D(depthpacked,uv));
	depth*=1000.0*depthscale;
	if(depth>1.0)
	depth=1.0;
	if(ivertdepth)
	depth=1.0-depth;
	depth=pow(depth,3.0);
	depth=distance(depth,focus_z);
	
	for(i=0;i<10;i++)
	{
	 uv2=uv+add*vec2(i-5.0)*blurstrength*vec2(depth)/100.0;
	 col+=texture2D(colormap,uv2);
	}
	gl_FragColor = gl_Color*col/vec4(i);
}
