
uniform float time,dist,scale,translatex,translatey,translatez;
varying vec3 vert,pos,nor;

uniform int AO_ENABLED;
float signal(float t)
{
	t=fract(t);
	if(t>.5+(dist)/3.0)
	return 1.0;
	else  
	return 0.0;
}
vec3 packFloatToVec3i(const float value)
{
	const vec3 bitSh = vec3( 256.0 * 256.0, 256.0, 1.0);
	const vec3 bitMsk = vec3( 1.0 / 256.0, 1.0 / 256.0, 1.0 / 256.0);
	vec3 res = fract(value * bitSh);
	res -= res.xxy * bitMsk;
	return res;
}

vec3 rotvec (vec3 invect, float u, float v, float w, float aa)
{
    float ux = u*invect.x;
    float uy = u*invect.y;
    float uz = u*invect.z;
    float vx = v*invect.x;
    float vy = v*invect.y;
    float vz = v*invect.z;
    float wx = w*invect.x;
    float wy = w*invect.y;
    float wz = w*invect.z;
    float sa;
    float ca;
	vec3 ret;
    sa = sin(aa);
    ca = cos(aa);
    ret.x = u*(ux+vy+wz)+(invect.x*(v*v+w*w)-u*(vy+wz))*ca+(-wy+vz)*sa;
    ret.y = v*(ux+vy+wz)+(invect.y*(u*u+w*w)-v*(ux+wz))*ca+(wx-uz)*sa;
    ret.z = w*(ux+vy+wz)+(invect.z*(u*u+v*v)-w*(ux+vy))*ca+(-vx+uy)*sa;
	return ret;
}

void main()
{

	float a,t=time/100.0;
	int i;
	vec3 v=vert;

		v.x+=sin(vert.y*1.0);
		v.z+=cos(-vert.y*1.0);
		v.y+=cos(vert.z*1.0)+sin(vert.x);
		v= rotvec(v,1.0,0.1,2.0,sin(a*842.0+t/11.0)*1000.0)*vec3(scale);
		a+=signal(v.z)+signal(v.x)+signal(v.y);
		v= rotvec(v*vec3(scale),0.0,0.0,1.0,cos(a*142.0+t/14.0)*1840.0)*12.0+vec3(translatex,translatey,translatez);
		a+=+signal(v.x)+signal(v.y)+signal(v.z);

	if(a>=1.0)
	a=1.0;
	else
	discard;
	if(AO_ENABLED==0)
	{
	gl_FragColor = vec4(a)*gl_Color;
	}
	if(AO_ENABLED==1)
	{
		gl_FragColor=vec4(packFloatToVec3i(float(pos.z)/500.0),1);
	}
	if(AO_ENABLED==2)
	{
		gl_FragColor=vec4(vec3(.5)*(nor+vec3(1)),1);
	}

}
