varying vec3 lightVec; 
varying vec3 eyeVec;
varying vec2 texCoord,texCoord2,texCoord3,xy;
attribute vec3 vTangent; 		


varying vec4 v_position;
varying vec3 v_normal;
 
void main(void)
{
	gl_Position = ftransform();
	texCoord.x = gl_MultiTexCoord0.x;
	texCoord.y = gl_MultiTexCoord0.y;
	texCoord2=gl_Vertex.xy;
	texCoord3=gl_Vertex.xz;
	vec3 n = normalize(gl_NormalMatrix * gl_Normal);
	vec3 t = normalize(gl_NormalMatrix * vTangent);
	vec3 b = cross(n, t);
	vec3 vVertex = vec3(gl_ModelViewMatrix * gl_Vertex);
	vec3 tmpVec = gl_LightSource[0].position.xyz - vVertex;
	lightVec.x = dot(tmpVec, t);
	lightVec.y = dot(tmpVec, b);
	lightVec.z = dot(tmpVec, n);
	tmpVec = -vVertex;
	eyeVec.x = dot(tmpVec, t);
	eyeVec.y = dot(tmpVec, b);
	eyeVec.z = dot(tmpVec, n);
		xy = (vec4(0.5) + vec4(1.0/gl_Position.z)*gl_Position/vec4(2.5)).xy;
        fract(xy.x);
	gl_FogFragCoord = length(gl_Position.xyz);

	v_position=gl_Position;
	v_normal=n;
}
