varying vec3 lightVec; 
varying vec3 eyeVec;
varying vec2 texCoord,texCoord2,texCoord3,xy;
attribute vec3 vTangent; 	
varying vec3 normal;
varying vec4 v_position;
varying vec3 v_normal;
vec3 rotvec (vec3 invect, float u, float v, float w, float a)
{
	
    float ux = u*invect.x;
    float uy = u*invect.y;
    float uz = u*invect.z;
    float vx = v*invect.x;
    float vy = v*invect.y;
    float vz = v*invect.z;
    float wx = w*invect.x;
    float wy = w*invect.y;
    float wz = w*invect.z;
    float sa;
    float ca;
	vec3 ret;
    sa = sin(a);
    ca = cos(a);
    ret.x = u*(ux+vy+wz)+(invect.x*(v*v+w*w)-u*(vy+wz))*ca+(-wy+vz)*sa;
    ret.y = v*(ux+vy+wz)+(invect.y*(u*u+w*w)-v*(ux+wz))*ca+(wx-uz)*sa;
    ret.z = w*(ux+vy+wz)+(invect.z*(u*u+v*v)-w*(ux+vy))*ca+(-vx+uy)*sa;
	return ret;
}

void main(void)
{
	gl_Position = ftransform();
	vec3 vert1,vert2;
	vert1=rotvec(gl_Vertex.xyz,.1,.2,1.0,1.0);	
	vert2=rotvec(gl_Vertex.xyz,.1,1.0,.3,1.1);	
	texCoord.xy =gl_MultiTexCoord0.xy;
	texCoord2=vert2.xy;
	texCoord3=vert1.yz;

	vec3 n = normalize(gl_NormalMatrix * gl_Normal);
	normal=n;
	vec3 t = normalize(gl_NormalMatrix * vTangent);
	vec3 b = cross(n, t);
	vec3 vVertex = vec3(gl_ModelViewMatrix * gl_Vertex);
	vec3 tmpVec = gl_LightSource[0].position.xyz - vVertex;
	lightVec.x = dot(tmpVec, t);
	lightVec.y = dot(tmpVec, b);
	lightVec.z = dot(tmpVec, n);
	tmpVec = -vVertex;
	eyeVec.x = dot(tmpVec, t);
	eyeVec.y = dot(tmpVec, b);
	eyeVec.z = dot(tmpVec, n);
		xy = (0.5 + 1.0/gl_Position.z*gl_Position/2.5).xy;
        fract(xy.x);
	gl_FogFragCoord = length(gl_Position.xyz);


	v_position=gl_Position;
	v_normal=normal;

}
