varying vec3 lightVec; 
varying vec3 eyeVec;
varying vec2 texCoord;
attribute vec3 vTangent; 		

varying vec4 v_position;
varying vec3 v_normal;
 
void main(void)
{
	texCoord = gl_MultiTexCoord0.xy;
	vec3 n = normalize(gl_NormalMatrix * vec3(1,1,1));
	vec3 t = normalize(gl_NormalMatrix * vTangent);
	vec3 b = cross(n, t);
	vec3 vVertex = vec3(gl_ModelViewMatrix * gl_Vertex);
	vec3 tmpVec = gl_LightSource[0].position.xyz - vVertex;
	lightVec.x = dot(tmpVec, t);
	lightVec.y = dot(tmpVec, b);
	lightVec.z = dot(tmpVec, n);
	tmpVec = -vVertex;
	eyeVec.x = dot(tmpVec, t);
	eyeVec.y = dot(tmpVec, b);
	eyeVec.z = dot(tmpVec, n);
	gl_Position = ftransform();
	gl_FogFragCoord = length(gl_Position.xyz);

	v_position=gl_Position;
	v_normal=normalize(gl_NormalMatrix * gl_Normal);

}