varying vec3 lightVec;
varying vec3 eyeVec;

uniform sampler2D tex,refl;
uniform float time,uvscale,waveamp,wavefreq,amount;
varying vec3 pos,nor;

vec3 packFloatToVec3i(const float value)
{
	const vec3 bitSh = vec3( 256.0 * 256.0, 256.0, 1.0);
	const vec3 bitMsk = vec3( 1.0 / 256.0, 1.0 / 256.0, 1.0 / 256.0);
	vec3 res = fract(value * bitSh);
	res -= res.xxy * bitMsk;
	return res;
}

float unpackFloatFromVec4i(const vec3 value)
{
	const vec3 bitSh = vec3( 1.0 / (256.0 * 256.0), 1.0 / 256.0, 1.0);
	return(dot(value, bitSh));
}

vec4 ShadeEnv(sampler2D env,vec3 nor)
{
    vec2 i;
	vec3 rd;
	rd=reflect(pos,nor);
    i.y = dot(normalize(rd),vec3(0.0,1.0,0.0));
    rd.y=0.0;
    i.x = dot(normalize(rd),vec3(1.0,0.0,0.0))*0.5;
	if (rd.z >= 0.0)
    i = (i + 1.0) * 0.5;
    else
    {i.t = (i.t + 1.0) * 0.5;
    i.s = (-i.s) * 0.5 + 1.0;}
	return texture2D(env,-i);
}

uniform int AO_ENABLED;
void main()
{
	vec2 uv=gl_TexCoord[0].xy*uvscale+vec2(sin(time/16.0)+time/60.0,.8);
	uv.x+=sin(uv.y*wavefreq+time)*waveamp;	
	uv.y+=sin(uv.x*wavefreq+time)*waveamp;		
	vec2 uv2=gl_TexCoord[0].xy*uvscale+vec2(cos(time/16.0-122.0)+time/40.0,time/180.0);
	uv2.x+=sin(-uv2.y*wavefreq+time+.7)*waveamp;	
	uv2.y+=cos(uv2.x*wavefreq+time)*waveamp;	
	vec4 col=(texture2D(tex,uv)+gl_Color*texture2D(tex,uv2));
	col-=.5;
	if(AO_ENABLED==0)
	{
	vec3 lVec = lightVec * inversesqrt(dot(lightVec, lightVec));
	vec3 vVec = normalize(eyeVec.xyz);
    float specular = pow(clamp(dot(reflect(-lVec, normalize(col)), vVec), 0.0, 1.0),gl_FrontMaterial.shininess );
	vec4 vSpecular = gl_LightSource[0].specular * gl_FrontMaterial.specular * specular;	
	gl_FragColor = vSpecular+texture2D(refl,gl_TexCoord[1].xy/vec2(2)+col.xy*amount/vec2(4)-vec2(.5))*gl_Color;
	}
	if(AO_ENABLED==1)
	{
		gl_FragColor=vec4(packFloatToVec3i(float(pos.z)/500.0),1);
	}
	if(AO_ENABLED==2)
	{
		gl_FragColor=vec4(vec3(.5)*(nor+vec3(1)+col*amount),1);
	}
}
