uniform sampler2D tex;
varying vec2 offs;

uniform float bright;
uniform float spread;
uniform float frequency;
uniform float expfactor;

void main()
{
	vec4 texel = texture2D(tex, offs);//vec4(0.0, 0.0, 0.0, 0.0);
	float lum = texel.r * 0.3 + texel.g * 0.59 + texel.b * 0.11;
	float b = bright * pow(lum, expfactor);

	float phase = 0.0;
	
	float off = sin(offs.y * frequency + phase) * spread;
	
	texel.r += texture2D(tex, offs + vec2(0, off)).r * b;
	texel.g += texture2D(tex, offs + vec2(0, -off)).g * b;
	texel.b += texture2D(tex, offs + vec2(0, -off * 2.0)).b * b;
	
	gl_FragColor = texel;
}
