#version 330 core

struct Material
{
	vec3 emissive;
	vec3 ambient;
	vec3 diffuse;
	vec3 specular;
	float shininess;
	float opacity;
};

// Inputs
in vec2 ex_TexCoord;

// Outputs
out vec4 out_FragColor;

// Uniforms
uniform Material uMaterial;
uniform sampler2D ambientSampler;

void main()
{
	vec3 ambientReflectance = pow(texture(ambientSampler, ex_TexCoord).rgb, vec3(2.2));

	// output the final color
	out_FragColor = vec4(uMaterial.emissive + uMaterial.ambient * ambientReflectance, 1.0);
}
