#version 330 core

// Semantics
#define ATTR_POSITION	0
#define ATTR_NORMAL		1
#define ATTR_TANGENT	2
#define ATTR_COLOR		3
#define ATTR_TEXCOORD	4

// Inputs
layout (location = ATTR_POSITION) in vec4 in_Position;
layout (location = ATTR_NORMAL  ) in vec4 in_Normal;
layout (location = ATTR_TANGENT ) in vec4 in_Tangent;
layout (location = ATTR_TEXCOORD) in vec2 in_TexCoord;

// Outputs
out vec2 ex_TexCoord;

// Uniforms
uniform mat4 worldViewProjMatrix;

void main()
{
	gl_Position = worldViewProjMatrix * in_Position;
	ex_TexCoord = in_TexCoord;
}
