#version 330 core

// Input
in vec2 ex_TexCoord;

// Output
out vec4 out_FragColor;

// Uniforms
uniform sampler2D colorSampler;

void main()
{
	vec4 color = texture(colorSampler, ex_TexCoord);

	// the alpha channel control how much color we copy so one 
	// can make a part glowing more than another one.
	out_FragColor = vec4(color.rgb * color.a, 1.);
}
