#version 330 core

// Input
layout (location = 0) in vec4 in_Position;

// Output
out vec3 ex_Position;

// Uniforms
uniform mat4 worldMatrix;
uniform mat4 viewMatrix;
uniform mat4 projMatrix;

void main()
{
	vec4 positionInView = viewMatrix * worldMatrix * in_Position;

	gl_Position = projMatrix * positionInView;
	ex_Position = positionInView.xyz;
}
