#version 330 core

uniform sampler2D tex0;
uniform float loadingTime;

in vec2 ex_TexCoord;

out vec4 out_color;

void main()
{
	float PI = 3.14159265358979323846264;

	vec4 color = texture(tex0, ex_TexCoord);

	float f = (loadingTime - (1.0 - ex_TexCoord.x)) * 8.0;
	f = clamp(f, 0.1, 2.0);

	color *= f;

	out_color =  color;// * sin(loadingTime * PI);
	out_color.a = 1.0;
}
