#version 330 core

uniform sampler2D colorTexture;
uniform float time;

in vec2 ex_TexCoord;

out vec4 outColor;

void main()
{
	outColor = vec4(0.0);

	// center the texcoords a bit with a progressive zoom
	float t = time * 0.5;
	vec2 uv = ex_TexCoord * (3.0 - t);

	uv -= vec2(1.0 - (t * 0.5));

	if (uv.x < 0.0 || uv.x > 1.0 || uv.y < 0.0 || uv.y > 1.0)
		discard;

	outColor = texture(colorTexture, uv) * smoothstep(0.0, 1.0, 1.0 - time);
	outColor.a = 1.0;
}