uniform mat4 World;
uniform mat4 View;
uniform mat4 Proj;

uniform float Height;
uniform float TexScale;
uniform float TexOffset;

void main()
{
	TexCoord = (gl_MultiTexCoord0.xy + vec2(0, TexOffset)) * TexScale;

	vec4 vert = gl_Vertex;
	ObjPos = vec4(vert.x, height(TexCoord) * Height, vert.z, vert.w);

	vec4 worldPos = World * ObjPos + vec4(0, 0, Move, 0);
	vec4 viewPos = View * worldPos;
	ViewDistance = -viewPos.z;
	gl_Position = Proj * viewPos;
}
