uniform float Fade;

varying vec3 Pos;
varying vec2 Uv;
varying vec4 Color;

varying vec3 Btnx;
varying vec3 Btny;
varying vec3 Btnz;

void main()
{
	Pos = (gl_ModelViewMatrix * gl_Vertex).xyz;
	Uv = gl_MultiTexCoord0.xy * 2.4;
	Color = mix(vec4(1), vec4(0), max(Pos.z / -400.0, -400.0)) * Fade;

	vec3 normal = gl_NormalMatrix * gl_Normal;
	vec3 tangent = vec3(0.0, 1.0, 0.0);
	if (normal == tangent)
	{
		tangent = vec3(1.0, 0.0, 0.0);
	}
	else
	{
		float d = dot(tangent, normal);
		tangent = normalize(tangent - normal * d);
	}
	vec3 binormal = cross(tangent, normal);
	Btnx = vec3(binormal.x, tangent.x, normal.x);
	Btny = vec3(binormal.y, tangent.y, normal.y);
	Btnz = vec3(binormal.z, tangent.z, normal.z);
	
	gl_Position = ftransform();
}