/*
 * Decompiled with CFR 0.152.
 */
package toxi.geom;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import toxi.geom.Circle;
import toxi.geom.Line2D;
import toxi.geom.Polygon2D;
import toxi.geom.ReadonlyVec2D;
import toxi.geom.ReadonlyVec3D;
import toxi.geom.Rect;
import toxi.geom.Shape2D;
import toxi.geom.Vec2D;
import toxi.geom.Vec3D;
import toxi.math.MathUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class Triangle2D
implements Shape2D {
    @XmlElement(required=true)
    public Vec2D a;
    @XmlElement(required=true)
    public Vec2D b;
    @XmlElement(required=true)
    public Vec2D c;
    @XmlTransient
    public Vec2D centroid;

    public static Triangle2D createEquilateralFrom(ReadonlyVec2D readonlyVec2D, ReadonlyVec2D readonlyVec2D2) {
        Vec2D vec2D = readonlyVec2D.interpolateTo(readonlyVec2D2, 0.5f);
        Vec2D vec2D2 = readonlyVec2D.sub(readonlyVec2D2);
        Vec2D vec2D3 = vec2D2.getPerpendicular();
        vec2D.addSelf(vec2D3.normalizeTo(vec2D2.magnitude() * MathUtils.SQRT3 / 2.0f));
        return new Triangle2D(readonlyVec2D, readonlyVec2D2, vec2D);
    }

    public static boolean isClockwise(Vec2D vec2D, Vec2D vec2D2, Vec2D vec2D3) {
        float f = (vec2D2.x - vec2D.x) * (vec2D3.y - vec2D.y) - (vec2D3.x - vec2D.x) * (vec2D2.y - vec2D.y);
        return (double)f < 0.0;
    }

    public Triangle2D() {
    }

    public Triangle2D(ReadonlyVec2D readonlyVec2D, ReadonlyVec2D readonlyVec2D2, ReadonlyVec2D readonlyVec2D3) {
        this.a = readonlyVec2D.copy();
        this.b = readonlyVec2D2.copy();
        this.c = readonlyVec2D3.copy();
    }

    public Triangle2D adjustTriangleSizeBy(float f) {
        return this.adjustTriangleSizeBy(f, f, f);
    }

    public Triangle2D adjustTriangleSizeBy(float f, float f2, float f3) {
        this.computeCentroid();
        Line2D line2D = new Line2D(this.a.copy(), this.b.copy()).offsetAndGrowBy(f, 100000.0f, this.centroid);
        Line2D line2D2 = new Line2D(this.b.copy(), this.c.copy()).offsetAndGrowBy(f2, 100000.0f, this.centroid);
        Line2D line2D3 = new Line2D(this.c.copy(), this.a.copy()).offsetAndGrowBy(f3, 100000.0f, this.centroid);
        this.a = line2D.intersectLine(line2D3).getPos();
        this.b = line2D.intersectLine(line2D2).getPos();
        this.c = line2D2.intersectLine(line2D3).getPos();
        this.computeCentroid();
        return this;
    }

    public Vec2D computeCentroid() {
        this.centroid = this.a.add(this.b).addSelf(this.c).scaleSelf(0.33333334f);
        return this.centroid;
    }

    public boolean containsPoint(ReadonlyVec2D readonlyVec2D) {
        Vec2D vec2D = readonlyVec2D.sub(this.a).normalize();
        Vec2D vec2D2 = readonlyVec2D.sub(this.b).normalize();
        Vec2D vec2D3 = readonlyVec2D.sub(this.c).normalize();
        double d = Math.acos(vec2D.dot(vec2D2));
        d += Math.acos(vec2D2.dot(vec2D3));
        return MathUtils.abs((float)(d += Math.acos(vec2D3.dot(vec2D))) - (float)Math.PI * 2) <= 0.01f;
    }

    public Triangle2D copy() {
        return new Triangle2D(this.a.copy(), this.b.copy(), this.c.copy());
    }

    public Triangle2D flipVertexOrder() {
        Vec2D vec2D = this.a;
        this.a = this.c;
        this.c = vec2D;
        return this;
    }

    public Vec2D fromBarycentric(ReadonlyVec3D readonlyVec3D) {
        return new Vec2D(this.a.x * readonlyVec3D.x() + this.b.x * readonlyVec3D.y() + this.c.x * readonlyVec3D.z(), this.a.y * readonlyVec3D.x() + this.b.y * readonlyVec3D.y() + this.c.y * readonlyVec3D.z());
    }

    public float getArea() {
        return this.b.sub(this.a).cross(this.c.sub(this.a)) * 0.5f;
    }

    public Rect getBounds() {
        return new Rect(Vec2D.min(Vec2D.min(this.a, this.b), this.c), Vec2D.max(Vec2D.max(this.a, this.b), this.c));
    }

    public Circle getCircumCircle() {
        Vec3D vec3D = this.a.bisect(this.b).cross(this.b.bisect(this.c));
        Vec2D vec2D = new Vec2D(vec3D.x / vec3D.z, vec3D.y / vec3D.z);
        float f = this.a.distanceTo(this.b);
        float f2 = this.b.distanceTo(this.c);
        float f3 = this.c.distanceTo(this.a);
        float f4 = f * f2 * f3 / (float)Math.sqrt((f + f2 + f3) * (-f + f2 + f3) * (f - f2 + f3) * (f + f2 - f3));
        return new Circle((ReadonlyVec2D)vec2D, f4);
    }

    public float getCircumference() {
        return this.a.distanceTo(this.b) + this.b.distanceTo(this.c) + this.c.distanceTo(this.a);
    }

    public Vec2D getClosestPointTo(ReadonlyVec2D readonlyVec2D) {
        Line2D line2D = new Line2D(this.a, this.b);
        Vec2D vec2D = line2D.closestPointTo(readonlyVec2D);
        Vec2D vec2D2 = line2D.set(this.b, this.c).closestPointTo(readonlyVec2D);
        Vec2D vec2D3 = line2D.set(this.c, this.a).closestPointTo(readonlyVec2D);
        float f = readonlyVec2D.sub(vec2D).magSquared();
        float f2 = readonlyVec2D.sub(vec2D2).magSquared();
        float f3 = readonlyVec2D.sub(vec2D3).magSquared();
        float f4 = f;
        Vec2D vec2D4 = vec2D;
        if (f2 < f4) {
            f4 = f2;
            vec2D4 = vec2D2;
        }
        if (f3 < f4) {
            vec2D4 = vec2D3;
        }
        return vec2D4;
    }

    public boolean intersectsTriangle(Triangle2D triangle2D) {
        if (this.containsPoint(triangle2D.a) || this.containsPoint(triangle2D.b) || this.containsPoint(triangle2D.c)) {
            return true;
        }
        if (triangle2D.containsPoint(this.a) || triangle2D.containsPoint(this.b) || triangle2D.containsPoint(this.c)) {
            return true;
        }
        Line2D[] line2DArray = new Line2D[]{new Line2D(this.a, this.b), new Line2D(this.b, this.c), new Line2D(this.c, this.a)};
        Line2D[] line2DArray2 = new Line2D[]{new Line2D(triangle2D.a, triangle2D.b), new Line2D(triangle2D.b, triangle2D.c), new Line2D(triangle2D.c, triangle2D.a)};
        for (Line2D line2D : line2DArray) {
            for (Line2D line2D2 : line2DArray2) {
                Line2D.LineIntersection.Type type = line2D.intersectLine(line2D2).getType();
                if (type == Line2D.LineIntersection.Type.NON_INTERSECTING || type == Line2D.LineIntersection.Type.PARALLEL) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isClockwise() {
        return Triangle2D.isClockwise(this.a, this.b, this.c);
    }

    public void set(Vec2D vec2D, Vec2D vec2D2, Vec2D vec2D3) {
        this.a = vec2D;
        this.b = vec2D2;
        this.c = vec2D3;
    }

    public Polygon2D toPolygon2D() {
        Polygon2D polygon2D = new Polygon2D();
        polygon2D.add(this.a.copy());
        polygon2D.add(this.b.copy());
        polygon2D.add(this.c.copy());
        return polygon2D;
    }

    public String toString() {
        return "Triangle2D: " + this.a + "," + this.b + "," + this.c;
    }
}

