/*
 * Decompiled with CFR 0.152.
 */
package toxi.geom;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import toxi.geom.AABB;
import toxi.geom.Line3D;
import toxi.geom.ReadonlyVec3D;
import toxi.geom.Shape3D;
import toxi.geom.Vec3D;
import toxi.math.MathUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class Triangle3D
implements Shape3D {
    @XmlElement(required=true)
    public Vec3D a;
    @XmlElement(required=true)
    public Vec3D b;
    @XmlElement(required=true)
    public Vec3D c;
    @XmlElement(required=true)
    public Vec3D normal;
    @XmlTransient
    public Vec3D centroid;

    public static Triangle3D createEquilateralFrom(Vec3D vec3D, Vec3D vec3D2) {
        Vec3D vec3D3 = vec3D.interpolateTo(vec3D2, 0.5f);
        Vec3D vec3D4 = vec3D2.sub(vec3D);
        Vec3D vec3D5 = vec3D.cross(vec3D4.normalize());
        vec3D3.addSelf(vec3D5.normalizeTo(vec3D4.magnitude() * MathUtils.SQRT3 / 2.0f));
        return new Triangle3D(vec3D, vec3D2, vec3D3);
    }

    public static boolean isClockwiseInXY(Vec3D vec3D, Vec3D vec3D2, Vec3D vec3D3) {
        float f = (vec3D2.x - vec3D.x) * (vec3D3.y - vec3D.y) - (vec3D3.x - vec3D.x) * (vec3D2.y - vec3D.y);
        return (double)f < 0.0;
    }

    public static boolean isClockwiseInXZ(Vec3D vec3D, Vec3D vec3D2, Vec3D vec3D3) {
        float f = (vec3D2.x - vec3D.x) * (vec3D3.z - vec3D.z) - (vec3D3.x - vec3D.x) * (vec3D2.z - vec3D.z);
        return (double)f < 0.0;
    }

    public static boolean isClockwiseInYZ(Vec3D vec3D, Vec3D vec3D2, Vec3D vec3D3) {
        float f = (vec3D2.y - vec3D.y) * (vec3D3.z - vec3D.z) - (vec3D3.y - vec3D.y) * (vec3D2.z - vec3D.z);
        return (double)f < 0.0;
    }

    public Triangle3D() {
    }

    public Triangle3D(Vec3D vec3D, Vec3D vec3D2, Vec3D vec3D3) {
        this.a = vec3D;
        this.b = vec3D2;
        this.c = vec3D3;
    }

    public Vec3D closestPointOnSurface(Vec3D vec3D) {
        Vec3D vec3D2 = this.b.sub(this.a);
        Vec3D vec3D3 = this.c.sub(this.a);
        Vec3D vec3D4 = this.c.sub(this.b);
        Vec3D vec3D5 = vec3D.sub(this.a);
        Vec3D vec3D6 = vec3D.sub(this.b);
        Vec3D vec3D7 = vec3D.sub(this.c);
        Vec3D vec3D8 = this.a.sub(vec3D);
        Vec3D vec3D9 = this.b.sub(vec3D);
        Vec3D vec3D10 = this.c.sub(vec3D);
        float f = vec3D5.dot((ReadonlyVec3D)vec3D2);
        float f2 = vec3D5.dot((ReadonlyVec3D)vec3D3);
        if (f <= 0.0f && f2 <= 0.0f) {
            return this.a;
        }
        float f3 = vec3D6.dot((ReadonlyVec3D)this.a.sub(this.b));
        float f4 = vec3D7.dot((ReadonlyVec3D)this.a.sub(this.c));
        float f5 = vec3D6.dot((ReadonlyVec3D)vec3D4);
        float f6 = vec3D7.dot((ReadonlyVec3D)this.b.sub(this.c));
        if (f3 <= 0.0f && f5 <= 0.0f) {
            return this.b;
        }
        if (f4 <= 0.0f && f6 <= 0.0f) {
            return this.c;
        }
        Vec3D vec3D11 = vec3D2.cross(vec3D3);
        float f7 = vec3D11.dot((ReadonlyVec3D)vec3D8.crossSelf(vec3D9));
        if (f7 <= 0.0f && f >= 0.0f && f3 >= 0.0f) {
            return this.a.add(vec3D2.scaleSelf(f / (f + f3)));
        }
        float f8 = vec3D11.dot((ReadonlyVec3D)vec3D9.crossSelf(vec3D10));
        if (f8 <= 0.0f && f5 >= 0.0f && f6 >= 0.0f) {
            return this.b.add(vec3D4.scaleSelf(f5 / (f5 + f6)));
        }
        float f9 = vec3D11.dot((ReadonlyVec3D)vec3D10.crossSelf(vec3D8));
        if (f9 <= 0.0f && f2 >= 0.0f && f4 >= 0.0f) {
            return this.a.add(vec3D3.scaleSelf(f2 / (f2 + f4)));
        }
        float f10 = f8 / (f8 + f9 + f7);
        float f11 = f9 / (f8 + f9 + f7);
        float f12 = 1.0f - f10 - f11;
        return this.a.scale(f10).addSelf(this.b.scale(f11)).addSelf(this.c.scale(f12));
    }

    public Vec3D computeCentroid() {
        this.centroid = this.a.add(this.b).addSelf(this.c).scaleSelf(0.33333334f);
        return this.centroid;
    }

    public Vec3D computeNormal() {
        this.normal = this.a.sub(this.c).crossSelf(this.a.sub(this.b)).normalize();
        return this.normal;
    }

    public boolean containsPoint(ReadonlyVec3D readonlyVec3D) {
        if (((Object)readonlyVec3D).equals(this.a) || ((Object)readonlyVec3D).equals(this.b) || ((Object)readonlyVec3D).equals(this.c)) {
            return true;
        }
        Vec3D vec3D = readonlyVec3D.sub(this.a).normalize();
        Vec3D vec3D2 = readonlyVec3D.sub(this.b).normalize();
        Vec3D vec3D3 = readonlyVec3D.sub(this.c).normalize();
        double d = Math.acos(vec3D.dot(vec3D2));
        d += Math.acos(vec3D2.dot(vec3D3));
        return MathUtils.abs((float)(d += Math.acos(vec3D3.dot(vec3D))) - (float)Math.PI * 2) <= 0.005f;
    }

    public Triangle3D flipVertexOrder() {
        Vec3D vec3D = this.a;
        this.a = this.c;
        this.c = vec3D;
        return this;
    }

    public Vec3D fromBarycentric(ReadonlyVec3D readonlyVec3D) {
        return new Vec3D(this.a.x * readonlyVec3D.x() + this.b.x * readonlyVec3D.y() + this.c.x * readonlyVec3D.z(), this.a.y * readonlyVec3D.x() + this.b.y * readonlyVec3D.y() + this.c.y * readonlyVec3D.z(), this.a.z * readonlyVec3D.x() + this.b.z * readonlyVec3D.y() + this.c.z * readonlyVec3D.z());
    }

    public AABB getBoundingBox() {
        Vec3D vec3D = Vec3D.min(Vec3D.min(this.a, this.b), this.c);
        Vec3D vec3D2 = Vec3D.max(Vec3D.max(this.a, this.b), this.c);
        return AABB.fromMinMax(vec3D, vec3D2);
    }

    public Vec3D getClosestPointTo(ReadonlyVec3D readonlyVec3D) {
        Line3D line3D = new Line3D(this.a, this.b);
        Vec3D vec3D = line3D.closestPointTo(readonlyVec3D);
        Vec3D vec3D2 = line3D.set(this.b, this.c).closestPointTo(readonlyVec3D);
        Vec3D vec3D3 = line3D.set(this.c, this.a).closestPointTo(readonlyVec3D);
        float f = readonlyVec3D.sub(vec3D).magSquared();
        float f2 = readonlyVec3D.sub(vec3D2).magSquared();
        float f3 = readonlyVec3D.sub(vec3D3).magSquared();
        float f4 = f;
        Vec3D vec3D4 = vec3D;
        if (f2 < f4) {
            f4 = f2;
            vec3D4 = vec3D2;
        }
        if (f3 < f4) {
            vec3D4 = vec3D3;
        }
        return vec3D4;
    }

    public boolean isClockwiseInXY() {
        return Triangle3D.isClockwiseInXY(this.a, this.b, this.c);
    }

    public boolean isClockwiseInXZ() {
        return Triangle3D.isClockwiseInXY(this.a, this.b, this.c);
    }

    public boolean isClockwiseInYZ() {
        return Triangle3D.isClockwiseInXY(this.a, this.b, this.c);
    }

    public void set(Vec3D vec3D, Vec3D vec3D2, Vec3D vec3D3) {
        this.a = vec3D;
        this.b = vec3D2;
        this.c = vec3D3;
    }

    public Vec3D toBarycentric(ReadonlyVec3D readonlyVec3D) {
        Vec3D vec3D = this.b.sub(this.a).cross(this.c.sub(this.a));
        Vec3D vec3D2 = vec3D.getNormalized();
        float f = vec3D2.dot(vec3D);
        float f2 = vec3D2.dot(this.b.sub(readonlyVec3D).cross(this.c.sub(readonlyVec3D)));
        float f3 = f2 / f;
        float f4 = vec3D2.dot(this.c.sub(readonlyVec3D).cross(this.a.sub(readonlyVec3D)));
        float f5 = f4 / f;
        float f6 = 1.0f - f3 - f5;
        return new Vec3D(f3, f5, f6);
    }

    public String toString() {
        return "Triangle3D: " + this.a + "," + this.b + "," + this.c;
    }
}

