/*
 * Decompiled with CFR 0.152.
 */
package toxi.math;

import toxi.math.InterpolateStrategy;
import toxi.math.LinearInterpolation;
import toxi.math.MathUtils;
import toxi.util.datatypes.DoubleRange;

public class ScaleMap {
    protected InterpolateStrategy mapFunction = new LinearInterpolation();
    protected double interval;
    protected double mapRange;
    protected DoubleRange in;
    protected DoubleRange out;

    public ScaleMap(double d, double d2, double d3, double d4) {
        this.setInputRange(d, d2);
        this.setOutputRange(d3, d4);
    }

    public double getClippedValueFor(double d) {
        float f = MathUtils.clipNormalized((float)((d - this.in.min) / this.interval));
        return (double)this.mapFunction.interpolate(0.0f, (float)this.mapRange, f) + this.out.min;
    }

    public double getInputMedian() {
        return (this.in.min + this.in.max) * 0.5;
    }

    public DoubleRange getInputRange() {
        return this.in;
    }

    public double getMappedMedian() {
        return this.getMappedValueFor(0.5);
    }

    public double getMappedValueFor(double d) {
        float f = (float)((d - this.in.min) / this.interval);
        return (double)this.mapFunction.interpolate(0.0f, (float)this.mapRange, f) + this.out.min;
    }

    public double getOutputMedian() {
        return (this.out.min + this.out.max) * 0.5;
    }

    public DoubleRange getOutputRange() {
        return this.out;
    }

    public void setInputRange(double d, double d2) {
        this.in = new DoubleRange(d, d2);
        this.interval = d2 - d;
    }

    public void setMapFunction(InterpolateStrategy interpolateStrategy) {
        this.mapFunction = interpolateStrategy;
    }

    public void setOutputRange(double d, double d2) {
        this.out = new DoubleRange(d, d2);
        this.mapRange = d2 - d;
    }
}

